/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.property.ability.type.toggle;

import com.bawnorton.bettertrims.client.tooltip.element.TrimElementTooltipProvider;
import com.bawnorton.bettertrims.property.ability.type.TrimToggleAbility;
import com.bawnorton.bettertrims.property.ability.type.entity.ApplyMobEffectAbility;
import com.bawnorton.bettertrims.property.context.TrimmedItems;
import com.bawnorton.bettertrims.property.count.CountBasedValue;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;

public record ToggleMobEffectAbility(Holder<MobEffect> effect, CountBasedValue amplifier, boolean visible) implements TrimToggleAbility
{
    public static final MapCodec<ToggleMobEffectAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MobEffect.CODEC.fieldOf("effect").forGetter(ToggleMobEffectAbility::effect), (App)CountBasedValue.CODEC.fieldOf("amplifier").forGetter(ToggleMobEffectAbility::amplifier), (App)Codec.BOOL.optionalFieldOf("visible", (Object)true).forGetter(ToggleMobEffectAbility::visible)).apply((Applicative)instance, ToggleMobEffectAbility::new));

    public ToggleMobEffectAbility(Holder<MobEffect> effect, CountBasedValue amplifier) {
        this(effect, amplifier, true);
    }

    private MobEffectInstance getMobEffectInstance(int count) {
        return new MobEffectInstance(this.effect, -1, (int)this.amplifier.calculate(count), false, this.visible, true);
    }

    @Override
    public void start(ServerLevel level, LivingEntity wearer, TrimmedItems items) {
        wearer.addEffect(this.getMobEffectInstance(items.size()));
    }

    @Override
    public void stop(ServerLevel level, LivingEntity wearer, TrimmedItems items) {
        wearer.removeEffect(this.effect);
    }

    @Override
    public boolean usesCount() {
        return true;
    }

    @Override
    public MapCodec<? extends TrimToggleAbility> codec() {
        return CODEC;
    }

    public static class TooltipProvider
    implements TrimElementTooltipProvider<ToggleMobEffectAbility> {
        @Override
        public ClientTooltipComponent getTooltip(ClientLevel level, ToggleMobEffectAbility element, boolean includeCount) {
            return ApplyMobEffectAbility.TooltipProvider.getEffectTooltip(level, includeCount, element.effect(), element.amplifier(), (builder, styler) -> builder.build());
        }
    }
}

