/*
 * Decompiled with CFR 0.152.
 */
package mod.crontent.bootiful.boots;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Consumer;
import mod.crontent.bootiful.Bootiful;
import mod.crontent.bootiful.ModArmorMaterials;
import mod.crontent.bootiful.ModAttributes;
import mod.crontent.bootiful.ModParticles;
import mod.crontent.bootiful.interfaces.IStatusEffectPurgable;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_8051;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import org.jetbrains.annotations.Nullable;

public class ForestBootsItem
extends class_1792
implements IStatusEffectPurgable {
    private final int BONUS_INTERVAL = 50;
    private final int BONUS_RADIUS;
    private final double BONUS_CHANCE;
    private final long MAX_CONTRIBUTING_BLOCK_COUNT;
    private final Multimap<class_6880<class_1320>, class_1322> forestSpeedModifier;
    private final double forestSpeedMultiplier;
    private static double LOOT_BONUS_MULTIPLIER = Bootiful.CONFIG.forestBootsConfig.bonusLootMultiplier();
    private class_6880<class_1959> previous_biome = null;

    public ForestBootsItem(class_1792.class_1793 settings) {
        super(settings.method_66332(ModArmorMaterials.FOREST_MATERIAL, class_8051.field_41937).method_7894(class_1814.field_8907).method_57348(ForestBootsItem.getAttributeModifiers()));
        this.BONUS_RADIUS = Bootiful.CONFIG.forestBootsConfig.healBonusRadius();
        this.BONUS_CHANCE = Bootiful.CONFIG.forestBootsConfig.healBonusChance() / (double)Bootiful.CONFIG.forestBootsConfig.maxContributingBlockCount();
        this.MAX_CONTRIBUTING_BLOCK_COUNT = Bootiful.CONFIG.forestBootsConfig.maxContributingBlockCount();
        this.forestSpeedMultiplier = Bootiful.CONFIG.forestBootsConfig.forestSpeedMultiplier();
        this.forestSpeedModifier = HashMultimap.create((int)1, (int)1);
        this.forestSpeedModifier.put((Object)class_5134.field_23719, (Object)new class_1322(class_2960.method_60655((String)"bootiful", (String)"forest_boots_speed"), this.forestSpeedMultiplier, class_1322.class_1323.field_6331));
    }

    public static class_9285 getAttributeModifiers() {
        return class_9285.method_57480().method_57487(ModAttributes.NATURE_DROP_CHANCE, new class_1322(class_2960.method_60655((String)"bootiful", (String)"forest_boots_nature_drop_chance"), LOOT_BONUS_MULTIPLIER, class_1322.class_1323.field_6331), class_9274.field_49220).method_57486();
    }

    public void method_67187(class_1799 stack, class_1792.class_9635 context, class_10712 displayComponent, Consumer<class_2561> textConsumer, class_1836 type) {
        super.method_67187(stack, context, displayComponent, textConsumer, type);
        textConsumer.accept((class_2561)class_2561.method_43471((String)"item.bootiful.forest_boots_description_1").method_27692(class_124.field_1075));
        textConsumer.accept((class_2561)class_2561.method_43471((String)"item.bootiful.forest_boots_description_2").method_27692(class_124.field_1075));
        class_5250 mutablecomponent = class_2561.method_43471((String)((class_1320)class_5134.field_23719.comp_349()).method_26830());
        mutablecomponent = class_2561.method_43469((String)"attribute.modifier.plus.1", (Object[])new Object[]{(int)(this.forestSpeedMultiplier * 100.0), mutablecomponent}).method_10852(class_2561.method_30163((String)" ")).method_10852((class_2561)class_2561.method_43471((String)"tooltip.bootiful.when_in_forest")).method_27692(class_124.field_1078);
        textConsumer.accept((class_2561)mutablecomponent);
    }

    public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
        class_1657 player;
        if (!world.method_8608() && entity instanceof class_1657 && (player = (class_1657)entity).method_6118(class_1304.field_6166).method_31574((class_1792)this)) {
            this.handleBonusHealing((class_1937)world, player);
            this.handleSpeedIncrease((class_1937)world, player);
        }
        super.method_7888(stack, world, entity, slot);
    }

    private void handleBonusHealing(class_1937 world, class_1657 player) {
        if (world.method_8510() % 50L == 0L) {
            class_5819 r = world.method_8409();
            List<class_2338> natureBlocks = this.filterSurroundingBlocks(world, player);
            long amount = Math.min((long)natureBlocks.size(), this.MAX_CONTRIBUTING_BLOCK_COUNT);
            double chance = this.BONUS_CHANCE * (double)amount;
            if (r.method_43058() <= chance) {
                class_2338 block = natureBlocks.get(r.method_43048(natureBlocks.size()));
                this.executeBonus(block, player, world);
            }
        }
    }

    private List<class_2338> filterSurroundingBlocks(class_1937 world, class_1657 player) {
        List<class_2338> natureBlocks = class_2338.method_29715((class_238)player.method_5829().method_1014((double)this.BONUS_RADIUS).method_989(0.0, 1.0, 1.0)).filter(pos -> this.isInSphericalRange((class_2338)pos, player.method_24515(), this.BONUS_RADIUS)).filter(pos -> this.isInTags(world, (class_2338)pos)).map(class_2338::method_10062).toList();
        return natureBlocks;
    }

    private void executeBonus(class_2338 emanatingBlock, class_1657 player, class_1937 world) {
        class_243 blockPos = emanatingBlock.method_46558();
        class_243 connection = player.method_73189().method_1031(0.0, 1.0, 0.0).method_1020(blockPos);
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            for (int i = 0; i < 25; ++i) {
                class_243 current = blockPos.method_1019(connection.method_1021((double)i / 25.0));
                serverWorld.method_65096((class_2394)ModParticles.NATURE_PARTICLE, current.method_10216(), current.method_10214(), current.method_10215(), 1, 0.35, -0.35, 0.35, 1.25);
                if (i % 10 != 0) continue;
                serverWorld.method_65096((class_2394)class_2398.field_11201, current.method_10216(), current.method_10214(), current.method_10215(), 1, 0.15, -0.15, 0.15, 0.75);
            }
        }
        class_1293 regeneration = new class_1293(class_1294.field_5924, 50, 1, false, false, false);
        player.method_6092(regeneration);
    }

    private boolean isInTags(class_1937 world, class_2338 pos) {
        class_2680 s = world.method_8320(pos);
        return s.method_26164(class_3481.field_15475) || s.method_26164(class_3481.field_15503) || s.method_26164(class_3481.field_20341) || s.method_26164(class_3481.field_20339);
    }

    private boolean isInSphericalRange(class_2338 blockPos, class_2338 playerPos, int radius) {
        int dz;
        int dy;
        int dx = blockPos.method_10263() - playerPos.method_10263();
        double dSquared = dx * dx + (dy = blockPos.method_10264() - playerPos.method_10264()) * dy + (dz = blockPos.method_10260() - playerPos.method_10260()) * dz;
        return dSquared <= (double)(radius * radius);
    }

    private void handleSpeedIncrease(class_1937 world, class_1657 player) {
        if (!world.method_8608()) {
            class_6880 biome = world.method_23753(player.method_24515());
            if (this.previous_biome == null || !this.previous_biome.equals((Object)biome)) {
                this.previous_biome = biome;
                if (biome.method_40220(ConventionalBiomeTags.IS_FOREST) || biome.method_40220(ConventionalBiomeTags.IS_JUNGLE) || biome.method_40220(ConventionalBiomeTags.IS_VEGETATION_DENSE)) {
                    player.method_6127().method_59932(this.forestSpeedModifier);
                } else {
                    this.purgeEffects((class_1309)player);
                }
            }
        }
    }

    @Override
    public void purgeEffects(class_1309 entity) {
        entity.method_6127().method_59935(this.forestSpeedModifier);
        this.previous_biome = null;
    }
}

