/*
 * Decompiled with CFR 0.152.
 */
package mod.crontent.bootiful.mixin;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import mod.crontent.bootiful.ApplyBonusAttributeLootFunction;
import mod.crontent.bootiful.BonusAttributeLootCondition;
import mod.crontent.bootiful.Bootiful;
import mod.crontent.bootiful.ModAttributes;
import mod.crontent.bootiful.interfaces.PoolConditionsModifyHelper;
import mod.crontent.bootiful.mixin.CombinedEntryAccessor;
import mod.crontent.bootiful.mixin.ItemEntryAccessor;
import mod.crontent.bootiful.mixin.LeafEntryAccessor;
import mod.crontent.bootiful.mixin.LootPoolEntryAccessor;
import net.minecraft.class_117;
import net.minecraft.class_131;
import net.minecraft.class_156;
import net.minecraft.class_182;
import net.minecraft.class_219;
import net.minecraft.class_44;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_6880;
import net.minecraft.class_79;
import net.minecraft.class_8551;
import net.minecraft.class_94;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_55.class_56.class})
public class LootPoolBuilderAccessor
implements PoolConditionsModifyHelper {
    @Mutable
    @Shadow
    @Final
    private ImmutableList.Builder<class_79> field_960;

    @Override
    public void bootiful$wrapCondition(ArrayList<String> filterItems) {
        for (class_79 entry : this.field_960.build()) {
            this.bootiful$handleEntry(entry, filterItems);
        }
    }

    @Unique
    private void bootiful$handleEntry(class_79 entry, ArrayList<String> filterItems) {
        ItemEntryAccessor itemEntry;
        if (entry instanceof CombinedEntryAccessor) {
            CombinedEntryAccessor combinedEntry = (CombinedEntryAccessor)entry;
            combinedEntry.getChildren().forEach(child -> this.bootiful$handleEntry((class_79)child, filterItems));
        } else if (entry instanceof ItemEntryAccessor && filterItems.contains((itemEntry = (ItemEntryAccessor)entry).getItem().method_55840())) {
            Bootiful.LOGGER.debug("Working in Item Entry: {}", (Object)itemEntry.getItem().method_55840());
            if (entry instanceof LeafEntryAccessor) {
                LeafEntryAccessor leafEntry = (LeafEntryAccessor)entry;
                leafEntry.getFunctions().forEach(function -> {
                    if (function instanceof class_94) {
                        class_94 applyBonusLootFunction = (class_94)function;
                        Bootiful.LOGGER.debug("Found Function ApplyBonus in {}", (Object)leafEntry);
                        LootPoolBuilderAccessor.addFunctionToLeafEntry(leafEntry, applyBonusLootFunction);
                    }
                });
            }
            if (entry instanceof LootPoolEntryAccessor) {
                LootPoolEntryAccessor lootPoolEntry = (LootPoolEntryAccessor)entry;
                List<class_5341> newConditions = this.bootiful$getModifiedConditions(lootPoolEntry);
                LootPoolBuilderAccessor.bootiful$updateLootPool(lootPoolEntry, newConditions);
            }
        }
    }

    @Unique
    private static void addFunctionToLeafEntry(LeafEntryAccessor leafEntry, class_94 existing) {
        ArrayList<class_117> newFunctions = new ArrayList<class_117>();
        newFunctions.add((class_117)existing);
        newFunctions.add(ApplyBonusAttributeLootFunction.builder(ModAttributes.NATURE_DROP_CHANCE).method_515());
        leafEntry.setFunctions(newFunctions);
        leafEntry.setCompiledFunctions(class_131.method_594(newFunctions));
    }

    @Unique
    @NotNull
    private List<class_5341> bootiful$getModifiedConditions(LootPoolEntryAccessor lootPoolEntry) {
        ArrayList<class_5341> newConditions = new ArrayList<class_5341>();
        lootPoolEntry.getConditions().forEach(condition -> {
            if (condition instanceof class_182) {
                class_182 tableBonusLootCondition = (class_182)condition;
                Bootiful.LOGGER.debug("Found Condition TableBonus in {}", (Object)lootPoolEntry);
                newConditions.add(this.bootiful$getWrappedCondition(tableBonusLootCondition));
            } else if (condition instanceof class_219) {
                class_219 randomChanceLootCondition = (class_219)condition;
                Bootiful.LOGGER.debug("Found Condition RandomChance in {}", (Object)lootPoolEntry);
                newConditions.add(this.bootiful$getWrappedCondition(randomChanceLootCondition));
            } else {
                newConditions.add((class_5341)condition);
            }
        });
        return newConditions;
    }

    @Unique
    private class_5341 bootiful$getWrappedCondition(class_182 original) {
        List originalChances = original.comp_1868();
        class_6880 originalEnchantment = original.comp_1867();
        float[] chances = new float[originalChances.size()];
        for (int i = 0; i < originalChances.size(); ++i) {
            chances[i] = ((Float)originalChances.get(i)).floatValue();
        }
        return class_8551.method_51727((class_5341.class_210[])new class_5341.class_210[]{class_182.method_800((class_6880)originalEnchantment, (float[])chances), BonusAttributeLootCondition.builder(ModAttributes.NATURE_DROP_CHANCE, chances[0])}).build();
    }

    @Unique
    private class_5341 bootiful$getWrappedCondition(class_219 original) {
        return class_8551.method_51727((class_5341.class_210[])new class_5341.class_210[]{class_219.method_60310((class_5658)original.comp_2781()), BonusAttributeLootCondition.builder(ModAttributes.NATURE_DROP_CHANCE, ((class_44)original.comp_2781()).comp_1895())}).build();
    }

    @Unique
    private static void bootiful$updateLootPool(LootPoolEntryAccessor lootPoolEntry, List<class_5341> newConditions) {
        lootPoolEntry.setConditions(newConditions);
        lootPoolEntry.setConditionPredicate(class_156.method_56613(newConditions));
    }
}

