/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.lititup.mixin.compatibility;

import com.eruannie_9.lititup.ModConfiguration;
import com.eruannie_9.lititup.util.EnvironmentCheck;
import com.eruannie_9.lititup.util.interfaces.IIgnited;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.betterfurnaces.blockentity.SmeltingBlockEntity;
import wily.betterfurnaces.init.Registration;
import wily.betterfurnaces.items.UpgradeItem;

@Mixin(value={SmeltingBlockEntity.class})
public class SmelterBetterManagerMixin
implements IIgnited {
    @Unique
    private boolean ignited = false;

    @Override
    public void setIgnitedByPlayer(boolean ignited) {
        this.ignited = ignited;
    }

    @Override
    public boolean isIgnitedByPlayer() {
        return this.ignited;
    }

    @Inject(method={"load"}, at={@At(value="TAIL")})
    public void onLoad(CompoundTag tag, CallbackInfo ci) {
        this.ignited = tag.m_128471_("Ignited");
    }

    @Inject(method={"saveAdditional"}, at={@At(value="TAIL")})
    public void onSave(CompoundTag tag, CallbackInfo ci) {
        tag.m_128379_("Ignited", this.ignited);
    }

    @Inject(method={"canSmelt"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void onSmeltValid(@Nullable Recipe<?> recipe, int INPUT, int OUTPUT, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)ModConfiguration.BETTER_FURNACE.get()).booleanValue()) {
            boolean hasEnergy;
            SmeltingBlockEntity furnace = (SmeltingBlockEntity)this;
            if (this.isActive(furnace)) {
                return;
            }
            Level world = furnace.m_58904_();
            BlockPos pos = furnace.m_58899_();
            boolean hasLavaOrFireBelow = EnvironmentCheck.isHeatSourceBelow(world, pos);
            boolean isRainingAbove = EnvironmentCheck.isPrecipitationAbove(world, pos);
            boolean hasLiquidFuel = furnace.isLiquid() && furnace.fluidTank.getFluidStack().getAmount() > 0L;
            boolean bl = hasEnergy = furnace.hasUpgrade((UpgradeItem)Registration.ENERGY.get()) && furnace.energyStorage.getEnergyStored() >= furnace.EnergyUse();
            if (hasLiquidFuel || hasEnergy) {
                cir.setReturnValue((Object)true);
                return;
            }
            if (!(this.isIgnitedByPlayer() || hasLavaOrFireBelow && !isRainingAbove && ((Boolean)ModConfiguration.HOT_BLOCK_IGNITION.get()).booleanValue())) {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"canGeneratorWork"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void invalidateCanGeneratorWork(CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)ModConfiguration.BETTER_FURNACE.get()).booleanValue()) {
            SmeltingBlockEntity furnace = (SmeltingBlockEntity)this;
            if (this.isActive(furnace)) {
                return;
            }
            Level world = furnace.m_58904_();
            BlockPos pos = furnace.m_58899_();
            boolean hasLavaOrFireBelow = EnvironmentCheck.isHeatSourceBelow(world, pos);
            boolean isRainingAbove = EnvironmentCheck.isPrecipitationAbove(world, pos);
            if (!(this.isIgnitedByPlayer() || hasLavaOrFireBelow && !isRainingAbove && ((Boolean)ModConfiguration.HOT_BLOCK_IGNITION.get()).booleanValue())) {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")}, remap=false)
    private static void onServerTick(Level level, BlockPos worldPosition, BlockState state, SmeltingBlockEntity entity, CallbackInfo ci) {
        if (((Boolean)ModConfiguration.BETTER_FURNACE.get()).booleanValue() && !((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            ((IIgnited)entity).setIgnitedByPlayer(false);
        }
    }

    private boolean isActive(SmeltingBlockEntity furnace) {
        boolean burning = furnace.isBurning() || furnace.cookTime > 0;
        boolean liquidRun = furnace.isLiquid() && furnace.fluidTank.getFluidStack().getAmount() > 0L;
        boolean energyRun = furnace.hasUpgrade((UpgradeItem)Registration.ENERGY.get()) && furnace.energyStorage.getEnergyStored() >= furnace.EnergyUse();
        return burning || liquidRun || energyRun;
    }
}

