/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.lititup.event.stove;

import com.eruannie_9.lititup.Item.ModItems;
import com.eruannie_9.lititup.ModConfiguration;
import com.eruannie_9.lititup.packethandler.PacketHandler;
import com.eruannie_9.lititup.packethandler.pack.FlintStrikeEntityPacket;
import com.eruannie_9.lititup.util.FireAspectUtil;
import com.eruannie_9.lititup.util.ShrinkItemDefinition;
import com.eruannie_9.lititup.util.SmelterUtil;
import com.eruannie_9.lititup.util.curio.CurioUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.curios.api.CuriosApi;

public final class StoveIgnitionCommon {
    public static final String CANDLELIGHT_MOD_ID = "candlelight";
    public static final String FARMERSDELIGHT_MOD_ID = "farmersdelight";
    private static final int FLINT_STRIKE_COOLDOWN_TICKS = 20;

    private StoveIgnitionCommon() {
    }

    public static boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static boolean isIgnitionItem(Item item) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item);
        return id != null && ((List)ModConfiguration.FURNACE_EXECUTOR_ITEM_LIST.get()).contains(id.toString());
    }

    public static boolean canUseGenericIgnition(ItemStack stack) {
        return !StoveIgnitionCommon.isIgnitionItem(stack.m_41720_()) && !FireAspectUtil.hasFireAspect(stack);
    }

    public static void ignite(Level level, BlockPos pos, BlockState state, Player player, ItemStack used, boolean checkFireAspect) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SmelterUtil.light((Level)serverLevel, pos, state);
            serverLevel.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, 1.0f);
            SmelterUtil.executeParticles(serverLevel, pos);
            SmelterUtil.awardLightFurnace((Level)serverLevel, pos, player);
            if (checkFireAspect) {
                SmelterUtil.awardFireAspect((Level)serverLevel, pos, player, used);
            }
            SmelterUtil.awardRainIgnite((Level)serverLevel, pos, player);
        }
    }

    public static void damageCurioLighter(Player player) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        if (!CurioUtil.isCuriosLoaded()) {
            return;
        }
        CuriosApi.getCuriosHelper().findCurios((LivingEntity)player, new String[]{"lighter"}).stream().filter(r -> r.stack().m_150930_((Item)ModItems.GOLDEN_LIGHTER.get())).findFirst().ifPresent(res -> {
            ItemStack stack = res.stack();
            if (stack.m_41763_()) {
                stack.m_41622_(1, (LivingEntity)player, p -> CuriosApi.getCuriosHelper().onBrokenCurio(res.slotContext()));
            } else if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
        });
    }

    public static void consumeOrDamageHeld(Player player, ItemStack stack, Runnable onBreak) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        if (!player.m_150110_().f_35937_) {
            if (stack.m_41763_()) {
                stack.m_41622_(1, (LivingEntity)player, p -> onBreak.run());
            } else {
                stack.m_41774_(1);
            }
        }
    }

    public static boolean tryCurioLighterIgnition(PlayerInteractEvent.RightClickBlock event, Level level, BlockPos pos, BlockState state, Player player) {
        if (!CurioUtil.isCuriosLoaded() || !CurioUtil.hasGoldenLighter(player)) {
            return false;
        }
        StoveIgnitionCommon.damageCurioLighter(player);
        StoveIgnitionCommon.ignite(level, pos, state, player, ItemStack.f_41583_, false);
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.m_19078_((boolean)level.f_46443_));
        return true;
    }

    public static boolean tryDoubleFlintIgnition(PlayerInteractEvent.RightClickBlock event, Level level, BlockPos pos, BlockState state, Player player) {
        ItemStack other;
        if (!((Boolean)ModConfiguration.DOUBLE_FLINT_IGNITION.get()).booleanValue()) {
            return false;
        }
        InteractionHand hand = event.getHand();
        ItemStack used = event.getItemStack();
        if (!used.m_150930_(Items.f_42484_)) {
            return false;
        }
        ItemStack itemStack = other = hand == InteractionHand.MAIN_HAND ? player.m_21206_() : player.m_21205_();
        if (!other.m_150930_(Items.f_42484_)) {
            return false;
        }
        if (player.m_36335_().m_41519_(Items.f_42484_)) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.PASS);
            return true;
        }
        player.m_36335_().m_41524_(Items.f_42484_, 20);
        boolean creative = player.m_150110_().f_35937_;
        String reqIdStr = (String)ModConfiguration.SWITCHGRASS_FIBER_REPLACEMENT.get();
        boolean fiberRequired = reqIdStr != null && !reqIdStr.isBlank();
        ResourceLocation fiberId = fiberRequired ? new ResourceLocation(reqIdStr) : null;
        int fiberSlot = -1;
        if (!level.f_46443_ && fiberRequired && !creative) {
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ResourceLocation id;
                ItemStack s = player.m_150109_().m_8020_(i);
                if (s.m_41619_() || (id = ForgeRegistries.ITEMS.getKey((Object)s.m_41720_())) == null || !id.equals((Object)fiberId)) continue;
                fiberSlot = i;
                break;
            }
        }
        float chance = Mth.m_14036_((float)((Double)ModConfiguration.DOUBLE_FLINT_CHANCE.get()).floatValue(), (float)0.0f, (float)1.0f);
        boolean finalSuccess = false;
        if (!level.f_46443_) {
            boolean bl = finalSuccess = level.m_213780_().m_188501_() < chance && (creative || !fiberRequired || fiberSlot >= 0);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            PacketHandler.sendToTrackingAndSelf(sp, new FlintStrikeEntityPacket(sp.m_19879_(), finalSuccess));
        }
        if (!finalSuccess) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.FAIL);
            return true;
        }
        if (fiberRequired && !creative) {
            ItemStack fiberStack = player.m_150109_().m_8020_(fiberSlot);
            fiberStack.m_41774_(1);
            if (fiberStack.m_41619_()) {
                player.m_150109_().m_6836_(fiberSlot, ItemStack.f_41583_);
            }
        }
        StoveIgnitionCommon.ignite(level, pos, state, player, ItemStack.f_41583_, false);
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.m_19078_((boolean)false));
        return true;
    }

    public static boolean tryFlintAndSteelIgnition(PlayerInteractEvent.RightClickBlock event, Level level, BlockPos pos, BlockState state, Player player) {
        ItemStack itemStack = event.getItemStack();
        if (!itemStack.m_150930_(Items.f_42409_)) {
            return false;
        }
        StoveIgnitionCommon.ignite(level, pos, state, player, itemStack, false);
        StoveIgnitionCommon.consumeOrDamageHeld(player, itemStack, () -> player.m_21190_(event.getHand()));
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.m_19078_((boolean)level.f_46443_));
        return true;
    }

    public static boolean trySparklingFlintIgnition(PlayerInteractEvent.RightClickBlock event, Level level, BlockPos pos, BlockState state, Player player) {
        ItemStack itemStack = event.getItemStack();
        if (!itemStack.m_150930_((Item)ModItems.SPARKLING_FLINT.get())) {
            return false;
        }
        StoveIgnitionCommon.handleSparklingFlint(event, level, pos, state, player, itemStack);
        return true;
    }

    public static boolean passIfOnCooldown(PlayerInteractEvent.RightClickBlock event, Player player) {
        if (player.m_36335_().m_41519_(event.getItemStack().m_41720_())) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.PASS);
            return true;
        }
        return false;
    }

    public static void performGenericIgnition(PlayerInteractEvent.RightClickBlock event, Level level, BlockPos pos, BlockState state, Player player, ItemStack itemStack, boolean checkFireAspect) {
        StoveIgnitionCommon.ignite(level, pos, state, player, itemStack, checkFireAspect);
        StoveIgnitionCommon.consumeOrDamageHeld(player, itemStack, () -> player.m_21190_(event.getHand()));
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.m_19078_((boolean)level.f_46443_));
    }

    public static void handleSparklingFlint(PlayerInteractEvent.RightClickBlock event, Level level, BlockPos pos, BlockState state, Player player, ItemStack itemStack) {
        if (ShrinkItemDefinition.hasShrinkItem(player)) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.PASS);
            return;
        }
        StoveIgnitionCommon.ignite(level, pos, state, player, itemStack, false);
        itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(event.getHand()));
        ShrinkItemDefinition.shrinkItem(player);
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.SUCCESS);
    }
}

