/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.lititup.mixin.campfire;

import com.eruannie_9.lititup.util.SmelterUtil;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CampfireBlock.class})
public abstract class CampfireUseMixin {
    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    private void customIgnition(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, CallbackInfoReturnable<InteractionResult> cir) {
        if (player == null) {
            return;
        }
        if (!CampfireBlock.m_51321_((BlockState)state)) {
            return;
        }
        if (CampfireUseMixin.hasCookableRecipe(level, pos, player.m_21120_(hand))) {
            return;
        }
        if (SmelterUtil.tryCampfireCurioIgnition(level, pos, state, player, cir)) {
            return;
        }
        if (SmelterUtil.tryCampfireDoubleFlintIgnition(level, pos, state, player, hand, cir)) {
            return;
        }
        if (SmelterUtil.tryCampfireFlintAndSteelIgnition(level, pos, state, player, hand, cir)) {
            return;
        }
        if (SmelterUtil.tryCampfireSparklingFlintIgnition(level, pos, state, player, hand, cir)) {
            return;
        }
        SmelterUtil.tryCampfireHandIgniter(level, pos, state, player, hand, cir);
    }

    private static boolean hasCookableRecipe(Level level, BlockPos pos, ItemStack handStack) {
        if (handStack.m_41619_()) {
            return false;
        }
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof CampfireBlockEntity) {
            CampfireBlockEntity campfireBE = (CampfireBlockEntity)be;
            Optional recipe = campfireBE.m_59051_(handStack);
            return recipe.isPresent();
        }
        return false;
    }
}

