/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.lititup.mixin.compatibility;

import com.eruannie_9.lititup.Item.ModItems;
import com.eruannie_9.lititup.ModConfiguration;
import com.eruannie_9.lititup.block.ModBlocks;
import com.eruannie_9.lititup.util.FireAspectUtil;
import com.eruannie_9.lititup.util.SmelterUtil;
import com.eruannie_9.lititup.util.curio.CurioUtil;
import com.sihenzhang.crockpot.block.CrockPotBlock;
import com.sihenzhang.crockpot.block.entity.CrockPotBlockEntity;
import com.sihenzhang.crockpot.recipe.cooking.CrockPotCookingRecipe;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CrockPotBlock.class})
public abstract class CrockPotExecutorMixin {
    private boolean canIgniteFurnace(CrockPotBlockEntity pot, Level level) {
        Optional rec;
        ItemStack fuelStack = pot.getItemHandler().getStackInSlot(4);
        boolean hasFuel = CrockPotBlockEntity.isFuel((ItemStack)fuelStack);
        boolean recipeReady = false;
        if (pot.getRecipeWrapper() != null && (rec = CrockPotCookingRecipe.getRecipeFor((CrockPotCookingRecipe.Wrapper)pot.getRecipeWrapper(), (Level)level)).isPresent()) {
            ItemStack currentOut = pot.getItemHandler().getStackInSlot(5);
            recipeReady = currentOut.m_41619_();
        }
        return hasFuel && recipeReady;
    }

    private boolean isIgnitionItem(Item item) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item);
        return id != null && ((List)ModConfiguration.FURNACE_EXECUTOR_ITEM_LIST.get()).contains(id.toString());
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    public void onUse(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, CallbackInfoReturnable<InteractionResult> cir) {
        CrockPotBlockEntity pot;
        BlockEntity be;
        block14: {
            block13: {
                if (!((Boolean)ModConfiguration.CROCK_POT.get()).booleanValue() || level.f_46443_) {
                    return;
                }
                be = level.m_7702_(pos);
                if (!(be instanceof CrockPotBlockEntity)) break block13;
                pot = (CrockPotBlockEntity)be;
                if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) break block14;
            }
            return;
        }
        if (!this.canIgniteFurnace(pot, level)) {
            return;
        }
        if (CurioUtil.isCuriosLoaded() && CurioUtil.hasGoldenLighter(player)) {
            SmelterUtil.igniteWithCuriosSlot(level, pos, state, (BlockEntity)pot, player, cir);
            return;
        }
        if (((Boolean)ModConfiguration.DOUBLE_FLINT_IGNITION.get()).booleanValue() && CrockPotExecutorMixin.hasFlintInBothHands(player)) {
            boolean hasSwitchgrassFuel;
            ItemStack inputSlot1 = pot.getItemHandler().getStackInSlot(4);
            boolean bl = hasSwitchgrassFuel = inputSlot1.m_150930_((Item)ModItems.SWITCHGRASS_FIBER.get()) || inputSlot1.m_150930_(((Block)ModBlocks.BALED_SWITCHGRASS.get()).m_5456_());
            if (hasSwitchgrassFuel) {
                if (!player.m_36335_().m_41519_(Items.f_42484_)) {
                    SmelterUtil.tryIgniteWithFlints(level, pos, state, be, player, cir);
                } else {
                    cir.setReturnValue((Object)InteractionResult.CONSUME);
                    cir.cancel();
                }
                return;
            }
        }
        ItemStack stackInHand = player.m_21120_(hand);
        Item item = stackInHand.m_41720_();
        boolean fireAspect = FireAspectUtil.hasFireAspect(stackInHand);
        if (player.m_36335_().m_41519_(item) || !this.isIgnitionItem(item) && !fireAspect) {
            return;
        }
        if (stackInHand.m_41763_()) {
            SmelterUtil.tryIgnite(level, pos, state, be, player, item, stackInHand, hand, cir);
        } else {
            SmelterUtil.tryShrinkAndIgnite(level, pos, state, be, player, item, stackInHand, hand, cir);
        }
    }

    private static boolean hasFlintInBothHands(Player player) {
        return player.m_21205_().m_150930_(Items.f_42484_) && player.m_21206_().m_150930_(Items.f_42484_);
    }
}

