/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.lititup.mixin.compatibility;

import com.aetherteam.aether.block.utility.IncubatorBlock;
import com.aetherteam.aether.blockentity.IncubatorBlockEntity;
import com.eruannie_9.lititup.Item.ModItems;
import com.eruannie_9.lititup.ModConfiguration;
import com.eruannie_9.lititup.block.ModBlocks;
import com.eruannie_9.lititup.mixin.compatibility.accessors.AetherIncubatorAccessor;
import com.eruannie_9.lititup.util.FireAspectUtil;
import com.eruannie_9.lititup.util.SmelterUtil;
import com.eruannie_9.lititup.util.curio.CurioUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={IncubatorBlock.class})
public class SmelterAetherIncubatorExecutorMixin {
    private boolean canIgniteFurnace(IncubatorBlockEntity furnace, Level level) {
        ItemStack fuelStack = furnace.m_8020_(1);
        boolean hasFuel = !fuelStack.m_41619_();
        RecipeManager.CachedCheck<Container, ? extends AbstractCookingRecipe> quickCheck = ((AetherIncubatorAccessor)furnace).getQuickCheck();
        boolean hasRecipe = quickCheck.m_213657_((Container)furnace, level).isPresent();
        return hasFuel && hasRecipe;
    }

    private boolean isIgnitionItem(Item item) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item);
        return id != null && ((List)ModConfiguration.FURNACE_EXECUTOR_ITEM_LIST.get()).contains(id.toString());
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    public void onUse(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, CallbackInfoReturnable<InteractionResult> cir) {
        IncubatorBlockEntity furnace;
        BlockEntity be;
        block14: {
            block13: {
                if (!((Boolean)ModConfiguration.AETHER.get()).booleanValue() || level.f_46443_) {
                    return;
                }
                be = level.m_7702_(pos);
                if (!(be instanceof IncubatorBlockEntity)) break block13;
                furnace = (IncubatorBlockEntity)be;
                if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) break block14;
            }
            return;
        }
        if (!this.canIgniteFurnace(furnace, level)) {
            return;
        }
        if (CurioUtil.isCuriosLoaded() && CurioUtil.hasGoldenLighter(player)) {
            SmelterUtil.igniteWithCuriosSlot(level, pos, state, (BlockEntity)furnace, player, cir);
            return;
        }
        if (((Boolean)ModConfiguration.DOUBLE_FLINT_IGNITION.get()).booleanValue() && SmelterAetherIncubatorExecutorMixin.hasFlintInBothHands(player)) {
            boolean hasSwitchgrassFuel;
            ItemStack fuel = furnace.m_8020_(1);
            boolean bl = hasSwitchgrassFuel = fuel.m_150930_((Item)ModItems.SWITCHGRASS_FIBER.get()) || fuel.m_150930_(((Block)ModBlocks.BALED_SWITCHGRASS.get()).m_5456_());
            if (hasSwitchgrassFuel) {
                if (!player.m_36335_().m_41519_(Items.f_42484_)) {
                    SmelterUtil.tryIgniteWithFlints(level, pos, state, be, player, cir);
                } else {
                    cir.setReturnValue((Object)InteractionResult.CONSUME);
                    cir.cancel();
                }
                return;
            }
        }
        ItemStack stackInHand = player.m_21120_(hand);
        Item item = stackInHand.m_41720_();
        boolean fireAspect = FireAspectUtil.hasFireAspect(stackInHand);
        if (player.m_36335_().m_41519_(item) || !this.isIgnitionItem(item) && !fireAspect) {
            return;
        }
        if (stackInHand.m_41763_()) {
            SmelterUtil.tryIgnite(level, pos, state, be, player, item, stackInHand, hand, cir);
        } else {
            SmelterUtil.tryShrinkAndIgnite(level, pos, state, be, player, item, stackInHand, hand, cir);
        }
    }

    private static boolean hasFlintInBothHands(Player player) {
        return player.m_21205_().m_150930_(Items.f_42484_) && player.m_21206_().m_150930_(Items.f_42484_);
    }
}

