/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.lititup.mixin.compatibility;

import com.eruannie_9.lititup.Item.ModItems;
import com.eruannie_9.lititup.ModConfiguration;
import com.eruannie_9.lititup.block.ModBlocks;
import com.eruannie_9.lititup.util.FireAspectUtil;
import com.eruannie_9.lititup.util.SmelterUtil;
import com.eruannie_9.lititup.util.curio.CurioUtil;
import com.eruannie_9.lititup.util.tough.PurifierSmelterUtil;
import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import toughasnails.api.crafting.TANRecipeTypes;
import toughasnails.block.WaterPurifierBlock;
import toughasnails.block.entity.WaterPurifierBlockEntity;
import toughasnails.crafting.WaterPurifierRecipe;

@Mixin(value={WaterPurifierBlock.class})
public abstract class ToughPurifierExecutorMixin {
    private static final Supplier<RecipeManager.CachedCheck<Container, WaterPurifierRecipe>> WATER_PURIFYING_CHECK = Suppliers.memoize(() -> RecipeManager.m_220267_((RecipeType)TANRecipeTypes.WATER_PURIFYING));

    private boolean canIgnitePurifier(WaterPurifierBlockEntity purifier, Level level) {
        boolean hasFilter = !purifier.m_8020_(1).m_41619_();
        boolean hasRecipe = WATER_PURIFYING_CHECK.get().m_213657_((Container)purifier, level).isPresent();
        return hasFilter && hasRecipe;
    }

    private boolean isIgnitionItem(Item item) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item);
        return id != null && ((List)ModConfiguration.FURNACE_EXECUTOR_ITEM_LIST.get()).contains(id.toString());
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    private void onUse(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, CallbackInfoReturnable<InteractionResult> cir) {
        WaterPurifierBlockEntity purifier;
        BlockEntity be;
        block14: {
            block13: {
                if (!((Boolean)ModConfiguration.TOUGH_PURIFIER.get()).booleanValue() || level.f_46443_) {
                    return;
                }
                be = level.m_7702_(pos);
                if (!(be instanceof WaterPurifierBlockEntity)) break block13;
                purifier = (WaterPurifierBlockEntity)be;
                if (!((Boolean)state.m_61143_((Property)WaterPurifierBlock.PURIFYING)).booleanValue()) break block14;
            }
            return;
        }
        if (!this.canIgnitePurifier(purifier, level)) {
            return;
        }
        if (CurioUtil.isCuriosLoaded() && CurioUtil.hasGoldenLighter(player)) {
            PurifierSmelterUtil.ignitePurifierWithCuriosSlot(level, pos, state, (BlockEntity)purifier, player, cir);
            return;
        }
        if (((Boolean)ModConfiguration.DOUBLE_FLINT_IGNITION.get()).booleanValue() && ToughPurifierExecutorMixin.hasFlintInBothHands(player)) {
            boolean hasSwitchgrassFuel;
            ItemStack fuel = purifier.m_8020_(1);
            boolean bl = hasSwitchgrassFuel = fuel.m_150930_((Item)ModItems.SWITCHGRASS_FIBER.get()) || fuel.m_150930_(((Block)ModBlocks.BALED_SWITCHGRASS.get()).m_5456_());
            if (hasSwitchgrassFuel) {
                if (!player.m_36335_().m_41519_(Items.f_42484_)) {
                    SmelterUtil.tryIgniteWithFlints(level, pos, state, be, player, cir);
                } else {
                    cir.setReturnValue((Object)InteractionResult.CONSUME);
                    cir.cancel();
                }
                return;
            }
        }
        ItemStack inHand = player.m_21120_(hand);
        Item item = inHand.m_41720_();
        boolean fireAspect = FireAspectUtil.hasFireAspect(inHand);
        if (player.m_36335_().m_41519_(item) || !this.isIgnitionItem(item) && !fireAspect) {
            return;
        }
        if (inHand.m_41763_()) {
            PurifierSmelterUtil.tryIgnitePurifier(level, pos, state, (BlockEntity)purifier, player, item, inHand, hand, cir);
        } else {
            PurifierSmelterUtil.tryShrinkAndIgnitePurifier(level, pos, state, (BlockEntity)purifier, player, item, inHand, hand, cir);
        }
    }

    private static boolean hasFlintInBothHands(Player player) {
        return player.m_21205_().m_150930_(Items.f_42484_) && player.m_21206_().m_150930_(Items.f_42484_);
    }
}

