/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.lititup.screen.guide;

import com.eruannie_9.booklinggear.util.TabWidget;
import com.eruannie_9.lititup.Item.ModItems;
import com.eruannie_9.lititup.ModConfiguration;
import com.eruannie_9.lititup.block.ModBlocks;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class GuideScreen
extends Screen {
    private static final ResourceLocation TABS_TEXTURE = new ResourceLocation("lititup", "textures/gui/guide_tab.png");
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("lititup", "textures/gui/guide_background.png");
    private static final int CONTENT_WIDTH = 141;
    private static final int CONTENT_HEIGHT = 176;
    private static final int X_BUTTON_WIDTH = 9;
    private static final int X_BUTTON_HEIGHT = 9;
    private static final int PADDING = 20;
    private static final int LINE_SPACING = 5;
    private static final int SCROLLBAR_HEIGHT = 139;
    private static final int SCROLLBAR_TOP_Y = 25;
    private static final int SCROLLER_HEIGHT = 27;
    private static final int SCROLLER_WIDTH = 6;
    private static final int RIGHT_TEXT_INSET = 6;
    private static final DecimalFormat PCT_1DP = new DecimalFormat("0.#");
    private final Screen previousScreen;
    private int leftPos;
    private int topPos;
    private int xButtonX;
    private int xButtonY;
    private int selectedTabIndex = 0;
    private final List<GuideTabData> tabsData = new ArrayList<GuideTabData>();

    public GuideScreen(Screen previousScreen, Component title) {
        super(title != null ? title : GameNarrator.f_93310_);
        this.previousScreen = previousScreen;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - 141) / 2;
        this.topPos = (this.f_96544_ - 176) / 2;
        this.xButtonX = this.leftPos + 141 - 20 - 9 + 13;
        this.xButtonY = this.topPos + 20 - 9 - 6;
        this.tabsData.clear();
        this.tabsData.add(new GuideTabData((Component)Component.m_237115_((String)"tab.lititup.main"), (Component)Component.m_237115_((String)"message.lititup.main_description"), new ItemStack((ItemLike)Blocks.f_50094_), BACKGROUND_TEXTURE));
        this.tabsData.add(new GuideTabData((Component)Component.m_237115_((String)"tab.lititup.switchgrass"), (Component)Component.m_237115_((String)"message.lititup.switchgrass_description"), new ItemStack((ItemLike)ModBlocks.SWITCHGRASS.get()), BACKGROUND_TEXTURE));
        this.tabsData.add(new GuideTabData((Component)Component.m_237115_((String)"tab.lititup.sparkling_flint"), (Component)Component.m_237115_((String)"message.lititup.sparkling_flint_description"), new ItemStack((ItemLike)ModItems.SPARKLING_FLINT.get()), BACKGROUND_TEXTURE));
        if (((Boolean)ModConfiguration.GOLDEN_LIGHTER_LOOT.get()).booleanValue()) {
            this.tabsData.add(new GuideTabData((Component)Component.m_237115_((String)"tab.lititup.golden_lighter"), this.buildGoldenLighterMessage(), new ItemStack((ItemLike)ModItems.GOLDEN_LIGHTER.get()), BACKGROUND_TEXTURE));
        }
        if (((Boolean)ModConfiguration.DOUBLE_FLINT_IGNITION.get()).booleanValue()) {
            this.tabsData.add(new GuideTabData((Component)Component.m_237115_((String)"tab.lititup.flint_ignition"), (Component)Component.m_237115_((String)"message.lititup.flint_ignition_description"), new ItemStack((ItemLike)Items.f_42484_), BACKGROUND_TEXTURE));
        }
        if (((Boolean)ModConfiguration.HOT_BLOCK_IGNITION.get()).booleanValue() || ((Boolean)ModConfiguration.FIRE_ASPECT.get()).booleanValue()) {
            this.tabsData.add(new GuideTabData((Component)Component.m_237115_((String)"tab.lititup.environmental_ignition"), this.buildEnvironmentalIgnitionsMessage(), new ItemStack((ItemLike)Items.f_42448_), BACKGROUND_TEXTURE));
        }
        this.tabsData.add(new GuideTabData((Component)Component.m_237115_((String)"tab.lititup.compatibility"), (Component)Component.m_237115_((String)"message.lititup.compatibility_description"), new ItemStack((ItemLike)Items.f_42686_), BACKGROUND_TEXTURE));
        int wrapWidth = 95;
        for (GuideTabData tab : this.tabsData) {
            tab.messageLines = this.f_96547_.m_92923_((FormattedText)tab.message, 95);
            tab.scrollPercent = 0.0f;
            tab.targetScrollPercent = 0.0f;
            tab.dragGrabOffsetPx = 0.0f;
        }
        if (this.selectedTabIndex < 0 || this.selectedTabIndex >= this.tabsData.size()) {
            this.selectedTabIndex = 0;
        }
        this.buildTabWidgets();
    }

    private Component buildGoldenLighterMessage() {
        double frac = (Double)ModConfiguration.GOLDEN_LIGHTER_LOOT_CHANCE.get();
        String pct = PCT_1DP.format(frac * 100.0);
        return Component.m_237110_((String)"message.lititup.golden_lighter_description", (Object[])new Object[]{pct + "%"});
    }

    private Component buildEnvironmentalIgnitionsMessage() {
        boolean fireAspectOn = (Boolean)ModConfiguration.FIRE_ASPECT.get();
        boolean hotBlockOn = (Boolean)ModConfiguration.HOT_BLOCK_IGNITION.get();
        MutableComponent base = Component.m_237115_((String)"message.lititup.environmental_ignition_description");
        if (!fireAspectOn || !hotBlockOn) {
            boolean wroteAnyNote = false;
            base.m_7220_((Component)Component.m_237113_((String)"\n\n"));
            if (!fireAspectOn) {
                base.m_7220_((Component)Component.m_237113_((String)"Note: Fire Aspect ignition is disabled.").m_130940_(ChatFormatting.DARK_GRAY));
                wroteAnyNote = true;
            }
            if (!hotBlockOn) {
                if (wroteAnyNote) {
                    base.m_7220_((Component)Component.m_237113_((String)"\n"));
                }
                base.m_7220_((Component)Component.m_237113_((String)"Note: Hot block ignition from the configured block list is disabled.").m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
        return base;
    }

    private List<TabWidget.TabItemData> buildTabItemDataList() {
        float baseScale = 1.0f;
        float hoverScale = 1.2f;
        float animationSpeed = 0.08f;
        ArrayList<TabWidget.TabItemData> tabDataList = new ArrayList<TabWidget.TabItemData>();
        for (int i = 0; i < this.tabsData.size(); ++i) {
            int idx = i;
            GuideTabData data = this.tabsData.get(i);
            TabWidget.TabItemData record = new TabWidget.TabItemData(data.title.getString(), () -> idx == this.selectedTabIndex, btn -> this.setSelectedTab(idx), () -> data.icon, baseScale, hoverScale, animationSpeed, SoundEvents.f_11713_);
            tabDataList.add(record);
        }
        return tabDataList;
    }

    private void buildTabWidgets() {
        this.m_169413_();
        List<TabWidget.TabItemData> tabDataList = this.buildTabItemDataList();
        List tabWidgets = TabWidget.createTabsFromItemData((Screen)this, (int)this.leftPos, (int)this.topPos, (int)141, tabDataList, (ResourceLocation)TABS_TEXTURE, (boolean)true, (boolean)true, d -> TabWidget.ONLY_IF_NOT_SELECTED);
        for (TabWidget tw : tabWidgets) {
            this.m_142416_((GuiEventListener)tw);
        }
    }

    private void setSelectedTab(int index) {
        if (index < 0 || index >= this.tabsData.size()) {
            return;
        }
        GuideTabData newTab = this.tabsData.get(index);
        newTab.scrollPercent = 0.0f;
        newTab.targetScrollPercent = 0.0f;
        newTab.isDragging = false;
        newTab.dragGrabOffsetPx = 0.0f;
        this.selectedTabIndex = index;
        this.buildTabWidgets();
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        this.renderSelectedTabBackground(guiGraphics);
        this.renderScreenTitle(guiGraphics);
        this.renderTabContent(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderCloseButton(guiGraphics, mouseX, mouseY);
    }

    private void renderSelectedTabBackground(GuiGraphics g) {
        GuideTabData currentTab = this.tabsData.get(this.selectedTabIndex);
        ResourceLocation bg = currentTab.backgroundTexture;
        g.m_280163_(bg, this.leftPos, this.topPos, 0.0f, 0.0f, 141, 176, 256, 256);
    }

    private void renderScreenTitle(GuiGraphics g) {
        String titleText = this.f_96539_.getString();
        int titleX = this.leftPos + 70 - 55;
        int titleY = this.topPos + 20 - 11;
        g.m_280056_(this.f_96547_, titleText, titleX + 1, titleY + 1, 5908992, false);
        g.m_280056_(this.f_96547_, titleText, titleX, titleY, 0xFFAA00, false);
    }

    private void renderTabContent(GuiGraphics g) {
        GuideTabData tab = this.tabsData.get(this.selectedTabIndex);
        List<FormattedCharSequence> lines = tab.messageLines;
        if (lines.isEmpty()) {
            return;
        }
        if (!tab.isDragging) {
            float diff = Math.abs(tab.scrollPercent - tab.targetScrollPercent);
            float speed = 0.12f + 0.25f * diff;
            speed = Mth.m_14036_((float)speed, (float)0.12f, (float)0.37f);
            tab.scrollPercent = Mth.m_14179_((float)speed, (float)tab.scrollPercent, (float)tab.targetScrollPercent);
        }
        this.clampPercent(tab);
        int areaY = this.contentStartY();
        int areaH = this.contentHeightPx();
        int step = this.lineStepPx();
        int maxPx = this.maxScrollPx(tab);
        float scrollPx = maxPx <= 0 ? 0.0f : tab.scrollPercent * (float)maxPx;
        int firstLineIdx = (int)Math.floor(scrollPx / (float)step);
        float fractionalPx = scrollPx - (float)(firstLineIdx * step);
        int approxVisibleLines = Math.max(1, areaH / step) + 2;
        int textLeft = this.leftPos + 20;
        int textRight = this.leftPos + 141 - 20 - 6;
        int textWidth = Math.max(0, textRight - textLeft);
        int contentCenterX = textLeft + textWidth / 2;
        g.m_280588_(textLeft, areaY, textRight, areaY + areaH);
        for (int i = 0; i < approxVisibleLines; ++i) {
            int lineIndex = firstLineIdx + i;
            if (lineIndex < 0 || lineIndex >= lines.size()) continue;
            FormattedCharSequence line = lines.get(lineIndex);
            int lineX = contentCenterX - this.f_96547_.m_92724_(line) / 2 + 1;
            int lineY = areaY - (int)fractionalPx + i * step;
            g.m_280649_(this.f_96547_, line, lineX, lineY, 4927022, false);
        }
        g.m_280618_();
        this.renderScroller(g, tab);
    }

    private int lineStepPx() {
        Objects.requireNonNull(this.f_96547_);
        return 9 + 5;
    }

    private int contentStartY() {
        Objects.requireNonNull(this.f_96547_);
        return this.topPos + 20 + 9 + 5 - 1;
    }

    private int contentHeightPx() {
        Objects.requireNonNull(this.f_96547_);
        return 136 - (9 + 5);
    }

    private int totalContentHeightPx(GuideTabData tab) {
        return tab.messageLines.size() * this.lineStepPx();
    }

    private int maxScrollPx(GuideTabData tab) {
        return Math.max(0, this.totalContentHeightPx(tab) - this.contentHeightPx());
    }

    private void clampPercent(GuideTabData tab) {
        tab.scrollPercent = Mth.m_14036_((float)tab.scrollPercent, (float)0.0f, (float)1.0f);
        tab.targetScrollPercent = Mth.m_14036_((float)tab.targetScrollPercent, (float)0.0f, (float)1.0f);
    }

    private float scrollerTopYf(GuideTabData tab) {
        float extent = 112.0f;
        return 25.0f + extent * tab.scrollPercent;
    }

    private void renderScroller(GuiGraphics g, GuideTabData tab) {
        boolean canScroll = this.maxScrollPx(tab) > 0;
        int scrollbarX = this.leftPos + 141 - 20 - 6 + 7;
        float scrollerYf = this.scrollerTopYf(tab);
        int scrollerU = canScroll ? (tab.isDragging ? 148 : 142) : 148;
        boolean scrollerV = true;
        g.m_280168_().m_85836_();
        g.m_280168_().m_252880_((float)(scrollbarX - 1), (float)this.topPos + scrollerYf - 1.0f, 0.0f);
        g.m_280163_(tab.backgroundTexture, 0, 0, (float)scrollerU, (float)scrollerV, 6, 27, 256, 256);
        g.m_280168_().m_85849_();
    }

    private int calculateVisibleLines() {
        int step = this.lineStepPx();
        return Math.max(1, this.contentHeightPx() / step);
    }

    private void renderCloseButton(GuiGraphics g, int mouseX, int mouseY) {
        boolean isHovered = this.isHoveringCloseButton(mouseX, mouseY);
        int u = isHovered ? 151 : 141;
        int v = 104;
        g.m_280163_(BACKGROUND_TEXTURE, this.xButtonX, this.xButtonY, (float)u, (float)v, 9, 9, 256, 256);
    }

    private boolean isHoveringCloseButton(int mouseX, int mouseY) {
        return mouseX >= this.xButtonX && mouseX < this.xButtonX + 9 && mouseY >= this.xButtonY && mouseY < this.xButtonY + 9;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.isHoveringCloseButton((int)mouseX, (int)mouseY) && button == 0) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12591_, (float)1.0f));
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_144098_, (float)0.8f));
            this.m_7379_();
            return true;
        }
        if (button == 0) {
            boolean overTrack;
            GuideTabData tab = this.tabsData.get(this.selectedTabIndex);
            int scrollbarX = this.leftPos + 141 - 20 - 6 + 7;
            int trackTop = this.topPos + 25;
            int trackBottom = trackTop + 139;
            boolean bl = overTrack = mouseX >= (double)scrollbarX && mouseX < (double)(scrollbarX + 6) && mouseY >= (double)trackTop && mouseY <= (double)trackBottom;
            if (overTrack && tab.messageLines.size() > this.calculateVisibleLines()) {
                boolean overThumb;
                int thumbTopAbs = (int)((float)this.topPos + this.scrollerTopYf(tab));
                int thumbBottomAbs = thumbTopAbs + 27;
                boolean bl2 = overThumb = mouseY >= (double)thumbTopAbs && mouseY < (double)thumbBottomAbs;
                if (overThumb) {
                    tab.isDragging = true;
                    tab.dragGrabOffsetPx = (float)(mouseY - (double)thumbTopAbs);
                } else {
                    float extent = 112.0f;
                    float trackPos = (float)(mouseY - (double)trackTop - 13.5);
                    float ratio = trackPos / extent;
                    tab.scrollPercent = tab.targetScrollPercent = (ratio = Mth.m_14036_((float)ratio, (float)0.0f, (float)1.0f));
                    this.clampPercent(tab);
                    tab.isDragging = true;
                    tab.dragGrabOffsetPx = 13.5f;
                }
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            GuideTabData tab = this.tabsData.get(this.selectedTabIndex);
            tab.isDragging = false;
            tab.dragGrabOffsetPx = 0.0f;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        GuideTabData tab = this.tabsData.get(this.selectedTabIndex);
        if (tab.messageLines.isEmpty()) {
            return false;
        }
        int maxPx = this.maxScrollPx(tab);
        if (maxPx > 0) {
            float percentPerLine = (float)this.lineStepPx() / (float)maxPx;
            float wheelPercent = (float)(-delta * (double)percentPerLine * 0.5);
            tab.targetScrollPercent += wheelPercent;
            this.clampPercent(tab);
        }
        return true;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        GuideTabData tab = this.tabsData.get(this.selectedTabIndex);
        if (tab.isDragging && !tab.messageLines.isEmpty()) {
            if (this.maxScrollPx(tab) <= 0) {
                return true;
            }
            float extent = 112.0f;
            float trackY = (float)(mouseY - (double)this.topPos - 25.0 - (double)tab.dragGrabOffsetPx);
            float ratio = trackY / extent;
            tab.scrollPercent = ratio = Mth.m_14036_((float)ratio, (float)0.0f, (float)1.0f);
            tab.targetScrollPercent = ratio;
            this.clampPercent(tab);
            return true;
        }
        return false;
    }

    public void m_7379_() {
        TabWidget.clearScaleCache();
        if (this.f_96541_ != null && this.previousScreen != null) {
            this.f_96541_.m_91152_(this.previousScreen);
        } else {
            super.m_7379_();
        }
    }

    public boolean m_7043_() {
        return false;
    }

    private static class GuideTabData {
        public final Component title;
        public final Component message;
        public final ItemStack icon;
        public final ResourceLocation backgroundTexture;
        public List<FormattedCharSequence> messageLines = Collections.emptyList();
        public float scrollPercent = 0.0f;
        public float targetScrollPercent = 0.0f;
        public boolean isDragging = false;
        public float dragGrabOffsetPx = 0.0f;

        public GuideTabData(Component title, Component message, ItemStack icon, ResourceLocation backgroundTexture) {
            this.title = title;
            this.message = message;
            this.icon = icon;
            this.backgroundTexture = backgroundTexture;
        }
    }
}

