/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.lititup.util.tough;

import com.eruannie_9.lititup.Item.ModItems;
import com.eruannie_9.lititup.util.SmelterUtil;
import com.eruannie_9.lititup.util.interfaces.IIgnited;
import com.eruannie_9.lititup.util.tough.PurifierWeakLighterUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import top.theillusivec4.curios.api.CuriosApi;

public class PurifierSmelterUtil {
    private PurifierSmelterUtil() {
    }

    public static void ignitePurifierWithCuriosSlot(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity, Player player, CallbackInfoReturnable<InteractionResult> cir) {
        ((IIgnited)blockEntity).setIgnitedByPlayer(true);
        SmelterUtil.light(level, pos, state);
        level.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, 1.0f);
        CuriosApi.getCuriosHelper().findCurios((LivingEntity)player, new String[]{"lighter"}).stream().filter(r -> r.stack().m_150930_((Item)ModItems.GOLDEN_LIGHTER.get())).findFirst().ifPresent(res -> {
            ItemStack stack = res.stack();
            if (stack.m_41763_()) {
                stack.m_41622_(1, (LivingEntity)player, p -> CuriosApi.getCuriosHelper().onBrokenCurio(res.slotContext()));
            } else if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
        });
        if (level instanceof ServerLevel) {
            ServerLevel srv = (ServerLevel)level;
            SmelterUtil.executeParticles(srv, pos);
            SmelterUtil.awardLightFurnace(level, pos, player);
            SmelterUtil.awardRainIgnite(level, pos, player);
        }
        cir.setReturnValue((Object)InteractionResult.SUCCESS);
        cir.cancel();
    }

    public static void tryIgnitePurifier(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity, Player player, Item item, ItemStack itemInHand, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        boolean weakHandled = PurifierWeakLighterUtil.randomExecution(level, pos, state, blockEntity, player, item, itemInHand, hand, cir);
        if (weakHandled) {
            if (PurifierWeakLighterUtil.wasSuccessfulIgnition() && level instanceof ServerLevel) {
                ServerLevel srv = (ServerLevel)level;
                SmelterUtil.executeParticles(srv, pos);
                SmelterUtil.awardLightFurnace(level, pos, player);
                SmelterUtil.awardFireAspect(level, pos, player, itemInHand);
                SmelterUtil.awardRainIgnite(level, pos, player);
            }
            return;
        }
        ((IIgnited)blockEntity).setIgnitedByPlayer(true);
        SmelterUtil.light(level, pos, state);
        level.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, 1.0f);
        itemInHand.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
        if (level instanceof ServerLevel) {
            ServerLevel srv = (ServerLevel)level;
            SmelterUtil.executeParticles(srv, pos);
            SmelterUtil.awardLightFurnace(level, pos, player);
            SmelterUtil.awardFireAspect(level, pos, player, itemInHand);
            SmelterUtil.awardRainIgnite(level, pos, player);
        }
        cir.setReturnValue((Object)InteractionResult.SUCCESS);
        cir.cancel();
    }

    public static void tryShrinkAndIgnitePurifier(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity, Player player, Item item, ItemStack itemInHand, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        boolean weakHandled = PurifierWeakLighterUtil.randomExecution(level, pos, state, blockEntity, player, item, itemInHand, hand, cir);
        if (weakHandled) {
            if (PurifierWeakLighterUtil.wasSuccessfulIgnition() && level instanceof ServerLevel) {
                ServerLevel srv = (ServerLevel)level;
                SmelterUtil.executeParticles(srv, pos);
                SmelterUtil.awardLightFurnace(level, pos, player);
                SmelterUtil.awardFireAspect(level, pos, player, itemInHand);
                SmelterUtil.awardRainIgnite(level, pos, player);
            }
            return;
        }
        ((IIgnited)blockEntity).setIgnitedByPlayer(true);
        SmelterUtil.light(level, pos, state);
        level.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (!player.m_150110_().f_35937_) {
            itemInHand.m_41774_(1);
        }
        if (level instanceof ServerLevel) {
            ServerLevel srv = (ServerLevel)level;
            SmelterUtil.executeParticles(srv, pos);
            SmelterUtil.awardLightFurnace(level, pos, player);
            SmelterUtil.awardFireAspect(level, pos, player, itemInHand);
            SmelterUtil.awardRainIgnite(level, pos, player);
        }
        cir.setReturnValue((Object)InteractionResult.SUCCESS);
        cir.cancel();
    }
}

