/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.lititup.mixin.compatibility;

import cech12.brickfurnace.blockentity.AbstractBrickFurnaceBlockEntity;
import cech12.brickfurnace.blockentity.BrickFurnaceBlockEntity;
import com.eruannie_9.lititup.ModConfiguration;
import com.eruannie_9.lititup.util.EnvironmentCheck;
import com.eruannie_9.lititup.util.ie.IImmersive;
import com.eruannie_9.lititup.util.ie.IImmersiveHeater;
import com.eruannie_9.lititup.util.ie.ImmersiveCheckUpdate;
import com.eruannie_9.lititup.util.interfaces.IIgnited;
import com.eruannie_9.lititup.util.interfaces.IIgnitedNbt;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fml.ModList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractBrickFurnaceBlockEntity.class})
public abstract class SmelterBrickManagerMixin
implements IIgnited,
IIgnitedNbt,
IImmersiveHeater {
    @Unique
    private boolean heatedByFurnaceHeater = false;
    @Unique
    private boolean ignited = false;

    @Override
    public void setIgnitedByPlayer(boolean ignited) {
        this.ignited = ignited;
    }

    @Override
    public boolean isIgnitedByPlayer() {
        return this.ignited;
    }

    @Override
    public void setHeatedByFurnaceHeater(boolean heated) {
        this.heatedByFurnaceHeater = heated;
    }

    @Override
    public boolean isHeatedByFurnaceHeater() {
        return this.heatedByFurnaceHeater;
    }

    @Override
    public void readIgnitedByPlayer(CompoundTag tag) {
        this.heatedByFurnaceHeater = tag.m_128471_("HeatedByFurnaceHeater");
        this.ignited = tag.m_128471_("Ignited");
    }

    @Override
    public void writeIgnitedByPlayer(CompoundTag tag) {
        tag.m_128379_("HeatedByFurnaceHeater", this.heatedByFurnaceHeater);
        tag.m_128379_("Ignited", this.ignited);
    }

    @Inject(method={"canBurn"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void onCanBurn(CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)ModConfiguration.BRICK_FURNACE.get()).booleanValue() && ((Boolean)ModConfiguration.MAIN.get()).booleanValue()) {
            boolean isActive;
            AbstractBrickFurnaceBlockEntity furnace = (AbstractBrickFurnaceBlockEntity)this;
            boolean bl = isActive = furnace.getContainerData().m_6413_(0) > 0 || this.isHeatedByFurnaceHeater();
            if (isActive) {
                return;
            }
            Level world = furnace.m_58904_();
            BlockPos pos = furnace.m_58899_();
            boolean hasLavaOrFireBelow = EnvironmentCheck.isHeatSourceBelow(world, pos);
            boolean isRainingAbove = EnvironmentCheck.isPrecipitationAbove(world, pos);
            if (!(this.isIgnitedByPlayer() || hasLavaOrFireBelow && !isRainingAbove && ((Boolean)ModConfiguration.HOT_BLOCK_IGNITION.get()).booleanValue() || ModList.get().isLoaded("immersiveengineering") && this.isHeatedByFurnaceHeater())) {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, remap=false)
    private static void updateHeatedByFurnaceHeater(Level level, BlockPos pos, BlockState state, AbstractBrickFurnaceBlockEntity entity, CallbackInfo ci) {
        if (((Boolean)ModConfiguration.BRICK_FURNACE.get()).booleanValue() && ((Boolean)ModConfiguration.MAIN.get()).booleanValue()) {
            if (!(entity instanceof BrickFurnaceBlockEntity)) {
                return;
            }
            IImmersive updater = ImmersiveCheckUpdate.createUpdater();
            updater.updateHeatedByFurnaceHeater((BlockEntity)entity);
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")}, remap=false)
    private static void onServerTick(Level level, BlockPos pos, BlockState state, AbstractBrickFurnaceBlockEntity entity, CallbackInfo ci) {
        if (((Boolean)ModConfiguration.BRICK_FURNACE.get()).booleanValue() && ((Boolean)ModConfiguration.MAIN.get()).booleanValue() && !((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            ((IIgnited)entity).setIgnitedByPlayer(false);
        }
    }
}

