/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.lititup.mixin.compatibility;

import com.eruannie_9.lititup.ModConfiguration;
import com.eruannie_9.lititup.mixin.compatibility.accessors.Mk2Accessor;
import com.eruannie_9.lititup.util.EnvironmentCheck;
import com.eruannie_9.lititup.util.interfaces.IIgnited;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vapourdrive.furnacemk2.furnace.FurnaceMk2Tile;

@Mixin(value={FurnaceMk2Tile.class})
public class SmelterMK2ManagerMixin
implements IIgnited {
    @Unique
    private boolean ignited = false;
    @Unique
    private int emptyInputTime = 0;

    @Override
    public void setIgnitedByPlayer(boolean ignited) {
        this.ignited = ignited;
    }

    @Override
    public boolean isIgnitedByPlayer() {
        return this.ignited;
    }

    @Inject(method={"load"}, at={@At(value="TAIL")})
    public void onLoad(CompoundTag tag, CallbackInfo ci) {
        this.ignited = tag.m_128471_("Ignited");
        this.emptyInputTime = tag.m_128451_("EmptyInputTime");
    }

    @Inject(method={"saveAdditional"}, at={@At(value="TAIL")})
    public void onSave(CompoundTag tag, CallbackInfo ci) {
        tag.m_128379_("Ignited", this.ignited);
        tag.m_128405_("EmptyInputTime", this.emptyInputTime);
    }

    @Inject(method={"doCookProcesses"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void onCookProcesses(ItemStack ingredient, BlockState state, CallbackInfo ci) {
        if (((Boolean)ModConfiguration.MK2_FURNACE.get()).booleanValue()) {
            boolean isActive;
            FurnaceMk2Tile furnace = (FurnaceMk2Tile)this;
            boolean bl = isActive = furnace.getFurnaceData().cookProgress > 0 || (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false;
            if (isActive) {
                return;
            }
            Level world = furnace.m_58904_();
            BlockPos pos = furnace.m_58899_();
            boolean hasLavaOrFireBelow = EnvironmentCheck.isHeatSourceBelow(world, pos);
            boolean isRainingAbove = EnvironmentCheck.isPrecipitationAbove(world, pos);
            if (!(this.isIgnitedByPlayer() || hasLavaOrFireBelow && !isRainingAbove && ((Boolean)ModConfiguration.HOT_BLOCK_IGNITION.get()).booleanValue())) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"tickServer"}, at={@At(value="TAIL")}, remap=false)
    private void onTick(CallbackInfo ci) {
        if (((Boolean)ModConfiguration.MK2_FURNACE.get()).booleanValue()) {
            FurnaceMk2Tile tile = (FurnaceMk2Tile)this;
            boolean isCooking = tile.getFurnaceData().cookProgress > 0;
            boolean isBlockUnlit = (Boolean)tile.m_58900_().m_61143_((Property)BlockStateProperties.f_61443_) == false;
            ItemStack inputStack = ((Mk2Accessor)tile).getIngredientHandler().getStackInSlot(FurnaceMk2Tile.INPUT_SLOT[0]);
            if (isBlockUnlit && !((Mk2Accessor)tile).getLastSmelting().m_41619_()) {
                this.setIgnitedByPlayer(false);
            }
            if (!isBlockUnlit) {
                this.emptyInputTime = inputStack.m_41619_() || !isCooking ? ++this.emptyInputTime : 0;
                if (this.emptyInputTime > 60) {
                    this.setIgnitedByPlayer(false);
                    if (tile.m_58904_() != null) {
                        BlockState unlitState = (BlockState)tile.m_58900_().m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false));
                        tile.m_58904_().m_7731_(tile.m_58899_(), unlitState, 3);
                    }
                }
            }
        }
    }
}

