/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.lititup;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;

public class ModConfiguration {
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> FURNACE_EXECUTOR_ITEM_LIST;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> FURNACE_EXECUTOR_BLOCK_LIST;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> CAMPFIRE_IGNITOR_ITEM_LIST;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> SWITCHGRASS_SOILS;
    public static final ForgeConfigSpec.BooleanValue TOUGH_PURIFIER;
    public static final ForgeConfigSpec.BooleanValue BRICK_FURNACE;
    public static final ForgeConfigSpec.BooleanValue IRON_FURNACE;
    public static final ForgeConfigSpec.BooleanValue BETTER_FURNACE;
    public static final ForgeConfigSpec.BooleanValue AETHER;
    public static final ForgeConfigSpec.BooleanValue MAIN;
    public static final ForgeConfigSpec.ConfigValue<String> SWITCHGRASS_FIBER_REPLACEMENT;
    public static final ForgeConfigSpec.BooleanValue SWITCHGRASS_SPAWN;
    public static final ForgeConfigSpec.IntValue SWITCHGRASS_SPAWN_RARITY;
    public static final ForgeConfigSpec.BooleanValue SWITCHGRASS_BONE_MEAL;
    public static final ForgeConfigSpec.IntValue SPARKLING_FLINT_COOLDOWN;
    public static final ForgeConfigSpec.IntValue SPARKLING_FLINT_DURABILITY;
    public static final ForgeConfigSpec.DoubleValue SPARKLING_FLINT_SUCCESS_CHANCE;
    public static final ForgeConfigSpec.BooleanValue CAMPFIRE_PLACED_UNLIT;
    public static final ForgeConfigSpec.BooleanValue GOLDEN_LIGHTER_LOOT;
    public static final ForgeConfigSpec.DoubleValue GOLDEN_LIGHTER_LOOT_CHANCE;
    public static final ForgeConfigSpec.BooleanValue FIRE_ASPECT;
    public static final ForgeConfigSpec.BooleanValue HOT_BLOCK_IGNITION;
    public static final ForgeConfigSpec.BooleanValue DOUBLE_FLINT_IGNITION;
    public static final ForgeConfigSpec.DoubleValue DOUBLE_FLINT_CHANCE;

    public static boolean isCampfireIgniter(ItemStack stack) {
        return ModConfiguration.isCampfireIgniter(stack.m_41720_());
    }

    public static boolean isCampfireIgniter(Item item) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item);
        return id != null && ((List)CAMPFIRE_IGNITOR_ITEM_LIST.get()).contains(id.toString());
    }

    public static boolean isValidSwitchgrassSoil(BlockState state) {
        ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
        if (id == null) {
            return false;
        }
        for (String s : (List)SWITCHGRASS_SOILS.get()) {
            if (!s.equals(id.toString())) continue;
            return true;
        }
        return false;
    }

    public static void registerConfig() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SPEC);
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("Furnace & Ignition");
        builder.comment("Enable or disable vanilla furnace item ignition.\nTurning this off may affect mods that use vanilla logic for their custom furnace blocks.\n");
        MAIN = builder.define("Main_Executor_Event", true);
        builder.comment("Fire Aspect can ignite supported blocks.");
        FIRE_ASPECT = builder.define("Fire_Aspect_Ignition", true);
        builder.comment("Furnaces above blocks present within 'Furnace_Executor_Block_List' config value, will keep vanilla smelting logic.");
        HOT_BLOCK_IGNITION = builder.define("Hot_Block_Ignition", true);
        builder.comment("Newly placed campfires start unlit.");
        CAMPFIRE_PLACED_UNLIT = builder.define("Place_Campfires_Unlit", true);
        builder.comment("Allows to ignite the furnace with double flint (one in each hand).");
        DOUBLE_FLINT_IGNITION = builder.define("Double_Flint_Ignition", false);
        builder.comment("Chance for the double flint ignition.");
        DOUBLE_FLINT_CHANCE = builder.defineInRange("Double_Flint_Base_Chance", 0.15, 0.0, 1.0);
        builder.comment("List of items that can ignite furnace blocks. Items only.");
        FURNACE_EXECUTOR_ITEM_LIST = builder.defineList("Furnace_Executor_Item_List", List.of("minecraft:flint_and_steel", "lititup:sparkling_flint", "lititup:golden_lighter"), item -> item instanceof String);
        builder.comment("Blocks that can ignite a furnace when placed below. Format: 'modid:blockid[:true|false]'\nThe true/false value refers only to the 'lit' state property if present.\n\nExamples:\n - 'minecraft:campfire:true' (treat as lit)\n - 'minecraft:campfire:false' (treat as unlit)\n - 'minecraft:magma_block' (no lit flag)\n");
        FURNACE_EXECUTOR_BLOCK_LIST = builder.defineList("Furnace_Executor_Block_List", List.of("minecraft:fire", "minecraft:campfire:true", "minecraft:soul_campfire:true", "minecraft:magma_block", "minecraft:lava"), item -> item instanceof String);
        builder.comment("Items that are allowed to light UNLIT campfires (by registry id).\nExample: \"minecraft:flint_and_steel\", \"lititup:sparkling_flint\"\n");
        CAMPFIRE_IGNITOR_ITEM_LIST = builder.defineList("Campfire_Ignitor_Item_List", List.of("minecraft:flint_and_steel", "lititup:sparkling_flint", "lititup:golden_lighter"), item -> item instanceof String);
        builder.pop();
        builder.push("Sparkling Flint Settings");
        builder.comment("Item consumed when using Sparkling Flint.\nUse an empty string (\"\") to consume nothing. Within Bookling Gear settings, just remove the value.\n");
        SWITCHGRASS_FIBER_REPLACEMENT = builder.define("Sparkling_flint_consumption_item", (Object)"lititup:switchgrass_fiber");
        builder.comment("Sparkling Flint success chance. (0.6 = 60%)");
        SPARKLING_FLINT_SUCCESS_CHANCE = builder.defineInRange("Sparkling_Flint_Jam_Chance", 0.6, 0.0, 1.0);
        builder.comment("Cooldown after a jam (ticks).");
        SPARKLING_FLINT_COOLDOWN = builder.defineInRange("Sparkling_Flint_Cooldown", 40, 2, Integer.MAX_VALUE);
        builder.comment("Total durability for Sparkling Flint.");
        SPARKLING_FLINT_DURABILITY = builder.defineInRange("Sparkling_Flint_Durability", 5, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push("World Settings");
        builder.comment("Spawn Switchgrass in newly generated chunks.");
        SWITCHGRASS_SPAWN = builder.define("Switchgrass_Spawn", true);
        builder.comment("Average rarity for natural switchgrass patches spawn.\n1 = try every chunk, 32 = once every 32 tries on average, higher = rarer.\n");
        SWITCHGRASS_SPAWN_RARITY = builder.defineInRange("Switchgrass_Spawn_Rarity", 32, 1, 4096);
        builder.comment("Block IDs that switchgrass is allowed to grow on.");
        SWITCHGRASS_SOILS = builder.defineList("Switchgrass_Soil", List.of("minecraft:grass_block", "minecraft:dirt", "minecraft:rooted_dirt"), item -> item instanceof String);
        builder.comment("Allow the bone meal item to spawn switchgrass once in a while.");
        SWITCHGRASS_BONE_MEAL = builder.define("Switchgrass_Bone_Meal", true);
        builder.comment("Add the Golden Lighter to selected loots (mineshafts, village toolsmith, buried treasure, desert pyramid).");
        GOLDEN_LIGHTER_LOOT = builder.define("Golden_Lighter_Loot", true);
        builder.comment("Chance for the Golden Lighter to appear in its designated loot spots (0.0 = never, 1.0 = always).");
        GOLDEN_LIGHTER_LOOT_CHANCE = builder.defineInRange("Golden_Lighter_Loot_Chance", 0.3, 0.0, 1.0);
        builder.pop();
        builder.push("Compatibility Handler");
        builder.comment("Compatibility with Brick Furnace.\nLink: https://www.curseforge.com/minecraft/mc-mods/brick-furnace");
        BRICK_FURNACE = builder.define("Brick_Furnace_Mod_Compatibility", true);
        builder.comment("Compatibility with Iron Furnaces.\nLink: https://www.curseforge.com/minecraft/mc-mods/iron-furnaces");
        IRON_FURNACE = builder.define("Iron_Furnaces_Mod_Compatibility", true);
        builder.comment("Compatibility with Better Furnace Reforged.\nLink: https://www.curseforge.com/minecraft/mc-mods/better-furnaces-reforged");
        BETTER_FURNACE = builder.define("Better_Furnaces_Reforged_Mod_Compatibility", true);
        builder.comment("Compatibility with Tough As Nails.\nLink: https://www.curseforge.com/minecraft/mc-mods/tough-as-nails");
        TOUGH_PURIFIER = builder.define("Tough_As_Nails_Mod_Compatibility", true);
        builder.comment("Compatibility with the Aether mod.\nFalse by default: flint and steel cannot be used in the Aether dimension.\nLink: https://www.curseforge.com/minecraft/mc-mods/aether\n");
        AETHER = builder.define("Aether_Mod_Compatibility", false);
        builder.pop();
        SPEC = builder.build();
    }
}

