/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.lititup.color;

import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ColorUtil {
    public static int getBaseTintedColor(BlockAndTintGetter world, BlockPos pos, float blendRatio) {
        return ColorUtil.getTintedGrassColor(world, pos, blendRatio);
    }

    public static int getSmoothGrassColor(BlockAndTintGetter world, BlockPos pos, float blendRatio) {
        int radius = 2;
        int red = 0;
        int green = 0;
        int blue = 0;
        int count = 0;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                int color = ColorUtil.getTintedGrassColor(world, pos.m_7918_(dx, 0, dz), blendRatio);
                red += FastColor.ARGB32.m_13665_((int)color);
                green += FastColor.ARGB32.m_13667_((int)color);
                blue += FastColor.ARGB32.m_13669_((int)color);
                ++count;
            }
        }
        return FastColor.ARGB32.m_13660_((int)255, (int)(red / count), (int)(green / count), (int)(blue / count));
    }

    public static int getTintedGrassColor(BlockAndTintGetter world, BlockPos pos, float blendRatio) {
        float blendedValue;
        float blendedSaturation;
        float blendedHue;
        int baseColor = BiomeColors.m_108793_((BlockAndTintGetter)world, (BlockPos)pos);
        float[] hsvBase = ColorUtil.rgbToHsv(FastColor.ARGB32.m_13665_((int)baseColor), FastColor.ARGB32.m_13667_((int)baseColor), FastColor.ARGB32.m_13669_((int)baseColor));
        blendRatio = Mth.m_14036_((float)blendRatio, (float)0.0f, (float)2.0f);
        float targetHueStart = 60.0f;
        float targetHueEnd = 50.0f;
        float targetSaturation = 1.0f;
        float targetValue = 1.0f;
        float h = hsvBase[0];
        float s = hsvBase[1];
        float v = hsvBase[2];
        if (blendRatio <= 1.0f) {
            float hueDifference = targetHueStart - h;
            if (hueDifference > 180.0f) {
                hueDifference -= 360.0f;
            } else if (hueDifference < -180.0f) {
                hueDifference += 360.0f;
            }
            blendedHue = (h + hueDifference * blendRatio + 360.0f) % 360.0f;
            blendedSaturation = Mth.m_14179_((float)blendRatio, (float)s, (float)targetSaturation);
            blendedValue = Mth.m_14179_((float)blendRatio, (float)v, (float)targetValue);
        } else {
            float extraBlend = blendRatio - 1.0f;
            blendedHue = Mth.m_14179_((float)extraBlend, (float)targetHueStart, (float)targetHueEnd);
            blendedSaturation = targetSaturation;
            blendedValue = targetValue;
        }
        blendedHue = (blendedHue + 360.0f) % 360.0f;
        blendedSaturation = Mth.m_14036_((float)blendedSaturation, (float)0.0f, (float)1.0f);
        blendedValue = Mth.m_14036_((float)blendedValue, (float)0.0f, (float)1.0f);
        int[] rgb = ColorUtil.hsvToRgb(blendedHue, blendedSaturation, blendedValue);
        return FastColor.ARGB32.m_13660_((int)255, (int)rgb[0], (int)rgb[1], (int)rgb[2]);
    }

    private static float[] rgbToHsv(int red, int green, int blue) {
        float r = (float)red / 255.0f;
        float g = (float)green / 255.0f;
        float b = (float)blue / 255.0f;
        float max = Math.max(r, Math.max(g, b));
        float min = Math.min(r, Math.min(g, b));
        float delta = max - min;
        float h = 0.0f;
        if (delta != 0.0f) {
            if (max == r) {
                h = 60.0f * ((g - b) / delta % 6.0f);
            } else if (max == g) {
                h = 60.0f * ((b - r) / delta + 2.0f);
            } else if (max == b) {
                h = 60.0f * ((r - g) / delta + 4.0f);
            }
        }
        if (h < 0.0f) {
            h += 360.0f;
        }
        float s = max == 0.0f ? 0.0f : delta / max;
        float v = max;
        return new float[]{h, s, v};
    }

    private static int[] hsvToRgb(float h, float s, float v) {
        float c = s * v;
        float x = c * (1.0f - Math.abs(h / 60.0f % 2.0f - 1.0f));
        float m = v - c;
        float r1 = 0.0f;
        float g1 = 0.0f;
        float b1 = 0.0f;
        if (h >= 0.0f && h < 60.0f) {
            r1 = c;
            g1 = x;
        } else if (h >= 60.0f && h < 120.0f) {
            r1 = x;
            g1 = c;
        } else if (h >= 120.0f && h < 180.0f) {
            g1 = c;
            b1 = x;
        } else if (h >= 180.0f && h < 240.0f) {
            g1 = x;
            b1 = c;
        } else if (h >= 240.0f && h < 300.0f) {
            r1 = x;
            b1 = c;
        } else if (h >= 300.0f && h < 360.0f) {
            r1 = c;
            b1 = x;
        }
        float r = r1 + m;
        float g = g1 + m;
        float b = b1 + m;
        r = Mth.m_14036_((float)r, (float)0.0f, (float)1.0f);
        g = Mth.m_14036_((float)g, (float)0.0f, (float)1.0f);
        b = Mth.m_14036_((float)b, (float)0.0f, (float)1.0f);
        int ir = Math.round(r * 255.0f);
        int ig = Math.round(g * 255.0f);
        int ib = Math.round(b * 255.0f);
        return new int[]{ir, ig, ib};
    }
}

