/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.lititup.mixin.compatibility;

import com.eruannie_9.lititup.ModConfiguration;
import com.eruannie_9.lititup.util.EnvironmentCheck;
import com.eruannie_9.lititup.util.interfaces.IIgnited;
import com.eruannie_9.lititup.util.iron.IAugment;
import ironfurnaces.tileentity.furnaces.BlockIronFurnaceTileBase;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockIronFurnaceTileBase.class})
public abstract class SmelterIronManagerMixin
implements IIgnited,
IAugment {
    @Unique
    private boolean ignited = false;
    @Unique
    private ItemStack blueAugment = ItemStack.f_41583_;

    @Override
    public void setBlueAugment(ItemStack blueAugment) {
        this.blueAugment = blueAugment;
    }

    @Override
    public ItemStack getBlueAugment() {
        return this.blueAugment;
    }

    @Override
    public void setIgnitedByPlayer(boolean ignited) {
        this.ignited = ignited;
    }

    @Override
    public boolean isIgnitedByPlayer() {
        return this.ignited;
    }

    @Inject(method={"load"}, at={@At(value="TAIL")})
    public void onLoad(CompoundTag tag, CallbackInfo ci) {
        this.ignited = tag.m_128471_("Ignited");
        if (tag.m_128441_("BlueAugment")) {
            this.blueAugment = ItemStack.m_41712_((CompoundTag)tag.m_128469_("BlueAugment"));
        }
    }

    @Inject(method={"saveAdditional"}, at={@At(value="TAIL")})
    public void onSave(CompoundTag tag, CallbackInfo ci) {
        tag.m_128379_("Ignited", this.ignited);
        if (!this.blueAugment.m_41619_()) {
            tag.m_128365_("BlueAugment", (Tag)this.blueAugment.m_41739_(new CompoundTag()));
        }
    }

    @Inject(method={"canSmelt"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void onCanSmelt(@Nullable Recipe<?> recipe, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)ModConfiguration.IRON_FURNACE.get()).booleanValue()) {
            BlockIronFurnaceTileBase furnace = (BlockIronFurnaceTileBase)this;
            if (this.isActive(furnace)) {
                return;
            }
            Level world = furnace.m_58904_();
            BlockPos pos = furnace.m_58899_();
            boolean hasLavaOrFireBelow = EnvironmentCheck.isHeatSourceBelow(world, pos);
            boolean isRainingAbove = EnvironmentCheck.isPrecipitationAbove(world, pos);
            if (!(this.isIgnitedByPlayer() || hasLavaOrFireBelow && !isRainingAbove && ((Boolean)ModConfiguration.HOT_BLOCK_IGNITION.get()).booleanValue())) {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"getGeneratorBurn"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void onGetGeneratorBurn(CallbackInfoReturnable<Integer> cir) {
        if (((Boolean)ModConfiguration.IRON_FURNACE.get()).booleanValue()) {
            BlockIronFurnaceTileBase furnace = (BlockIronFurnaceTileBase)this;
            if (this.isActive(furnace)) {
                return;
            }
            Level world = furnace.m_58904_();
            BlockPos pos = furnace.m_58899_();
            boolean hasLavaOrFireBelow = EnvironmentCheck.isHeatSourceBelow(world, pos);
            boolean isRainingAbove = EnvironmentCheck.isPrecipitationAbove(world, pos);
            if (!(this.isIgnitedByPlayer() || hasLavaOrFireBelow && !isRainingAbove && ((Boolean)ModConfiguration.HOT_BLOCK_IGNITION.get()).booleanValue())) {
                cir.setReturnValue((Object)0);
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;shrink(I)V", ordinal=0)}, cancellable=true)
    private static void itemShrink(Level level, BlockPos pos, BlockState state, BlockIronFurnaceTileBase entity, CallbackInfo ci) {
        if (((Boolean)ModConfiguration.IRON_FURNACE.get()).booleanValue()) {
            Level world = entity.m_58904_();
            SmelterIronManagerMixin mixin = (SmelterIronManagerMixin)entity;
            if (mixin.isActive(entity)) {
                return;
            }
            boolean hasLavaOrFireBelow = EnvironmentCheck.isHeatSourceBelow(world, pos);
            boolean isRainingAbove = EnvironmentCheck.isPrecipitationAbove(world, pos);
            IIgnited ignitedBlock = (IIgnited)entity;
            if (!(ignitedBlock.isIgnitedByPlayer() || hasLavaOrFireBelow && !isRainingAbove && ((Boolean)ModConfiguration.HOT_BLOCK_IGNITION.get()).booleanValue())) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")}, remap=false)
    private static void onTick(Level level, BlockPos pos, BlockState state, BlockIronFurnaceTileBase entity, CallbackInfo ci) {
        if (((Boolean)ModConfiguration.IRON_FURNACE.get()).booleanValue()) {
            IAugment augmentBlock = (IAugment)entity;
            IIgnited ignitedBlock = (IIgnited)entity;
            ItemStack currentBlueAugment = entity.m_8020_(5);
            if (augmentBlock.getBlueAugment().m_41619_() && !currentBlueAugment.m_41619_()) {
                augmentBlock.setBlueAugment(currentBlueAugment.m_41777_());
            } else if (!augmentBlock.getBlueAugment().m_41619_() && currentBlueAugment.m_41619_()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.FALSE), 3);
                augmentBlock.setBlueAugment(ItemStack.f_41583_);
            }
            if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
                ignitedBlock.setIgnitedByPlayer(false);
            }
        }
    }

    private boolean isActive(BlockIronFurnaceTileBase furnace) {
        return furnace.isBurning() || furnace.cookTime > 0 || furnace.isFactoryCooking() || furnace.generatorBurn > 0.0;
    }
}

