/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.lititup.mixin.compatibility;

import com.eruannie_9.lititup.ModConfiguration;
import com.eruannie_9.lititup.mixin.compatibility.accessors.BetterAccessor;
import com.eruannie_9.lititup.util.FireAspectUtil;
import com.eruannie_9.lititup.util.SmelterUtil;
import com.eruannie_9.lititup.util.curio.CurioUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.betterfurnaces.blockentity.SmeltingBlockEntity;
import wily.betterfurnaces.blocks.SmeltingBlock;
import wily.betterfurnaces.init.Registration;
import wily.betterfurnaces.items.UpgradeItem;
import wily.factoryapi.ItemContainerUtil;

@Mixin(value={SmeltingBlock.class})
public class SmelterBetterExecutorMixin {
    @Unique
    private boolean canIgniteFurnace(SmeltingBlockEntity furnace, Level level) {
        boolean hasFuel = Arrays.stream(furnace.FUEL()).anyMatch(slot -> SmeltingBlockEntity.isItemFuel((ItemStack)furnace.inventory.m_8020_(slot)));
        boolean hasRecipe = Arrays.stream(furnace.INPUTS()).anyMatch(slot -> furnace.hasRecipe(furnace.inventory.m_8020_(slot)));
        boolean hasGenerator = furnace.hasUpgrade((UpgradeItem)Registration.GENERATOR.get()) && this.isGeneratorWithLiquid(furnace);
        boolean recipeMatches = false;
        if (hasRecipe) {
            RegistryAccess regs = level.m_9598_();
            for (int i = 0; i < furnace.INPUTS().length; ++i) {
                int in = furnace.INPUTS()[i];
                int out = furnace.OUTPUTS()[i];
                ItemStack input = furnace.inventory.m_8020_(in);
                Optional<AbstractCookingRecipe> rec = ((BetterAccessor)furnace).invokeGetRecipe(input, (RecipeType<? extends AbstractCookingRecipe>)furnace.recipeType);
                if (!rec.isPresent()) continue;
                ItemStack expected = rec.get().m_8043_(regs);
                ItemStack current = furnace.inventory.m_8020_(out);
                if (!current.m_41619_() && current.m_41720_() != expected.m_41720_()) continue;
                recipeMatches = true;
                break;
            }
        }
        return hasFuel && (recipeMatches || hasGenerator);
    }

    @Unique
    private boolean isIgnitionItem(Item item) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item);
        return id != null && ((List)ModConfiguration.FURNACE_EXECUTOR_ITEM_LIST.get()).contains(id.toString());
    }

    @Unique
    private boolean isGeneratorWithLiquid(SmeltingBlockEntity furnace) {
        ItemStack stack = furnace.getUpgradeSlotItem((Item)Registration.GENERATOR.get());
        return ItemContainerUtil.isFluidContainer((ItemStack)stack) && ItemContainerUtil.getFluid((ItemStack)stack).getAmount() > 0L;
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    public void onUse(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, CallbackInfoReturnable<InteractionResult> cir) {
        SmeltingBlockEntity furnace;
        BlockEntity be;
        block10: {
            block9: {
                if (!((Boolean)ModConfiguration.BETTER_FURNACE.get()).booleanValue() || level.f_46443_) {
                    return;
                }
                be = level.m_7702_(pos);
                if (!(be instanceof SmeltingBlockEntity)) break block9;
                furnace = (SmeltingBlockEntity)be;
                if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) break block10;
            }
            return;
        }
        if (!this.canIgniteFurnace(furnace, level)) {
            return;
        }
        if (CurioUtil.isCuriosLoaded() && CurioUtil.hasGoldenLighter(player)) {
            SmelterUtil.igniteWithCuriosSlot(level, pos, state, (BlockEntity)furnace, player, cir);
            return;
        }
        ItemStack stackInHand = player.m_21120_(hand);
        Item item = stackInHand.m_41720_();
        boolean fireAspect = FireAspectUtil.hasFireAspect(stackInHand);
        if (player.m_36335_().m_41519_(item) || !this.isIgnitionItem(item) && !fireAspect) {
            return;
        }
        if (stackInHand.m_41763_()) {
            SmelterUtil.tryIgnite(level, pos, state, be, player, item, stackInHand, hand, cir);
        } else {
            SmelterUtil.tryShrinkAndIgnite(level, pos, state, be, player, item, stackInHand, hand, cir);
        }
    }
}

