/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.lititup.mixin.compatibility;

import com.eruannie_9.lititup.ModConfiguration;
import com.eruannie_9.lititup.util.EnvironmentCheck;
import com.eruannie_9.lititup.util.interfaces.IIgnited;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import toughasnails.block.WaterPurifierBlock;
import toughasnails.block.entity.WaterPurifierBlockEntity;

@Mixin(value={WaterPurifierBlockEntity.class})
public class ToughPurifierManagerMixin
implements IIgnited {
    @Unique
    private boolean ignited = false;

    @Override
    public void setIgnitedByPlayer(boolean ignited) {
        this.ignited = ignited;
    }

    @Override
    public boolean isIgnitedByPlayer() {
        return this.ignited;
    }

    @Inject(method={"load"}, at={@At(value="TAIL")})
    public void onLoad(CompoundTag tag, CallbackInfo ci) {
        this.ignited = tag.m_128471_("Ignited");
    }

    @Inject(method={"saveAdditional"}, at={@At(value="TAIL")})
    public void onSave(CompoundTag tag, CallbackInfo ci) {
        tag.m_128379_("Ignited", this.ignited);
    }

    @Inject(method={"canFilter"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void onCanFilter(@Nullable Recipe<?> recipe, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)ModConfiguration.TOUGH_PURIFIER.get()).booleanValue()) {
            return;
        }
        WaterPurifierBlockEntity self = (WaterPurifierBlockEntity)this;
        if (self.isFiltering()) {
            return;
        }
        Level level = self.m_58904_();
        BlockPos pos = self.m_58899_();
        boolean hasLavaOrFireBelow = EnvironmentCheck.isHeatSourceBelow(level, pos);
        boolean isRainingAbove = EnvironmentCheck.isPrecipitationAbove(level, pos);
        if (!(this.isIgnitedByPlayer() || hasLavaOrFireBelow && !isRainingAbove && ((Boolean)ModConfiguration.HOT_BLOCK_IGNITION.get()).booleanValue())) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"serverTick"}, at={@At(value="TAIL")}, remap=false)
    private static void onServerTick(Level level, BlockPos pos, BlockState state, WaterPurifierBlockEntity entity, CallbackInfo ci) {
        if (((Boolean)ModConfiguration.TOUGH_PURIFIER.get()).booleanValue() && !((Boolean)state.m_61143_((Property)WaterPurifierBlock.PURIFYING)).booleanValue()) {
            ((IIgnited)entity).setIgnitedByPlayer(false);
        }
    }
}

