/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.lititup.event.animation;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="lititup", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class TPStrikeAnimation {
    private static final Int2ObjectMap<State> STATES = new Int2ObjectOpenHashMap();
    public static final int DURATION_TICKS = 9;
    private static final float WINDUP_T = 0.35f;
    private static final float STRIKE_T = 0.62f;
    private static final float IMPACT_HOLD_T = 0.68f;
    private static final float RECOIL_T = 0.84f;
    private static final float YAW_TO_CENTER_DEG = 18.0f;
    private static final float X_RAISE_DEG = 56.0f;
    private static final float ROLL_EDGE_DEG = 10.0f;
    private static final float PITCH_EDGE_DEG = 10.0f;
    private static final float RECOIL_X_DEG = 6.0f;
    private static final float LIFT_Y = 0.16f;
    private static final float PUSH_Z = -0.06f;

    public static void startFor(int entityId, boolean success) {
        STATES.put(entityId, (Object)new State(9, success));
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent e) {
        if (e.phase != TickEvent.Phase.END || STATES.isEmpty()) {
            return;
        }
        STATES.int2ObjectEntrySet().removeIf(entry -> {
            State s = (State)entry.getValue();
            if (s.ticksLeft > 0) {
                --s.ticksLeft;
            }
            return s.ticksLeft <= 0;
        });
    }

    public static void applyPoseIfActive(HumanoidModel<?> model, AbstractClientPlayer player) {
        State st = (State)STATES.get(player.m_19879_());
        if (st == null || st.ticksLeft <= 0) {
            return;
        }
        if (!player.m_21205_().m_150930_(Items.f_42484_) || !player.m_21206_().m_150930_(Items.f_42484_)) {
            return;
        }
        float partial = Minecraft.m_91087_().m_91296_();
        float t = 1.0f - ((float)st.ticksLeft - partial) / 9.0f;
        t = Mth.m_14036_((float)t, (float)0.0f, (float)1.0f);
        if (!st.impactFired && t >= 0.62f) {
            st.impactFired = true;
            TPStrikeAnimation.spawnImpactVFXAtPlayer(player, partial, st.success);
        }
        Angles baseR = new Angles(model.f_102811_.f_104203_, model.f_102811_.f_104204_, model.f_102811_.f_104205_);
        Angles baseL = new Angles(model.f_102812_.f_104203_, model.f_102812_.f_104204_, model.f_102812_.f_104205_);
        Angles right = TPStrikeAnimation.computeArmAngles(true, t, baseR);
        Angles left = TPStrikeAnimation.computeArmAngles(false, t, baseL);
        model.f_102811_.f_104203_ = right.xRot;
        model.f_102811_.f_104204_ = right.yRot;
        model.f_102811_.f_104205_ = right.zRot;
        model.f_102812_.f_104203_ = left.xRot;
        model.f_102812_.f_104204_ = left.yRot;
        model.f_102812_.f_104205_ = left.zRot;
        model.f_102608_ = 0.0f;
    }

    private static Angles computeArmAngles(boolean rightArm, float t, Angles base) {
        float s = rightArm ? 1.0f : -1.0f;
        Angles preImpact = new Angles(TPStrikeAnimation.deg(-39.2f) + TPStrikeAnimation.deg(-2.0f * s), TPStrikeAnimation.deg(-13.5f * s), TPStrikeAnimation.deg(-6.0f * s));
        Angles impact = new Angles(TPStrikeAnimation.deg(-56.0f) + TPStrikeAnimation.deg(-3.5f * s), TPStrikeAnimation.deg(-18.0f * s), TPStrikeAnimation.deg(-10.0f * s));
        Angles recoil = new Angles(TPStrikeAnimation.deg(-50.0f), TPStrikeAnimation.deg(-18.0f * s * 0.55f), TPStrikeAnimation.deg(-10.0f * s * 0.55f));
        if (t <= 0.35f) {
            float w = TPStrikeAnimation.easeOutCubic(t / 0.35f);
            return TPStrikeAnimation.lerpAngles(base, preImpact, w);
        }
        if (t <= 0.62f) {
            float u = (t - 0.35f) / 0.27f;
            float w = TPStrikeAnimation.easeInQuint(u);
            return TPStrikeAnimation.lerpAngles(preImpact, impact, w);
        }
        if (t <= 0.68f) {
            float u = (t - 0.62f) / 0.060000002f;
            float bump = TPStrikeAnimation.bump01(u);
            return new Angles(impact.xRot, impact.yRot, impact.zRot + TPStrikeAnimation.deg(-1.5f * s) * bump);
        }
        if (t <= 0.84f) {
            float u = (t - 0.68f) / 0.15999997f;
            float w = TPStrikeAnimation.easeOutCubic(u);
            return TPStrikeAnimation.lerpAngles(impact, recoil, w);
        }
        float u = (t - 0.84f) / 0.16000003f;
        float w = TPStrikeAnimation.easeOutCubic(u);
        return TPStrikeAnimation.lerpAngles(recoil, base, w);
    }

    private static Angles lerpAngles(Angles a, Angles b, float w) {
        return new Angles(Mth.m_14179_((float)w, (float)a.xRot, (float)b.xRot), Mth.m_14179_((float)w, (float)a.yRot, (float)b.yRot), Mth.m_14179_((float)w, (float)a.zRot, (float)b.zRot));
    }

    private static float deg(float d) {
        return (float)((double)d * Math.PI / 180.0);
    }

    private static float easeOutCubic(float x) {
        float inv = 1.0f - x;
        return 1.0f - inv * inv * inv;
    }

    private static float easeInQuint(float x) {
        return x * x * x * x * x;
    }

    private static float bump01(float u) {
        u = Mth.m_14036_((float)u, (float)0.0f, (float)1.0f);
        float s = u * u * (3.0f - 2.0f * u);
        return 4.0f * s * (1.0f - s);
    }

    private static void spawnImpactVFXAtPlayer(AbstractClientPlayer player, float partialTick, boolean success) {
        Level level = player.m_9236_();
        Vec3 eye = player.m_20299_(partialTick);
        Vec3 look = player.m_20252_(partialTick).m_82541_();
        Vec3 p = eye.m_82549_(look.m_82490_(0.58)).m_82520_(0.0, 0.15199999660253524, 0.0).m_82520_(0.0, 0.0, -0.0479999989271164);
        Vec3 worldUp = new Vec3(0.0, 1.0, 0.0);
        Vec3 sideVec = look.m_82537_(worldUp);
        if (sideVec.m_82556_() < 1.0E-4) {
            sideVec = new Vec3(1.0, 0.0, 0.0);
        }
        boolean rightHanded = player.m_5737_() == HumanoidArm.RIGHT;
        sideVec = sideVec.m_82541_().m_82490_(rightHanded ? 1.0 : -1.0);
        if (success) {
            int fireCount = 2 + level.f_46441_.m_188503_(2);
            double flameY = p.f_82480_ - 0.035;
            for (int i = 0; i < fireCount; ++i) {
                double ex = (level.f_46441_.m_188500_() - 0.5) * 0.01;
                double ez = (level.f_46441_.m_188500_() - 0.5) * 0.01;
                double ey = 0.018 + (double)i * 0.004;
                level.m_7106_((ParticleOptions)ParticleTypes.f_175834_, p.f_82479_, flameY, p.f_82481_, ex, ey, ez);
            }
        } else {
            int sparkCount = 6 + level.f_46441_.m_188503_(4);
            for (int i = 0; i < sparkCount; ++i) {
                Vec3 axis = sideVec.m_82490_(0.85 + level.f_46441_.m_188500_() * 0.35).m_82549_(look.m_82490_(0.25 + level.f_46441_.m_188500_() * 0.2)).m_82520_(0.0, 0.05 + level.f_46441_.m_188500_() * 0.04, 0.0).m_82541_();
                if (level.f_46441_.m_188500_() < 0.3) {
                    axis = axis.m_82490_(-1.0);
                }
                Vec3 dir = TPStrikeAnimation.randomDirInCone(level.f_46441_, axis, Math.toRadians(55.0));
                double speed = 0.1 + level.f_46441_.m_188500_() * 0.12;
                Vec3 v = dir.m_82490_(speed);
                level.m_7106_((ParticleOptions)ParticleTypes.f_175830_, p.f_82479_, p.f_82480_, p.f_82481_, v.f_82479_, v.f_82480_, v.f_82481_);
            }
            level.m_7785_(p.f_82479_, p.f_82480_, p.f_82481_, SoundEvents.f_11942_, SoundSource.PLAYERS, 0.32f, 2.0f, false);
        }
    }

    private static Vec3 randomDirInCone(RandomSource random, Vec3 axis, double coneHalfAngleRad) {
        Vec3 a = axis.m_82541_();
        Vec3 ortho = Math.abs(a.f_82479_) < 0.9 ? new Vec3(1.0, 0.0, 0.0) : new Vec3(0.0, 1.0, 0.0);
        Vec3 tangent = a.m_82537_(ortho).m_82541_();
        Vec3 bitangent = a.m_82537_(tangent).m_82541_();
        double cosMax = Math.cos(coneHalfAngleRad);
        double cosTheta = cosMax + random.m_188500_() * (1.0 - cosMax);
        double sinTheta = Math.sqrt(Math.max(0.0, 1.0 - cosTheta * cosTheta));
        double phi = random.m_188500_() * (Math.PI * 2);
        return tangent.m_82490_(Math.cos(phi) * sinTheta).m_82549_(bitangent.m_82490_(Math.sin(phi) * sinTheta)).m_82549_(a.m_82490_(cosTheta)).m_82541_();
    }

    private static final class State {
        int ticksLeft;
        boolean impactFired;
        boolean success;

        State(int ticks, boolean success) {
            this.ticksLeft = ticks;
            this.success = success;
        }
    }

    private record Angles(float xRot, float yRot, float zRot) {
    }
}

