/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.lititup.util;

import com.eruannie_9.lititup.Item.ModItems;
import com.eruannie_9.lititup.ModConfiguration;
import com.eruannie_9.lititup.advancements.AdvancementHooks;
import com.eruannie_9.lititup.packethandler.PacketHandler;
import com.eruannie_9.lititup.packethandler.pack.FlintStrikeEntityPacket;
import com.eruannie_9.lititup.particles.ModParticles;
import com.eruannie_9.lititup.util.EnvironmentCheck;
import com.eruannie_9.lititup.util.FireAspectUtil;
import com.eruannie_9.lititup.util.ShrinkItemDefinition;
import com.eruannie_9.lititup.util.WeakLighterUtil;
import com.eruannie_9.lititup.util.curio.CurioUtil;
import com.eruannie_9.lititup.util.interfaces.IIgnited;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.api.type.util.ICuriosHelper;

public final class SmelterUtil {
    public static void igniteWithCuriosSlot(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity, Player player, CallbackInfoReturnable<InteractionResult> cir) {
        ((IIgnited)blockEntity).setIgnitedByPlayer(true);
        SmelterUtil.light(level, pos, state);
        level.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, 1.0f);
        CuriosApi.getCuriosHelper().findCurios((LivingEntity)player, new String[]{"lighter"}).stream().filter(r -> r.stack().m_150930_((Item)ModItems.GOLDEN_LIGHTER.get())).findFirst().ifPresent(res -> {
            ItemStack stack = res.stack();
            if (stack.m_41763_()) {
                stack.m_41622_(1, (LivingEntity)player, p -> CuriosApi.getCuriosHelper().onBrokenCurio(res.slotContext()));
            } else if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
        });
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SmelterUtil.executeParticles(serverLevel, pos);
            SmelterUtil.awardLightFurnace(level, pos, player);
            SmelterUtil.awardRainIgnite(level, pos, player);
        }
        cir.setReturnValue((Object)InteractionResult.SUCCESS);
        cir.cancel();
    }

    public static void tryIgnite(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity, Player player, Item item, ItemStack itemInHand, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        boolean weakLighterHandled = WeakLighterUtil.randomExecution(level, pos, state, blockEntity, player, item, itemInHand, hand, cir);
        if (weakLighterHandled) {
            if (WeakLighterUtil.wasSuccessfulIgnition() && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                SmelterUtil.executeParticles(serverLevel, pos);
                SmelterUtil.awardLightFurnace(level, pos, player);
                SmelterUtil.awardFireAspect(level, pos, player, itemInHand);
                SmelterUtil.awardRainIgnite(level, pos, player);
            }
            return;
        }
        ((IIgnited)blockEntity).setIgnitedByPlayer(true);
        SmelterUtil.light(level, pos, state);
        level.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, 1.0f);
        itemInHand.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SmelterUtil.executeParticles(serverLevel, pos);
            SmelterUtil.awardLightFurnace(level, pos, player);
            SmelterUtil.awardFireAspect(level, pos, player, itemInHand);
            SmelterUtil.awardRainIgnite(level, pos, player);
        }
        cir.setReturnValue((Object)InteractionResult.SUCCESS);
        cir.cancel();
    }

    public static void tryShrinkAndIgnite(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity, Player player, Item item, ItemStack itemInHand, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        boolean weakLighterHandled = WeakLighterUtil.randomExecution(level, pos, state, blockEntity, player, item, itemInHand, hand, cir);
        if (weakLighterHandled) {
            if (WeakLighterUtil.wasSuccessfulIgnition() && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                SmelterUtil.executeParticles(serverLevel, pos);
                SmelterUtil.awardLightFurnace(level, pos, player);
                SmelterUtil.awardFireAspect(level, pos, player, itemInHand);
                SmelterUtil.awardRainIgnite(level, pos, player);
            }
            return;
        }
        ((IIgnited)blockEntity).setIgnitedByPlayer(true);
        SmelterUtil.light(level, pos, state);
        level.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (!player.m_150110_().f_35937_) {
            itemInHand.m_41774_(1);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SmelterUtil.executeParticles(serverLevel, pos);
            SmelterUtil.awardLightFurnace(level, pos, player);
            SmelterUtil.awardFireAspect(level, pos, player, itemInHand);
            SmelterUtil.awardRainIgnite(level, pos, player);
        }
        cir.setReturnValue((Object)InteractionResult.SUCCESS);
        cir.cancel();
    }

    public static void tryIgniteWithFlints(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity, Player player, CallbackInfoReturnable<InteractionResult> cir) {
        boolean success;
        if (player.m_36335_().m_41519_(Items.f_42484_)) {
            cir.setReturnValue((Object)InteractionResult.PASS);
            cir.cancel();
            return;
        }
        int FLINT_STRIKE_COOLDOWN_TICKS = 20;
        player.m_36335_().m_41524_(Items.f_42484_, 20);
        float chance = Mth.m_14036_((float)((Double)ModConfiguration.DOUBLE_FLINT_CHANCE.get()).floatValue(), (float)0.0f, (float)1.0f);
        boolean bl = success = level.m_213780_().m_188501_() < chance;
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            PacketHandler.sendToTrackingAndSelf(sp, new FlintStrikeEntityPacket(sp.m_19879_(), success));
        }
        if (!success) {
            cir.setReturnValue((Object)InteractionResult.FAIL);
            cir.cancel();
            return;
        }
        ((IIgnited)blockEntity).setIgnitedByPlayer(true);
        SmelterUtil.light(level, pos, state);
        level.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SmelterUtil.executeParticles(serverLevel, pos);
            SmelterUtil.awardLightFurnace(level, pos, player);
            SmelterUtil.awardRainIgnite(level, pos, player);
        }
        cir.setReturnValue((Object)InteractionResult.SUCCESS);
        cir.cancel();
    }

    public static boolean tryCampfireCurioIgnition(Level level, BlockPos pos, BlockState state, Player player, CallbackInfoReturnable<InteractionResult> cir) {
        if (!CurioUtil.isCuriosLoaded()) {
            return false;
        }
        SlotResult curioRes = CuriosApi.getCuriosHelper().findCurios((LivingEntity)player, new String[]{"lighter"}).stream().filter(result -> ModConfiguration.isCampfireIgniter(result.stack())).findFirst().orElse(null);
        if (curioRes == null) {
            return false;
        }
        ItemStack curioStack = curioRes.stack();
        SmelterUtil.igniteCampfire(level, pos, state, player, curioStack);
        SmelterUtil.damageOrConsumeCurio(player, curioRes, level);
        SmelterUtil.postCampfireIgnite(level, pos, player, curioStack, false);
        cir.setReturnValue((Object)InteractionResult.m_19078_((boolean)level.m_5776_()));
        cir.cancel();
        return true;
    }

    public static boolean tryCampfireDoubleFlintIgnition(Level level, BlockPos pos, BlockState state, Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack other;
        if (!((Boolean)ModConfiguration.DOUBLE_FLINT_IGNITION.get()).booleanValue()) {
            return false;
        }
        ItemStack used = player.m_21120_(hand);
        if (!used.m_150930_(Items.f_42484_)) {
            return false;
        }
        ItemStack itemStack = other = hand == InteractionHand.MAIN_HAND ? player.m_21206_() : player.m_21205_();
        if (!other.m_150930_(Items.f_42484_)) {
            return false;
        }
        if (player.m_36335_().m_41519_(Items.f_42484_)) {
            cir.setReturnValue((Object)InteractionResult.PASS);
            cir.cancel();
            return true;
        }
        int FLINT_STRIKE_COOLDOWN_TICKS = 20;
        player.m_36335_().m_41524_(Items.f_42484_, 20);
        boolean creative = player.m_150110_().f_35937_;
        String reqIdStr = (String)ModConfiguration.SWITCHGRASS_FIBER_REPLACEMENT.get();
        boolean fiberRequired = reqIdStr != null && !reqIdStr.isBlank();
        ResourceLocation fiberId = fiberRequired ? new ResourceLocation(reqIdStr) : null;
        int fiberSlot = -1;
        if (!level.f_46443_ && fiberRequired && !creative) {
            fiberSlot = SmelterUtil.findFirstInventorySlot(player, fiberId);
        }
        float chance = Mth.m_14036_((float)((Double)ModConfiguration.DOUBLE_FLINT_CHANCE.get()).floatValue(), (float)0.0f, (float)1.0f);
        boolean success = false;
        if (!level.f_46443_) {
            boolean hasFiber = creative || !fiberRequired || fiberSlot >= 0;
            boolean bl = success = level.m_213780_().m_188501_() < chance && hasFiber;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketHandler.sendToTrackingAndSelf(serverPlayer, new FlintStrikeEntityPacket(serverPlayer.m_19879_(), success));
        }
        if (!success) {
            cir.setReturnValue((Object)InteractionResult.FAIL);
            cir.cancel();
            return true;
        }
        if (fiberRequired && !creative) {
            SmelterUtil.consumeFromSlot(player, fiberSlot);
        }
        SmelterUtil.igniteCampfire(level, pos, state, player, ItemStack.f_41583_);
        SmelterUtil.postCampfireIgnite(level, pos, player, ItemStack.f_41583_, false);
        cir.setReturnValue((Object)InteractionResult.m_19078_((boolean)level.m_5776_()));
        cir.cancel();
        return true;
    }

    public static boolean tryCampfireFlintAndSteelIgnition(Level level, BlockPos pos, BlockState state, Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_150930_(Items.f_42409_)) {
            return false;
        }
        if (!ModConfiguration.isCampfireIgniter(stack)) {
            cir.setReturnValue((Object)InteractionResult.PASS);
            cir.cancel();
            return true;
        }
        SmelterUtil.igniteCampfire(level, pos, state, player, stack);
        SmelterUtil.damageOrConsumeHand(player, hand, stack, level);
        SmelterUtil.postCampfireIgnite(level, pos, player, stack, false);
        cir.setReturnValue((Object)InteractionResult.m_19078_((boolean)level.m_5776_()));
        cir.cancel();
        return true;
    }

    public static boolean tryCampfireSparklingFlintIgnition(Level level, BlockPos pos, BlockState state, Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_150930_((Item)ModItems.SPARKLING_FLINT.get())) {
            return false;
        }
        if (!ModConfiguration.isCampfireIgniter(stack)) {
            cir.setReturnValue((Object)InteractionResult.PASS);
            cir.cancel();
            return true;
        }
        if (ShrinkItemDefinition.hasShrinkItem(player)) {
            cir.setReturnValue((Object)InteractionResult.PASS);
            cir.cancel();
            return true;
        }
        SmelterUtil.igniteCampfire(level, pos, state, player, stack);
        SmelterUtil.damageOrConsumeHand(player, hand, stack, level);
        ShrinkItemDefinition.shrinkItem(player);
        SmelterUtil.postCampfireIgnite(level, pos, player, stack, false);
        cir.setReturnValue((Object)InteractionResult.m_19078_((boolean)level.m_5776_()));
        cir.cancel();
        return true;
    }

    public static void tryCampfireHandIgniter(Level level, BlockPos pos, BlockState state, Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        boolean handAllowed;
        ItemStack handStack = player.m_21120_(hand);
        boolean isAllowedByConfig = ModConfiguration.isCampfireIgniter(handStack);
        boolean hasFireAspect = FireAspectUtil.hasFireAspect(handStack);
        boolean bl = handAllowed = isAllowedByConfig || hasFireAspect;
        if (!handAllowed) {
            return;
        }
        boolean isFlintAndSteel = handStack.m_150930_(Items.f_42409_);
        boolean isSparklingFlint = handStack.m_150930_((Item)ModItems.SPARKLING_FLINT.get());
        if (isFlintAndSteel || isSparklingFlint) {
            return;
        }
        SmelterUtil.igniteCampfire(level, pos, state, player, handStack);
        SmelterUtil.damageOrConsumeHand(player, hand, handStack, level);
        SmelterUtil.postCampfireIgnite(level, pos, player, handStack, true);
        cir.setReturnValue((Object)InteractionResult.m_19078_((boolean)level.m_5776_()));
        cir.cancel();
    }

    public static void igniteCampfire(Level level, BlockPos pos, BlockState state, Player player, ItemStack sourceStack) {
        if (!level.f_46443_) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 11);
            level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10591_.m_59469_(serverPlayer, pos, sourceStack);
            }
        }
        level.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.4f + 0.8f);
        player.m_36220_(Stats.f_12975_);
    }

    private static void postCampfireIgnite(Level level, BlockPos pos, Player player, ItemStack used, boolean checkFireAspect) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        SmelterUtil.executeParticles(serverLevel, pos);
        SmelterUtil.awardLightFurnace(level, pos, player);
        if (checkFireAspect) {
            SmelterUtil.awardFireAspect(level, pos, player, used);
        }
    }

    private static int findFirstInventorySlot(Player player, ResourceLocation itemId) {
        if (itemId == null) {
            return -1;
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ResourceLocation id;
            ItemStack s = player.m_150109_().m_8020_(i);
            if (s.m_41619_() || (id = ForgeRegistries.ITEMS.getKey((Object)s.m_41720_())) == null || !id.equals((Object)itemId)) continue;
            return i;
        }
        return -1;
    }

    private static void consumeFromSlot(Player player, int slot) {
        ItemStack stack = player.m_150109_().m_8020_(slot);
        stack.m_41774_(1);
        if (stack.m_41619_()) {
            player.m_150109_().m_6836_(slot, ItemStack.f_41583_);
        }
    }

    public static void damageOrConsumeHand(Player player, InteractionHand hand, ItemStack stack, Level level) {
        if (player.m_150110_().f_35937_) {
            return;
        }
        if (level.f_46443_) {
            return;
        }
        if (stack.m_41763_()) {
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
        } else {
            stack.m_41774_(1);
        }
    }

    public static void damageOrConsumeCurio(Player player, SlotResult res, Level level) {
        if (player.m_150110_().f_35937_) {
            return;
        }
        if (level.f_46443_) {
            return;
        }
        ICuriosHelper helper = CuriosApi.getCuriosHelper();
        ItemStack curioStack = res.stack();
        if (curioStack.m_41763_()) {
            curioStack.m_41622_(1, (LivingEntity)player, p -> helper.onBrokenCurio(res.slotContext()));
        } else {
            helper.getCuriosHandler((LivingEntity)player).ifPresent(handler -> handler.getStacksHandler(res.slotContext().identifier()).ifPresent(stacksHandler -> {
                int slot = res.slotContext().index();
                IDynamicStackHandler stacks = stacksHandler.getStacks();
                ItemStack inSlot = stacks.getStackInSlot(slot);
                if (!inSlot.m_41619_()) {
                    inSlot.m_41774_(1);
                    stacks.setStackInSlot(slot, inSlot);
                }
            }));
        }
    }

    public static void awardLightFurnace(Level level, BlockPos pos, Player player) {
        if (!(level instanceof ServerLevel) || !(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        BlockState after = level.m_8055_(pos);
        if (SmelterUtil.isIgnited(after)) {
            AdvancementHooks.awardAdvancement(sp, "light_furnace", "ignited");
        }
    }

    public static void awardFireAspect(Level level, BlockPos pos, Player player, ItemStack used) {
        if (!(level instanceof ServerLevel) || !(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        if (used.m_41619_() || !FireAspectUtil.hasFireAspect(used)) {
            return;
        }
        BlockState after = level.m_8055_(pos);
        if (SmelterUtil.isIgnited(after)) {
            AdvancementHooks.awardAdvancement(sp, "fire_aspect_ignition", "ignited");
        }
    }

    public static void awardRainIgnite(Level level, BlockPos pos, Player player) {
        if (!(level instanceof ServerLevel) || !(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        BlockState after = level.m_8055_(pos);
        if (!SmelterUtil.isIgnited(after)) {
            return;
        }
        if (!EnvironmentCheck.isPrecipitationAbove(level, pos)) {
            return;
        }
        if (!EnvironmentCheck.isHeatSourceBelow(level, pos)) {
            return;
        }
        AdvancementHooks.awardAdvancement(sp, "under_the_rain", "ignited");
    }

    @Nullable
    public static BooleanProperty findIgnitionProperty(@NotNull BlockState state) {
        if (state.m_61138_((Property)BlockStateProperties.f_61443_)) {
            return BlockStateProperties.f_61443_;
        }
        for (Property properties : state.m_61147_()) {
            if (!(properties instanceof BooleanProperty)) continue;
            BooleanProperty booleanProperty = (BooleanProperty)properties;
            String name = properties.m_61708_();
            if (!"purifying".equals(name) && !"active".equals(name) && !"lit".equals(name) && !"filtering".equals(name)) continue;
            return booleanProperty;
        }
        return null;
    }

    public static BlockState withIgnition(BlockState state, boolean value) {
        BooleanProperty prop = SmelterUtil.findIgnitionProperty(state);
        return prop != null ? (BlockState)state.m_61124_((Property)prop, (Comparable)Boolean.valueOf(value)) : state;
    }

    public static boolean isIgnited(BlockState state) {
        BooleanProperty prop = SmelterUtil.findIgnitionProperty(state);
        return prop != null && (Boolean)state.m_61143_((Property)prop) != false;
    }

    public static void setIgnition(Level level, BlockPos pos, BlockState state, boolean value) {
        level.m_7731_(pos, SmelterUtil.withIgnition(state, value), 3);
    }

    public static void light(Level level, BlockPos pos, BlockState state) {
        SmelterUtil.setIgnition(level, pos, state, true);
    }

    public static void extinguish(Level level, BlockPos pos, BlockState state) {
        SmelterUtil.setIgnition(level, pos, state, false);
    }

    public static void executeParticles(ServerLevel serverLevel, BlockPos pos) {
        double[][] lowerCornerPositions;
        RandomSource rand = serverLevel.m_213780_();
        for (double[] base : lowerCornerPositions = new double[][]{{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}, {(double)pos.m_123341_() + 1.0, pos.m_123342_(), pos.m_123343_()}, {pos.m_123341_(), pos.m_123342_(), (double)pos.m_123343_() + 1.0}, {(double)pos.m_123341_() + 1.0, pos.m_123342_(), (double)pos.m_123343_() + 1.0}}) {
            for (int j = 0; j < 4; ++j) {
                double x = base[0] + (rand.m_188500_() - 0.5) * 0.2;
                double y = base[1] + rand.m_188500_() * 0.5;
                double z = base[2] + (rand.m_188500_() - 0.5) * 0.2;
                SimpleParticleType type = switch (rand.m_188503_(4)) {
                    case 0 -> (SimpleParticleType)ModParticles.SIGN_FLAME_V1.get();
                    case 1 -> (SimpleParticleType)ModParticles.SIGN_FLAME_V2.get();
                    case 2 -> (SimpleParticleType)ModParticles.SIGN_FLAME_V3.get();
                    default -> (SimpleParticleType)ModParticles.SIGN_FLAME_V4.get();
                };
                serverLevel.m_8767_((ParticleOptions)type, x, y, z, 1, 0.0, 0.02, 0.0, 0.02);
            }
        }
    }
}

