/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.lititup.event.animation;

import com.eruannie_9.lititup.ModClientConfiguration;
import com.eruannie_9.lititup.mixin.animation.ItemInHandRendererInvoker;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="lititup", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class FPStrikeAnimation {
    private static int ticksLeft = 0;
    private static boolean impactFired = false;
    private static boolean successFlag = false;
    private static boolean inReentry = false;
    private static final int DURATION_TICKS = 9;
    private static final float WINDUP_T = 0.35f;
    private static final float STRIKE_T = 0.62f;
    private static final float IMPACT_HOLD_T = 0.68f;
    private static final float RECOIL_T = 0.84f;
    private static final float VANILLA_ITEM_POS_X = 0.56f;
    private static final float IMPACT_GAP_X = 0.01f;
    private static final float START_EXTRA_X = 0.12f;
    private static final float LIFT_Y = 0.16f;
    private static final float PUSH_Z = -0.06f;
    private static final float RECOIL_X = 0.05f;
    private static final float RECOIL_Y = 0.0f;
    private static final float RECOIL_Z = 0.015f;
    private static final float YAW_TO_CENTER_DEG = 16.0f;
    private static final float PITCH_EDGE_DEG = 12.0f;
    private static final float ROLL_EDGE_DEG = 10.0f;
    private static final float CROSS_Y = 0.008f;
    private static final float CROSS_Z = 0.008f;

    public static void startDualFlintStrike(boolean success) {
        ticksLeft = 9;
        impactFired = false;
        successFlag = success;
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.END && ticksLeft > 0) {
            --ticksLeft;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onRenderHand(RenderHandEvent event) {
        if (inReentry) {
            return;
        }
        if (ticksLeft <= 0) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        LocalPlayer player = mc.f_91074_;
        if (level == null || player == null) {
            return;
        }
        if (!player.m_21205_().m_150930_(Items.f_42484_) || !player.m_21206_().m_150930_(Items.f_42484_)) {
            return;
        }
        float t = 1.0f - ((float)ticksLeft - event.getPartialTick()) / 9.0f;
        t = Mth.m_14036_((float)t, (float)0.0f, (float)1.0f);
        boolean visualRight = event.getHand() == InteractionHand.MAIN_HAND == (player.m_5737_() == HumanoidArm.RIGHT);
        Pose pose = FPStrikeAnimation.computePose(visualRight, t);
        if (!impactFired && t >= 0.62f) {
            impactFired = true;
            FPStrikeAnimation.spawnImpactVFX(mc, event.getPartialTick(), successFlag);
        }
        event.setCanceled(true);
        PoseStack poseStack = event.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_252880_(pose.x, pose.y, pose.z);
        if (pose.yaw != 0.0f) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(pose.yaw));
        }
        if (pose.pitch != 0.0f) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(pose.pitch));
        }
        if (pose.roll != 0.0f) {
            poseStack.m_252781_(Axis.f_252403_.m_252977_(pose.roll));
        }
        try {
            inReentry = true;
            ItemInHandRenderer renderer = mc.f_91063_.f_109055_;
            ((ItemInHandRendererInvoker)renderer).animationRenderer((AbstractClientPlayer)player, event.getPartialTick(), event.getInterpolatedPitch(), event.getHand(), 0.0f, event.getItemStack(), 0.0f, poseStack, event.getMultiBufferSource(), event.getPackedLight());
        }
        finally {
            inReentry = false;
            poseStack.m_85849_();
        }
    }

    private static Pose computePose(boolean visualRight, float t) {
        float side = visualRight ? 1.0f : -1.0f;
        float dir = -side;
        float upS = visualRight ? -1.0f : 1.0f;
        float xImpact = dir * 0.56f + side * 0.005f;
        float yImpact = 0.16f;
        float zImpact = -0.06f;
        float xOut = xImpact + dir * 0.12f;
        if (t <= 0.35f) {
            float w = FPStrikeAnimation.easeOutCubic(t / 0.35f);
            float x = Mth.m_14179_((float)w, (float)0.0f, (float)xOut);
            float y = Mth.m_14179_((float)w, (float)0.0f, (float)(yImpact * 0.6f)) * (1.0f + 0.05f * upS);
            float z = Mth.m_14179_((float)w, (float)0.0f, (float)(zImpact * 0.6f));
            return new Pose(x, y, z, 0.0f, 0.0f, 0.0f);
        }
        if (t <= 0.62f) {
            float u = (t - 0.35f) / 0.27f;
            float w = FPStrikeAnimation.easeInQuint(u);
            float x = Mth.m_14179_((float)w, (float)xOut, (float)xImpact);
            float y = Mth.m_14179_((float)w, (float)(yImpact * 0.6f), (float)yImpact);
            float z = Mth.m_14179_((float)w, (float)(zImpact * 0.6f), (float)zImpact);
            float yaw = dir * 16.0f * w;
            float pitch = (visualRight ? 1.0f : -1.0f) * 12.0f * w;
            float cw = w;
            float yCross = 0.008f * (visualRight ? -1.0f : 1.0f) * cw;
            float zCross = 0.008f * (visualRight ? -1.0f : 1.0f) * cw;
            float roll = (visualRight ? -1.0f : 1.0f) * 10.0f * cw;
            return new Pose(x, y + yCross, z + zCross, yaw, pitch, roll);
        }
        if (t <= 0.68f) {
            float u = (t - 0.62f) / 0.060000002f;
            float bump = FPStrikeAnimation.bump01(u);
            float x = xImpact;
            float y = yImpact + 0.008f * (visualRight ? -1.0f : 1.0f);
            float z = zImpact + 0.008f * (visualRight ? -1.0f : 1.0f);
            float yaw = dir * 16.0f;
            float pitch = (visualRight ? 1.0f : -1.0f) * 12.0f;
            float roll = (visualRight ? -1.0f : 1.0f) * (10.0f * (0.85f + 0.15f * bump));
            return new Pose(x, y, z, yaw, pitch, roll);
        }
        if (t <= 0.84f) {
            float u = (t - 0.68f) / 0.15999997f;
            float w = FPStrikeAnimation.easeOutCubic(u);
            float x = Mth.m_14179_((float)w, (float)xImpact, (float)(xImpact + dir * 0.05f));
            float y = Mth.m_14179_((float)w, (float)(yImpact + 0.008f * (visualRight ? -1.0f : 1.0f)), (float)(yImpact + 0.0f));
            float z = Mth.m_14179_((float)w, (float)(zImpact + 0.008f * (visualRight ? -1.0f : 1.0f)), (float)(zImpact + 0.015f));
            float yaw = dir * 16.0f * (1.0f - w);
            float pitch = (visualRight ? 1.0f : -1.0f) * 12.0f * (1.0f - w);
            float roll = (visualRight ? -1.0f : 1.0f) * 10.0f * (1.0f - w);
            return new Pose(x, y, z, yaw, pitch, roll);
        }
        float u = (t - 0.84f) / 0.16000003f;
        float w = FPStrikeAnimation.easeOutCubic(u);
        float x = Mth.m_14179_((float)w, (float)(xImpact + dir * 0.05f), (float)0.0f);
        float y = Mth.m_14179_((float)w, (float)(yImpact + 0.0f), (float)0.0f);
        float z = Mth.m_14179_((float)w, (float)(zImpact + 0.015f), (float)0.0f);
        return new Pose(x, y, z, 0.0f, 0.0f, 0.0f);
    }

    private static void spawnImpactVFX(Minecraft mc, float partialTick, boolean success) {
        ClientLevel level = mc.f_91073_;
        LocalPlayer player = mc.f_91074_;
        if (level == null || player == null) {
            return;
        }
        Vec3 eye = player.m_20299_(partialTick);
        Vec3 look = player.m_20252_(partialTick).m_82541_();
        Vec3 p = eye.m_82549_(look.m_82490_(0.58)).m_82520_(0.0, 0.15199999660253524, 0.0).m_82520_(0.0, 0.0, -0.0479999989271164);
        Vec3 worldUp = new Vec3(0.0, 1.0, 0.0);
        Vec3 sideVec = look.m_82537_(worldUp);
        if (sideVec.m_82556_() < 1.0E-4) {
            sideVec = new Vec3(1.0, 0.0, 0.0);
        }
        boolean rightHanded = player.m_5737_() == HumanoidArm.RIGHT;
        sideVec = sideVec.m_82541_().m_82490_(rightHanded ? 1.0 : -1.0);
        if (success) {
            if (((Boolean)ModClientConfiguration.FLINT_IGNITION_FLASH.get()).booleanValue()) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123747_, p.f_82479_, p.f_82480_, p.f_82481_, 0.0, 0.0, 0.0);
            }
            int fireCount = 2 + level.f_46441_.m_188503_(2);
            double flameY = p.f_82480_ - 0.035;
            for (int i = 0; i < fireCount; ++i) {
                double ex = (level.f_46441_.m_188500_() - 0.5) * 0.01;
                double ez = (level.f_46441_.m_188500_() - 0.5) * 0.01;
                double ey = 0.018 + (double)i * 0.004;
                level.m_7106_((ParticleOptions)ParticleTypes.f_175834_, p.f_82479_, flameY, p.f_82481_, ex, ey, ez);
            }
        } else {
            int sparkCount = 6 + level.f_46441_.m_188503_(4);
            for (int i = 0; i < sparkCount; ++i) {
                Vec3 axis = sideVec.m_82490_(0.85 + level.f_46441_.m_188500_() * 0.35).m_82549_(look.m_82490_(0.25 + level.f_46441_.m_188500_() * 0.2)).m_82520_(0.0, 0.05 + level.f_46441_.m_188500_() * 0.04, 0.0).m_82541_();
                if (level.f_46441_.m_188500_() < 0.3) {
                    axis = axis.m_82490_(-1.0);
                }
                Vec3 dir = FPStrikeAnimation.randomDirInCone(level.f_46441_, axis, Math.toRadians(55.0));
                double speed = 0.1 + level.f_46441_.m_188500_() * 0.12;
                Vec3 v = dir.m_82490_(speed);
                level.m_7106_((ParticleOptions)ParticleTypes.f_175830_, p.f_82479_, p.f_82480_, p.f_82481_, v.f_82479_, v.f_82480_, v.f_82481_);
            }
            level.m_7785_(p.f_82479_, p.f_82480_, p.f_82481_, SoundEvents.f_11942_, SoundSource.PLAYERS, 0.32f, 2.0f, false);
        }
    }

    private static Vec3 randomDirInCone(RandomSource random, Vec3 axis, double coneHalfAngleRad) {
        Vec3 a = axis.m_82541_();
        Vec3 ortho = Math.abs(a.f_82479_) < 0.9 ? new Vec3(1.0, 0.0, 0.0) : new Vec3(0.0, 1.0, 0.0);
        Vec3 tangent = a.m_82537_(ortho).m_82541_();
        Vec3 bitangent = a.m_82537_(tangent).m_82541_();
        double cosMax = Math.cos(coneHalfAngleRad);
        double cosTheta = cosMax + random.m_188500_() * (1.0 - cosMax);
        double sinTheta = Math.sqrt(Math.max(0.0, 1.0 - cosTheta * cosTheta));
        double phi = random.m_188500_() * (Math.PI * 2);
        return tangent.m_82490_(Math.cos(phi) * sinTheta).m_82549_(bitangent.m_82490_(Math.sin(phi) * sinTheta)).m_82549_(a.m_82490_(cosTheta)).m_82541_();
    }

    private static float easeOutCubic(float x) {
        float inv = 1.0f - x;
        return 1.0f - inv * inv * inv;
    }

    private static float easeInQuint(float x) {
        return x * x * x * x * x;
    }

    private static float bump01(float u) {
        u = Mth.m_14036_((float)u, (float)0.0f, (float)1.0f);
        float s = u * u * (3.0f - 2.0f * u);
        return 4.0f * s * (1.0f - s);
    }

    private record Pose(float x, float y, float z, float yaw, float pitch, float roll) {
    }
}

