/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.lititup.mixin.compatibility;

import com.eruannie_9.lititup.ModConfiguration;
import com.eruannie_9.lititup.util.interfaces.IIgnited;
import com.sihenzhang.crockpot.block.entity.CrockPotBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CrockPotBlockEntity.class})
public abstract class CrockPotManagerMixin
implements IIgnited {
    @Unique
    private boolean ignited = false;

    @Override
    public void setIgnitedByPlayer(boolean ignited) {
        this.ignited = ignited;
    }

    @Override
    public boolean isIgnitedByPlayer() {
        return this.ignited;
    }

    @Inject(method={"load"}, at={@At(value="TAIL")})
    private void onLoad(CompoundTag tag, CallbackInfo ci) {
        if (tag.m_128441_("Ignited")) {
            this.ignited = tag.m_128471_("Ignited");
        }
    }

    @Inject(method={"saveAdditional"}, at={@At(value="TAIL")})
    private void onSave(CompoundTag tag, CallbackInfo ci) {
        tag.m_128379_("Ignited", this.ignited);
    }

    @Inject(method={"serverTick"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void onServerTickHead(Level level, BlockPos pos, BlockState state, CrockPotBlockEntity blockEntity, CallbackInfo ci) {
        if (!((Boolean)ModConfiguration.CROCK_POT.get()).booleanValue()) {
            return;
        }
        if (!((IIgnited)blockEntity).isIgnitedByPlayer()) {
            ci.cancel();
        }
    }

    @Inject(method={"serverTick"}, at={@At(value="TAIL")}, remap=false)
    private static void onServerTickTail(Level level, BlockPos pos, BlockState state, CrockPotBlockEntity blockEntity, CallbackInfo ci) {
        if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            ((IIgnited)blockEntity).setIgnitedByPlayer(false);
        }
    }
}

