/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.lititup.mixin.compatibility;

import com.eruannie_9.lititup.Item.ModItems;
import com.eruannie_9.lititup.ModConfiguration;
import com.eruannie_9.lititup.block.ModBlocks;
import com.eruannie_9.lititup.util.FireAspectUtil;
import com.eruannie_9.lititup.util.SmelterUtil;
import com.eruannie_9.lititup.util.curio.CurioUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.stirdrem.overgeared.block.custom.AlloySmelterBlock;
import net.stirdrem.overgeared.block.entity.AlloySmelterBlockEntity;
import net.stirdrem.overgeared.recipe.AlloySmeltingRecipe;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AlloySmelterBlock.class})
public abstract class OverAlloyBrickExecutorMixin {
    private boolean canIgniteAlloy(AlloySmelterBlockEntity be, Level level) {
        ItemStack fuel = be.m_8020_(4);
        boolean hasFuel = ForgeHooks.getBurnTime((ItemStack)fuel, (RecipeType)RecipeType.f_44108_) > 0;
        SimpleContainer inv = new SimpleContainer(4);
        for (int i = 0; i < 4; ++i) {
            inv.m_6836_(i, be.m_8020_(i));
        }
        Optional opt = level.m_7465_().m_44015_((RecipeType)AlloySmeltingRecipe.Type.INSTANCE, (Container)inv, level);
        boolean recipeMatchesOutput = opt.map(recipe -> {
            RegistryAccess regs = level.m_9598_();
            ItemStack result = recipe.m_8043_(regs);
            ItemStack output = be.m_8020_(5);
            return !result.m_41619_() && (output.m_41619_() || output.m_150930_(result.m_41720_()) && output.m_41613_() + result.m_41613_() <= output.m_41741_());
        }).orElse(false);
        return hasFuel && recipeMatchesOutput;
    }

    private boolean isIgnitionItem(Item item) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item);
        return id != null && ((List)ModConfiguration.FURNACE_EXECUTOR_ITEM_LIST.get()).contains(id.toString());
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    private void onUse(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, CallbackInfoReturnable<InteractionResult> cir) {
        if (!((Boolean)ModConfiguration.MAIN.get()).booleanValue() || level.f_46443_) {
            return;
        }
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof AlloySmelterBlockEntity)) {
            return;
        }
        AlloySmelterBlockEntity smelter = (AlloySmelterBlockEntity)be;
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            return;
        }
        if (!this.canIgniteAlloy(smelter, level)) {
            return;
        }
        if (CurioUtil.isCuriosLoaded() && CurioUtil.hasGoldenLighter(player)) {
            SmelterUtil.igniteWithCuriosSlot(level, pos, state, (BlockEntity)smelter, player, cir);
            return;
        }
        if (((Boolean)ModConfiguration.DOUBLE_FLINT_IGNITION.get()).booleanValue() && OverAlloyBrickExecutorMixin.hasFlintInBothHands(player)) {
            boolean hasSwitchgrassFuel;
            ItemStack fuel = smelter.m_8020_(4);
            boolean bl = hasSwitchgrassFuel = fuel.m_150930_((Item)ModItems.SWITCHGRASS_FIBER.get()) || fuel.m_150930_(((Block)ModBlocks.BALED_SWITCHGRASS.get()).m_5456_());
            if (hasSwitchgrassFuel) {
                if (!player.m_36335_().m_41519_(Items.f_42484_)) {
                    SmelterUtil.tryIgniteWithFlints(level, pos, state, be, player, cir);
                } else {
                    cir.setReturnValue((Object)InteractionResult.CONSUME);
                    cir.cancel();
                }
                return;
            }
        }
        ItemStack inHand = player.m_21120_(hand);
        Item item = inHand.m_41720_();
        boolean fireAspect = FireAspectUtil.hasFireAspect(inHand);
        if (player.m_36335_().m_41519_(item) || !this.isIgnitionItem(item) && !fireAspect) {
            return;
        }
        if (inHand.m_41763_()) {
            SmelterUtil.tryIgnite(level, pos, state, (BlockEntity)smelter, player, item, inHand, hand, cir);
        } else {
            SmelterUtil.tryShrinkAndIgnite(level, pos, state, (BlockEntity)smelter, player, item, inHand, hand, cir);
        }
    }

    private static boolean hasFlintInBothHands(Player player) {
        return player.m_21205_().m_150930_(Items.f_42484_) && player.m_21206_().m_150930_(Items.f_42484_);
    }
}

