/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.lititup.mixin.compatibility;

import com.eruannie_9.lititup.ModConfiguration;
import com.eruannie_9.lititup.util.EnvironmentCheck;
import com.eruannie_9.lititup.util.interfaces.IIgnited;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.stirdrem.overgeared.block.entity.AlloySmelterBlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AlloySmelterBlockEntity.class})
public abstract class OverAlloyBrickManagerMixin
implements IIgnited {
    @Unique
    private boolean ignited = false;
    @Shadow
    private int burnTime;

    @Override
    public void setIgnitedByPlayer(boolean ignited) {
        this.ignited = ignited;
    }

    @Override
    public boolean isIgnitedByPlayer() {
        return this.ignited;
    }

    @Inject(method={"load"}, at={@At(value="TAIL")})
    public void onLoad(CompoundTag tag, CallbackInfo ci) {
        this.ignited = tag.m_128471_("Ignited");
    }

    @Inject(method={"saveAdditional"}, at={@At(value="TAIL")})
    public void onSave(CompoundTag tag, CallbackInfo ci) {
        tag.m_128379_("Ignited", this.ignited);
    }

    @Inject(method={"canSmelt"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void onCanSmelt(CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)ModConfiguration.OVER_ALLOY.get()).booleanValue()) {
            return;
        }
        if (this.burnTime > 0) {
            return;
        }
        AlloySmelterBlockEntity self = (AlloySmelterBlockEntity)this;
        Level level = self.m_58904_();
        if (level == null) {
            return;
        }
        BlockPos pos = self.m_58899_();
        boolean hasHeatBelow = EnvironmentCheck.isHeatSourceBelow(level, pos);
        boolean rainAbove = EnvironmentCheck.isPrecipitationAbove(level, pos);
        if (!(this.isIgnitedByPlayer() || hasHeatBelow && !rainAbove && ((Boolean)ModConfiguration.HOT_BLOCK_IGNITION.get()).booleanValue())) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")}, remap=false)
    private static void onTick(Level level, BlockPos pos, BlockState state, AlloySmelterBlockEntity be, CallbackInfo ci) {
        if (((Boolean)ModConfiguration.OVER_ALLOY.get()).booleanValue() && !((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            ((IIgnited)be).setIgnitedByPlayer(false);
        }
    }
}

