/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.lititup.mixin;

import com.eruannie_9.lititup.ModConfiguration;
import com.eruannie_9.lititup.mixin.compatibility.accessors.MainAccessor;
import com.eruannie_9.lititup.util.FireAspectUtil;
import com.eruannie_9.lititup.util.SmelterUtil;
import com.eruannie_9.lititup.util.aether.AetherCompatibilityUtils;
import com.eruannie_9.lititup.util.curio.CurioUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractFurnaceBlock.class})
public abstract class MainSmelterExecutorMixin {
    private boolean canIgniteFurnace(AbstractFurnaceBlockEntity furnace, BlockState state, Level level) {
        ItemStack fuelStack = furnace.m_8020_(1);
        boolean hasFuel = AetherCompatibilityUtils.isAetherFreezerBlock(state) ? !fuelStack.m_41619_() : AbstractFurnaceBlockEntity.m_58399_((ItemStack)fuelStack);
        Optional recipeOpt = ((MainAccessor)furnace).getQuickCheck().m_213657_((Container)furnace, level);
        boolean recipeMatchesOutput = recipeOpt.map(recipe -> {
            RegistryAccess regs = level.m_9598_();
            ItemStack result = recipe.m_8043_(regs);
            ItemStack currentOut = furnace.m_8020_(2);
            return currentOut.m_41619_() || currentOut.m_41720_() == result.m_41720_();
        }).orElse(false);
        return hasFuel && recipeMatchesOutput;
    }

    private boolean isIgnitionItem(Item item) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item);
        return id != null && ((List)ModConfiguration.FURNACE_EXECUTOR_ITEM_LIST.get()).contains(id.toString());
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    public void onUse(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, CallbackInfoReturnable<InteractionResult> cir) {
        AbstractFurnaceBlockEntity furnace;
        BlockEntity be;
        block10: {
            block9: {
                if (!((Boolean)ModConfiguration.MAIN.get()).booleanValue() || level.f_46443_) {
                    return;
                }
                be = level.m_7702_(pos);
                if (!(be instanceof AbstractFurnaceBlockEntity)) break block9;
                furnace = (AbstractFurnaceBlockEntity)be;
                if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) break block10;
            }
            return;
        }
        if (!this.canIgniteFurnace(furnace, state, level)) {
            return;
        }
        if (CurioUtil.isCuriosLoaded() && CurioUtil.hasGoldenLighter(player)) {
            SmelterUtil.igniteWithCuriosSlot(level, pos, state, (BlockEntity)furnace, player, cir);
            return;
        }
        ItemStack stackInHand = player.m_21120_(hand);
        Item item = stackInHand.m_41720_();
        boolean fireAspect = FireAspectUtil.hasFireAspect(stackInHand);
        if (player.m_36335_().m_41519_(item) || !this.isIgnitionItem(item) && !fireAspect) {
            return;
        }
        if (stackInHand.m_41763_()) {
            SmelterUtil.tryIgnite(level, pos, state, be, player, item, stackInHand, hand, cir);
        } else {
            SmelterUtil.tryShrinkAndIgnite(level, pos, state, be, player, item, stackInHand, hand, cir);
        }
    }
}

