/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.lititup.mixin;

import com.eruannie_9.lititup.ModConfiguration;
import com.eruannie_9.lititup.util.EnvironmentCheck;
import com.eruannie_9.lititup.util.interfaces.IIgnited;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractFurnaceBlockEntity.class})
public abstract class MainSmelterManagerMixin
implements IIgnited {
    @Unique
    private boolean ignited = false;
    @Shadow
    private int f_58316_;

    @Override
    public void setIgnitedByPlayer(boolean ignited) {
        this.ignited = ignited;
    }

    @Override
    public boolean isIgnitedByPlayer() {
        return this.ignited;
    }

    @Inject(method={"load"}, at={@At(value="TAIL")})
    public void onLoad(CompoundTag tag, CallbackInfo ci) {
        this.ignited = tag.m_128471_("Ignited");
    }

    @Inject(method={"saveAdditional"}, at={@At(value="TAIL")})
    public void onSave(CompoundTag tag, CallbackInfo ci) {
        tag.m_128379_("Ignited", this.ignited);
    }

    @Inject(method={"canBurn"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCanBurn(CallbackInfoReturnable<Boolean> cir) {
        boolean isActive;
        if (!((Boolean)ModConfiguration.MAIN.get()).booleanValue()) {
            return;
        }
        boolean bl = isActive = this.f_58316_ > 0;
        if (isActive) {
            return;
        }
        AbstractFurnaceBlockEntity furnace = (AbstractFurnaceBlockEntity)this;
        Level world = furnace.m_58904_();
        BlockPos pos = furnace.m_58899_();
        boolean hasLavaOrFireBelow = EnvironmentCheck.isHeatSourceBelow(world, pos);
        boolean isRainingAbove = EnvironmentCheck.isPrecipitationAbove(world, pos);
        if (!(this.isIgnitedByPlayer() || hasLavaOrFireBelow && !isRainingAbove && ((Boolean)ModConfiguration.HOT_BLOCK_IGNITION.get()).booleanValue())) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"serverTick"}, at={@At(value="TAIL")})
    private static void onServerTick(Level level, BlockPos pos, BlockState state, AbstractFurnaceBlockEntity entity, CallbackInfo ci) {
        if (((Boolean)ModConfiguration.MAIN.get()).booleanValue() && !((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            ((IIgnited)entity).setIgnitedByPlayer(false);
        }
    }
}

