/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.lititup.mixin;

import com.eruannie_9.lititup.LitItUp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinLoadCondition
implements IMixinConfigPlugin {
    private static final Logger LOGGER = LogManager.getLogger(LitItUp.class);
    private static final Map<String, String> MIXIN_MOD_MAP = new HashMap<String, String>();
    private static final Set<String> LOGGED_MODS = new HashSet<String>();

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return "lititup.mixins-refmap.json";
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        String className = mixinClassName.substring(mixinClassName.lastIndexOf(46) + 1);
        String modName = MIXIN_MOD_MAP.get(className);
        if (modName == null) {
            return true;
        }
        boolean shouldApply = MixinLoadCondition.isLoaded(modName);
        if (shouldApply) {
            this.logModStatus(modName);
        }
        return shouldApply;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public static boolean isLoaded(String modid) {
        return FMLLoader.getLoadingModList().getModFileById(modid) != null;
    }

    private void logModStatus(String modName) {
        if (!LOGGED_MODS.contains(modName)) {
            String capitalizedModName = this.capitalizeLetter(modName);
            LOGGER.info(capitalizedModName + " compatibility loaded");
            LOGGED_MODS.add(modName);
        }
    }

    private String capitalizeLetter(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }

    static {
        MIXIN_MOD_MAP.put("ToughPurifierManagerMixin", "toughasnails");
        MIXIN_MOD_MAP.put("ToughPurifierExecutorMixin", "toughasnails");
    }
}

