/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.lititup.event;

import com.eruannie_9.lititup.Item.ModItems;
import com.eruannie_9.lititup.ModConfiguration;
import com.eruannie_9.lititup.util.FireAspectUtil;
import com.eruannie_9.lititup.util.ShrinkItemDefinition;
import com.eruannie_9.lititup.util.SmelterUtil;
import com.eruannie_9.lititup.util.curio.CurioUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber
public class StoveExecutionEvent {
    private static final String CANDLELIGHT_MOD_ID = "candlelight";
    private static final String FARMERSDELIGHT_MOD_ID = "farmersdelight";
    private static final String CANDLELIGHT_STOVE_CLASS = "satisfyu.candlelight.block.StoveBlock";
    private static final String FARMERSDELIGHT_STOVE_CLASS = "vectorwing.farmersdelight.common.block.StoveBlock";

    private static boolean isCandlelightLoaded() {
        return ModList.get().isLoaded(CANDLELIGHT_MOD_ID);
    }

    private static boolean isFarmersDelightLoaded() {
        return ModList.get().isLoaded(FARMERSDELIGHT_MOD_ID);
    }

    private static boolean isCandlelightStove(Block block) {
        return StoveExecutionEvent.isCandlelightLoaded() && block.getClass().getName().equals(CANDLELIGHT_STOVE_CLASS);
    }

    private static boolean isFarmersDelightStove(Block block) {
        return StoveExecutionEvent.isFarmersDelightLoaded() && block.getClass().getName().equals(FARMERSDELIGHT_STOVE_CLASS);
    }

    private static boolean isIgnitionItem(Item item) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item);
        return id != null && ((List)ModConfiguration.FURNACE_EXECUTOR_ITEM_LIST.get()).contains(id.toString());
    }

    private static void ignite(Level level, BlockPos pos, BlockState state, Player player, ItemStack used, boolean checkFireAspect) {
        SmelterUtil.light(level, pos, state);
        level.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (level instanceof ServerLevel) {
            ServerLevel srv = (ServerLevel)level;
            SmelterUtil.executeParticles(srv, pos);
            SmelterUtil.awardLightFurnace(level, pos, player);
            if (checkFireAspect) {
                SmelterUtil.awardFireAspect(level, pos, player, used);
            }
            SmelterUtil.awardRainIgnite(level, pos, player);
        }
    }

    private static void damageCurioLighter(Player player) {
        if (!CurioUtil.isCuriosLoaded()) {
            return;
        }
        CuriosApi.getCuriosHelper().findCurios((LivingEntity)player, new String[]{"lighter"}).stream().filter(r -> r.stack().m_150930_((Item)ModItems.GOLDEN_LIGHTER.get())).findFirst().ifPresent(res -> {
            ItemStack stack = res.stack();
            if (stack.m_41763_()) {
                stack.m_41622_(1, (LivingEntity)player, p -> CuriosApi.getCuriosHelper().onBrokenCurio(res.slotContext()));
            } else if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
        });
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        Level level = player.m_9236_();
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        InteractionHand hand = event.getHand();
        ItemStack itemStack = event.getItemStack();
        Item item = itemStack.m_41720_();
        Block block = state.m_60734_();
        boolean candlelight = StoveExecutionEvent.isCandlelightStove(block);
        boolean farmersDelight = StoveExecutionEvent.isFarmersDelightStove(block);
        if (!candlelight && !farmersDelight || SmelterUtil.isIgnited(state)) {
            return;
        }
        if (CurioUtil.isCuriosLoaded() && CurioUtil.hasGoldenLighter(player)) {
            StoveExecutionEvent.damageCurioLighter(player);
            StoveExecutionEvent.ignite(level, pos, state, player, ItemStack.f_41583_, false);
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.m_19078_((boolean)level.f_46443_));
            return;
        }
        if (farmersDelight && item == Items.f_42409_) {
            StoveExecutionEvent.ignite(level, pos, state, player, itemStack, false);
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            }
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.m_19078_((boolean)level.f_46443_));
            return;
        }
        boolean fireAspect = FireAspectUtil.hasFireAspect(itemStack);
        if (!StoveExecutionEvent.isIgnitionItem(item) && !fireAspect) {
            return;
        }
        if (player.m_36335_().m_41519_(item)) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.PASS);
            return;
        }
        if (item == ModItems.SPARKLING_FLINT.get()) {
            StoveExecutionEvent.handleSparklingFlint(event, level, pos, state, player, itemStack, hand);
            return;
        }
        StoveExecutionEvent.ignite(level, pos, state, player, itemStack, true);
        if (!player.m_150110_().f_35937_) {
            if (itemStack.m_41763_()) {
                itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            } else {
                itemStack.m_41774_(1);
            }
        }
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.m_19078_((boolean)level.f_46443_));
    }

    private static void handleSparklingFlint(PlayerInteractEvent.RightClickBlock event, Level level, BlockPos pos, BlockState state, Player player, ItemStack itemStack, InteractionHand hand) {
        if (ShrinkItemDefinition.hasShrinkItem(player)) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.PASS);
            return;
        }
        StoveExecutionEvent.ignite(level, pos, state, player, itemStack, false);
        itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
        ShrinkItemDefinition.shrinkItem(player);
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.SUCCESS);
    }
}

