/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.lititup.mixin.compatibility;

import com.eruannie_9.lititup.ModConfiguration;
import com.eruannie_9.lititup.mixin.compatibility.accessors.Mk2Accessor;
import com.eruannie_9.lititup.util.FireAspectUtil;
import com.eruannie_9.lititup.util.SmelterUtil;
import com.eruannie_9.lititup.util.curio.CurioUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vapourdrive.furnacemk2.furnace.FurnaceMk2Block;
import vapourdrive.furnacemk2.furnace.FurnaceMk2Tile;
import vapourdrive.furnacemk2.utils.FurnaceUtils;

@Mixin(value={FurnaceMk2Block.class})
public class SmelterMK2ExecutorMixin {
    private boolean canIgniteFurnace(FurnaceMk2Tile furnace, Level level) {
        int storedFuel = furnace.getFurnaceData().fuel;
        boolean hasFuel = storedFuel >= 20000;
        Mk2Accessor accessor = (Mk2Accessor)furnace;
        ItemStack inputStack = accessor.getIngredientHandler().getStackInSlot(FurnaceMk2Tile.INPUT_SLOT[0]);
        boolean hasRecipe = FurnaceUtils.canSmelt((ItemStack)inputStack, (Level)level);
        boolean recipeMatchesOutput = false;
        if (hasRecipe) {
            ItemStack output = FurnaceUtils.getSmeltingResultForItem((Level)level, (ItemStack)inputStack);
            for (int slot : FurnaceMk2Tile.OUTPUT_SLOTS) {
                ItemStack current = accessor.getOutputHandler().getStackInSlot(slot);
                if (!current.m_41619_() && current.m_41720_() != output.m_41720_()) continue;
                recipeMatchesOutput = true;
                break;
            }
        }
        return hasFuel && recipeMatchesOutput;
    }

    private boolean isIgnitionItem(Item item) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item);
        return id != null && ((List)ModConfiguration.FURNACE_EXECUTOR_ITEM_LIST.get()).contains(id.toString());
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    public void onUse(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, CallbackInfoReturnable<InteractionResult> cir) {
        FurnaceMk2Tile furnace;
        BlockEntity be;
        block10: {
            block9: {
                if (!((Boolean)ModConfiguration.MK2_FURNACE.get()).booleanValue() || level.f_46443_) {
                    return;
                }
                be = level.m_7702_(pos);
                if (!(be instanceof FurnaceMk2Tile)) break block9;
                furnace = (FurnaceMk2Tile)be;
                if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) break block10;
            }
            return;
        }
        if (!this.canIgniteFurnace(furnace, level)) {
            return;
        }
        if (CurioUtil.isCuriosLoaded() && CurioUtil.hasGoldenLighter(player)) {
            SmelterUtil.igniteWithCuriosSlot(level, pos, state, (BlockEntity)furnace, player, cir);
            return;
        }
        ItemStack stackInHand = player.m_21120_(hand);
        Item item = stackInHand.m_41720_();
        boolean fireAspect = FireAspectUtil.hasFireAspect(stackInHand);
        if (player.m_36335_().m_41519_(item) || !this.isIgnitionItem(item) && !fireAspect) {
            return;
        }
        if (stackInHand.m_41763_()) {
            SmelterUtil.tryIgnite(level, pos, state, be, player, item, stackInHand, hand, cir);
        } else {
            SmelterUtil.tryShrinkAndIgnite(level, pos, state, be, player, item, stackInHand, hand, cir);
        }
    }
}

