/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.lititup.util;

import com.eruannie_9.lititup.ModConfiguration;
import com.eruannie_9.lititup.util.SmelterUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class EnvironmentCheck {
    public static boolean isHeatSourceBelow(Level world, BlockPos pos) {
        if (world == null || pos == null) {
            return false;
        }
        BlockPos posBelow = pos.m_7495_();
        BlockState stateBelow = world.m_8055_(posBelow);
        for (String entry : (List)ModConfiguration.FURNACE_EXECUTOR_BLOCK_LIST.get()) {
            if (!EnvironmentCheck.matchesConfiguredBlock(entry, stateBelow)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrecipitationAbove(Level world, BlockPos pos) {
        if (world == null || pos == null) {
            return false;
        }
        if (!world.m_46471_()) {
            return false;
        }
        BlockPos posAbove = pos.m_7494_();
        if (!world.m_45527_(posAbove)) {
            return false;
        }
        Holder biomeHolder = world.m_204166_(posAbove);
        Biome biome = (Biome)biomeHolder.m_203334_();
        return biome.m_47530_() != Biome.Precipitation.NONE;
    }

    private static boolean matchesConfiguredBlock(String configEntry, BlockState state) {
        String[] parts = configEntry.split(":");
        if (parts.length < 2) {
            return false;
        }
        String namespace = parts[0];
        String path = parts[1];
        ResourceLocation blockId = new ResourceLocation(namespace, path);
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(blockId);
        if (block == null) {
            return false;
        }
        if (!state.m_60713_(block)) {
            return false;
        }
        if (parts.length == 3) {
            boolean desiredLit = Boolean.parseBoolean(parts[2]);
            Boolean currentLit = EnvironmentCheck.getIgnitionValueIfExists(state);
            if (currentLit == null) {
                return true;
            }
            return currentLit == desiredLit;
        }
        return true;
    }

    @Nullable
    private static Boolean getIgnitionValueIfExists(BlockState state) {
        BooleanProperty prop = SmelterUtil.findIgnitionProperty(state);
        return prop != null ? (Boolean)state.m_61143_((Property)prop) : null;
    }
}

