/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.lititup.util;

import com.eruannie_9.lititup.Item.ModItems;
import com.eruannie_9.lititup.advancements.AdvancementHooks;
import com.eruannie_9.lititup.particles.ModParticles;
import com.eruannie_9.lititup.util.EnvironmentCheck;
import com.eruannie_9.lititup.util.FireAspectUtil;
import com.eruannie_9.lititup.util.WeakLighterUtil;
import com.eruannie_9.lititup.util.interfaces.IIgnited;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import top.theillusivec4.curios.api.CuriosApi;

public final class SmelterUtil {
    public static void igniteWithCuriosSlot(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity, Player player, CallbackInfoReturnable<InteractionResult> cir) {
        ((IIgnited)blockEntity).setIgnitedByPlayer(true);
        SmelterUtil.light(level, pos, state);
        level.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, 1.0f);
        CuriosApi.getCuriosHelper().findCurios((LivingEntity)player, new String[]{"lighter"}).stream().filter(r -> r.stack().m_150930_((Item)ModItems.GOLDEN_LIGHTER.get())).findFirst().ifPresent(res -> {
            ItemStack stack = res.stack();
            if (stack.m_41763_()) {
                stack.m_41622_(1, (LivingEntity)player, p -> CuriosApi.getCuriosHelper().onBrokenCurio(res.slotContext()));
            } else if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
        });
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SmelterUtil.executeParticles(serverLevel, pos);
            SmelterUtil.awardLightFurnace(level, pos, player);
            SmelterUtil.awardRainIgnite(level, pos, player);
        }
        cir.setReturnValue((Object)InteractionResult.SUCCESS);
        cir.cancel();
    }

    public static void tryIgnite(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity, Player player, Item item, ItemStack itemInHand, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        boolean weakLighterHandled = WeakLighterUtil.randomExecution(level, pos, state, blockEntity, player, item, itemInHand, hand, cir);
        if (weakLighterHandled) {
            if (WeakLighterUtil.wasSuccessfulIgnition() && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                SmelterUtil.executeParticles(serverLevel, pos);
                SmelterUtil.awardLightFurnace(level, pos, player);
                SmelterUtil.awardFireAspect(level, pos, player, itemInHand);
                SmelterUtil.awardRainIgnite(level, pos, player);
            }
            return;
        }
        ((IIgnited)blockEntity).setIgnitedByPlayer(true);
        SmelterUtil.light(level, pos, state);
        level.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, 1.0f);
        itemInHand.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SmelterUtil.executeParticles(serverLevel, pos);
            SmelterUtil.awardLightFurnace(level, pos, player);
            SmelterUtil.awardFireAspect(level, pos, player, itemInHand);
            SmelterUtil.awardRainIgnite(level, pos, player);
        }
        cir.setReturnValue((Object)InteractionResult.SUCCESS);
        cir.cancel();
    }

    public static void tryShrinkAndIgnite(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity, Player player, Item item, ItemStack itemInHand, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        boolean weakLighterHandled = WeakLighterUtil.randomExecution(level, pos, state, blockEntity, player, item, itemInHand, hand, cir);
        if (weakLighterHandled) {
            if (WeakLighterUtil.wasSuccessfulIgnition() && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                SmelterUtil.executeParticles(serverLevel, pos);
                SmelterUtil.awardLightFurnace(level, pos, player);
                SmelterUtil.awardFireAspect(level, pos, player, itemInHand);
                SmelterUtil.awardRainIgnite(level, pos, player);
            }
            return;
        }
        ((IIgnited)blockEntity).setIgnitedByPlayer(true);
        SmelterUtil.light(level, pos, state);
        level.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (!player.m_150110_().f_35937_) {
            itemInHand.m_41774_(1);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SmelterUtil.executeParticles(serverLevel, pos);
            SmelterUtil.awardLightFurnace(level, pos, player);
            SmelterUtil.awardFireAspect(level, pos, player, itemInHand);
            SmelterUtil.awardRainIgnite(level, pos, player);
        }
        cir.setReturnValue((Object)InteractionResult.SUCCESS);
        cir.cancel();
    }

    public static void awardLightFurnace(Level level, BlockPos pos, Player player) {
        if (!(level instanceof ServerLevel) || !(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        BlockState after = level.m_8055_(pos);
        if (SmelterUtil.isIgnited(after)) {
            AdvancementHooks.awardAdvancement(sp, "light_furnace", "ignited");
        }
    }

    public static void awardFireAspect(Level level, BlockPos pos, Player player, ItemStack used) {
        if (!(level instanceof ServerLevel) || !(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        if (used.m_41619_() || !FireAspectUtil.hasFireAspect(used)) {
            return;
        }
        BlockState after = level.m_8055_(pos);
        if (SmelterUtil.isIgnited(after)) {
            AdvancementHooks.awardAdvancement(sp, "fire_aspect_ignition", "ignited");
        }
    }

    public static void awardRainIgnite(Level level, BlockPos pos, Player player) {
        if (!(level instanceof ServerLevel) || !(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        BlockState after = level.m_8055_(pos);
        if (!SmelterUtil.isIgnited(after)) {
            return;
        }
        if (!EnvironmentCheck.isPrecipitationAbove(level, pos)) {
            return;
        }
        if (!EnvironmentCheck.isHeatSourceBelow(level, pos)) {
            return;
        }
        AdvancementHooks.awardAdvancement(sp, "under_the_rain", "ignited");
    }

    @Nullable
    public static BooleanProperty findIgnitionProperty(BlockState state) {
        if (state.m_61138_((Property)BlockStateProperties.f_61443_)) {
            return BlockStateProperties.f_61443_;
        }
        for (Property properties : state.m_61147_()) {
            if (!(properties instanceof BooleanProperty)) continue;
            BooleanProperty booleanProperty = (BooleanProperty)properties;
            String name = properties.m_61708_();
            if (!"purifying".equals(name) && !"active".equals(name) && !"lit".equals(name) && !"filtering".equals(name)) continue;
            return booleanProperty;
        }
        return null;
    }

    public static BlockState withIgnition(BlockState state, boolean value) {
        BooleanProperty prop = SmelterUtil.findIgnitionProperty(state);
        return prop != null ? (BlockState)state.m_61124_((Property)prop, (Comparable)Boolean.valueOf(value)) : state;
    }

    public static boolean isIgnited(BlockState state) {
        BooleanProperty prop = SmelterUtil.findIgnitionProperty(state);
        return prop != null && (Boolean)state.m_61143_((Property)prop) != false;
    }

    public static void setIgnition(Level level, BlockPos pos, BlockState state, boolean value) {
        level.m_7731_(pos, SmelterUtil.withIgnition(state, value), 3);
    }

    public static void light(Level level, BlockPos pos, BlockState state) {
        SmelterUtil.setIgnition(level, pos, state, true);
    }

    public static void extinguish(Level level, BlockPos pos, BlockState state) {
        SmelterUtil.setIgnition(level, pos, state, false);
    }

    public static void executeParticles(ServerLevel serverLevel, BlockPos pos) {
        double[][] lowerCornerPositions;
        RandomSource rand = serverLevel.m_213780_();
        for (double[] base : lowerCornerPositions = new double[][]{{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}, {(double)pos.m_123341_() + 1.0, pos.m_123342_(), pos.m_123343_()}, {pos.m_123341_(), pos.m_123342_(), (double)pos.m_123343_() + 1.0}, {(double)pos.m_123341_() + 1.0, pos.m_123342_(), (double)pos.m_123343_() + 1.0}}) {
            for (int j = 0; j < 4; ++j) {
                double x = base[0] + (rand.m_188500_() - 0.5) * 0.2;
                double y = base[1] + rand.m_188500_() * 0.5;
                double z = base[2] + (rand.m_188500_() - 0.5) * 0.2;
                SimpleParticleType type = switch (rand.m_188503_(4)) {
                    case 0 -> (SimpleParticleType)ModParticles.SIGN_FLAME_V1.get();
                    case 1 -> (SimpleParticleType)ModParticles.SIGN_FLAME_V2.get();
                    case 2 -> (SimpleParticleType)ModParticles.SIGN_FLAME_V3.get();
                    default -> (SimpleParticleType)ModParticles.SIGN_FLAME_V4.get();
                };
                serverLevel.m_8767_((ParticleOptions)type, x, y, z, 1, 0.0, 0.02, 0.0, 0.02);
            }
        }
    }
}

