/*
 * Decompiled with CFR 0.152.
 */
package com.mosadie.effectmc;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.text2speech.Narrator;
import com.mosadie.effectmc.BlankScreen;
import com.mosadie.effectmc.ItemToast;
import com.mosadie.effectmc.core.EffectExecutor;
import com.mosadie.effectmc.core.EffectMCCore;
import com.mosadie.effectmc.core.WorldState;
import com.mosadie.effectmc.core.effect.ChatVisibilityEffect;
import com.mosadie.effectmc.core.effect.DisconnectEffect;
import com.mosadie.effectmc.core.effect.OpenScreenEffect;
import com.mosadie.effectmc.core.effect.SetPovEffect;
import com.mosadie.effectmc.core.effect.SetSkinEffect;
import com.mosadie.effectmc.core.effect.SetVolumeEffect;
import com.mosadie.effectmc.core.effect.SkinLayerEffect;
import com.mosadie.effectmc.core.effect.internal.Effect;
import com.mosadie.effectmc.core.effect.internal.EffectRequest;
import com.mosadie.effectmc.core.handler.Device;
import com.mosadie.effectmc.core.handler.DeviceType;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1132;
import net.minecraft.class_1659;
import net.minecraft.class_1664;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3419;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_3872;
import net.minecraft.class_410;
import net.minecraft.class_412;
import net.minecraft.class_419;
import net.minecraft.class_420;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_500;
import net.minecraft.class_525;
import net.minecraft.class_526;
import net.minecraft.class_5498;
import net.minecraft.class_5819;
import net.minecraft.class_639;
import net.minecraft.class_642;
import net.minecraft.class_6903;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7417;
import net.minecraft.class_9302;
import net.minecraft.class_9334;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Environment(value=EnvType.CLIENT)
public class EffectMC
implements ModInitializer,
ClientModInitializer,
EffectExecutor {
    public static String MODID = "effectmc";
    private EffectMCCore core;
    public static Logger LOGGER = LogManager.getLogger();
    private static Narrator narrator = Narrator.getNarrator();
    private static class_5819 random = class_5819.method_43047();
    private static class_642 serverInfo = new class_642("", "", class_642.class_8678.field_45611);
    private HttpClient authedClient;

    public void onInitialize() {
        System.out.println("Hello Fabric world!");
    }

    public void onInitializeClient() {
        boolean result;
        File configDir = FabricLoader.getInstance().getConfigDir().resolve("../" + MODID + "/").toFile();
        if (!configDir.exists() && !configDir.mkdirs()) {
            LOGGER.error("Something went wrong creating the config directory! The mod will not work until this is fixed!");
            return;
        }
        File trustFile = configDir.toPath().resolve("trust.json").toFile();
        File configFile = configDir.toPath().resolve("config.json").toFile();
        LOGGER.info("Starting Core");
        this.core = new EffectMCCore(configFile, trustFile, (EffectExecutor)this);
        LOGGER.info("Core Started");
        LOGGER.info("Starting Server");
        try {
            result = this.core.initServer();
        }
        catch (URISyntaxException e) {
            LOGGER.error("Failed to initialize server due to internal error, please report this!", (Throwable)e);
            result = false;
        }
        LOGGER.info("Server start result: " + result);
        GameMessageHandler gameMessageHandler = new GameMessageHandler();
        ClientReceiveMessageEvents.ALLOW_GAME.register((Object)gameMessageHandler);
        ClientCommandRegistrationCallback.EVENT.register(this::registerClientCommand);
        BasicHeader authHeader = new BasicHeader("Authorization", "Bearer " + class_310.method_1551().method_1548().method_1674());
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        headers.add(authHeader);
        this.authedClient = HttpClientBuilder.create().setDefaultHeaders(headers).build();
    }

    private void registerClientCommand(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        LOGGER.info("Registering Client Command");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"effectmc").then(ClientCommandManager.literal((String)"trust").executes(context -> {
            class_310.method_1551().method_63588(() -> ((EffectMCCore)this.core).setTrustFlag());
            this.receiveChatMessage("[EffectMC] Now prompting to trust the next request sent.");
            return 0;
        }))).then(ClientCommandManager.literal((String)"exportbook").executes(context -> {
            if (class_310.method_1551().field_1724 == null) {
                return 0;
            }
            class_1799 mainHand = class_310.method_1551().field_1724.method_6047();
            class_1799 offHand = class_310.method_1551().field_1724.method_6079();
            class_1799 bookStack = null;
            if (mainHand.method_7909().equals(class_1802.field_8360)) {
                bookStack = mainHand;
            } else if (offHand.method_7909().equals(class_1802.field_8360)) {
                bookStack = offHand;
            }
            if (bookStack == null) {
                this.receiveChatMessage("[EffectMC] Failed to export book: Not holding a book!");
                return 0;
            }
            if (!bookStack.method_57353().method_57832(class_9334.field_49606)) {
                this.receiveChatMessage("[EffectMC] Failed to export book: Missing component.");
                return 0;
            }
            DataResult dataResult = class_9302.field_49381.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((class_9302)bookStack.method_58694(class_9334.field_49606)));
            if (dataResult.isError()) {
                this.receiveChatMessage("[EffectMC] Failed to export book: Error encoding JSON.");
                if (dataResult.error().isPresent()) {
                    LOGGER.warn("Error encoding JSON: " + ((DataResult.Error)dataResult.error().get()).message());
                } else {
                    LOGGER.warn("Error encoding JSON: Unknown error.");
                }
                return 0;
            }
            if (dataResult.result().isEmpty()) {
                this.receiveChatMessage("[EffectMC] Failed to export book: No JSON result.");
                return 0;
            }
            String json = ((JsonElement)dataResult.result().get()).toString();
            LOGGER.info("Exported Book JSON: " + json);
            this.receiveChatMessage("[EffectMC] Exported the held book to the current log file.");
            return 0;
        }))).then(ClientCommandManager.literal((String)"exportitem").executes(context -> {
            if (class_310.method_1551().field_1724 == null) {
                LOGGER.info("Null player running exportitem, this shouldn't happen!");
                return 0;
            }
            if (class_310.method_1551().field_1687 == null) {
                LOGGER.info("Null world running exportitem, this shouldn't happen!");
                return 0;
            }
            DataResult dataResult = class_1799.field_24671.encodeStart((DynamicOps)class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)class_310.method_1551().field_1687.method_30349()), (Object)class_310.method_1551().field_1724.method_6047());
            if (dataResult.isError()) {
                this.receiveChatMessage("[EffectMC] Failed to export held item data: Error encoding JSON.");
                if (dataResult.error().isPresent()) {
                    LOGGER.warn("Error encoding JSON: " + ((DataResult.Error)dataResult.error().get()).message());
                } else {
                    LOGGER.warn("Error encoding JSON: Unknown error.");
                }
                return 0;
            }
            if (dataResult.result().isEmpty()) {
                this.receiveChatMessage("[EffectMC] Failed to export held item data: No JSON result.");
                return 0;
            }
            String json = ((JsonElement)dataResult.result().get()).toString();
            LOGGER.info("Held Item JSON: " + json);
            this.showItemToast(json, "Exported", class_310.method_1551().field_1724.method_6047().method_7964().getString());
            this.receiveChatMessage("[EffectMC] Exported held item data to log file!");
            return 0;
        }))).then(ClientCommandManager.literal((String)"exporteffect").executes(context -> {
            this.core.setExportFlag();
            this.receiveChatMessage("[EffectMC] Will export the next triggered effect as JSON to the current log file.");
            return 0;
        }))).then(ClientCommandManager.literal((String)"trigger").then(ClientCommandManager.argument((String)"json", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String json = StringArgumentType.getString((CommandContext)context, (String)"json");
            EffectRequest request = this.core.requestFromJson(json);
            if (request == null) {
                this.receiveChatMessage("[EffectMC] Invalid JSON for effect request!");
                return 0;
            }
            String worldId = this.getWorldState() == WorldState.SINGLEPLAYER ? this.getSPWorldName() : this.getServerIP();
            Device device = new Device(worldId, this.getWorldState() == WorldState.SINGLEPLAYER ? DeviceType.WORLD : DeviceType.SERVER);
            Effect.EffectResult result = this.core.triggerEffect(device, request);
            switch (result.result) {
                case SUCCESS: {
                    this.receiveChatMessage("[EffectMC] Effect \"" + request.getEffectId() + "\" triggered successfully: " + result.message);
                    break;
                }
                case ERROR: {
                    this.receiveChatMessage("[EffectMC] Error triggering effect: " + result.message);
                    break;
                }
                case UNAUTHORIZED: {
                    this.receiveChatMessage("[EffectMC] World/Server not trusted. Use /effectmc trust to trust the current world/server.");
                    break;
                }
                case UNKNOWN: {
                    this.receiveChatMessage("[EffectMC] Unknown effect.");
                    break;
                }
                case SKIPPED: {
                    this.receiveChatMessage("[EffectMC] Effect skipped: " + result.message);
                    break;
                }
                case UNSUPPORTED: {
                    this.receiveChatMessage("[EffectMC] Effect unsupported: " + result.message);
                }
            }
            return 0;
        })))).executes(context -> {
            this.receiveChatMessage("[EffectMC] Available subcommands: exportbook, exportitem, exporteffect, trigger, trust");
            return 0;
        }));
    }

    public void log(String message) {
        LOGGER.info(message);
    }

    public boolean joinServer(String serverIp) {
        class_310.method_1551().method_63588(() -> {
            this.leaveIfNeeded();
            if (!class_639.method_36224((String)serverIp)) {
                LOGGER.warn("Invalid server address: " + serverIp);
                return;
            }
            class_639 address = class_639.method_2950((String)serverIp);
            class_642 info = new class_642("EffectMC", serverIp, class_642.class_8678.field_45611);
            LOGGER.info("Connecting to " + serverIp);
            class_412.method_36877((class_437)new class_442(), (class_310)class_310.method_1551(), (class_639)address, (class_642)info, (boolean)false, null);
        });
        return true;
    }

    public boolean setSkinLayer(SkinLayerEffect.SKIN_SECTION section, boolean visibility) {
        class_315 options = class_310.method_1551().field_1690;
        switch (section) {
            case ALL: {
                options.method_1635(class_1664.field_7559, visibility);
            }
            case ALL_BODY: {
                options.method_1635(class_1664.field_7563, visibility);
                options.method_1635(class_1664.field_7564, visibility);
                options.method_1635(class_1664.field_7568, visibility);
                options.method_1635(class_1664.field_7566, visibility);
                options.method_1635(class_1664.field_7570, visibility);
                options.method_1635(class_1664.field_7565, visibility);
                break;
            }
            case CAPE: {
                options.method_1635(class_1664.field_7559, visibility);
                break;
            }
            case JACKET: {
                options.method_1635(class_1664.field_7564, visibility);
                break;
            }
            case LEFT_SLEEVE: {
                options.method_1635(class_1664.field_7568, visibility);
                break;
            }
            case RIGHT_SLEEVE: {
                options.method_1635(class_1664.field_7570, visibility);
                break;
            }
            case LEFT_PANTS_LEG: {
                options.method_1635(class_1664.field_7566, visibility);
                break;
            }
            case RIGHT_PANTS_LEG: {
                options.method_1635(class_1664.field_7565, visibility);
                break;
            }
            case HAT: {
                options.method_1635(class_1664.field_7563, visibility);
            }
        }
        options.method_1640();
        return true;
    }

    public boolean toggleSkinLayer(SkinLayerEffect.SKIN_SECTION section) {
        class_315 options = class_310.method_1551().field_1690;
        switch (section) {
            case ALL: {
                this.togglePlayerModelPart(options, class_1664.field_7559);
            }
            case ALL_BODY: {
                this.togglePlayerModelPart(options, class_1664.field_7563);
                this.togglePlayerModelPart(options, class_1664.field_7564);
                this.togglePlayerModelPart(options, class_1664.field_7568);
                this.togglePlayerModelPart(options, class_1664.field_7566);
                this.togglePlayerModelPart(options, class_1664.field_7570);
                this.togglePlayerModelPart(options, class_1664.field_7565);
                break;
            }
            case CAPE: {
                this.togglePlayerModelPart(options, class_1664.field_7559);
                break;
            }
            case JACKET: {
                this.togglePlayerModelPart(options, class_1664.field_7564);
                break;
            }
            case LEFT_SLEEVE: {
                this.togglePlayerModelPart(options, class_1664.field_7568);
                break;
            }
            case RIGHT_SLEEVE: {
                this.togglePlayerModelPart(options, class_1664.field_7570);
                break;
            }
            case LEFT_PANTS_LEG: {
                this.togglePlayerModelPart(options, class_1664.field_7566);
                break;
            }
            case RIGHT_PANTS_LEG: {
                this.togglePlayerModelPart(options, class_1664.field_7565);
                break;
            }
            case HAT: {
                this.togglePlayerModelPart(options, class_1664.field_7563);
            }
        }
        options.method_1640();
        return true;
    }

    private void togglePlayerModelPart(class_315 options, class_1664 part) {
        options.method_1635(part, !options.method_32594(part));
    }

    public boolean sendChatMessage(String message) {
        if (class_310.method_1551().field_1724 != null) {
            if (message.startsWith("/")) {
                LOGGER.info("Sending command message: " + message);
                class_310.method_1551().field_1724.field_3944.method_45730(message.substring(1));
            } else {
                LOGGER.info("Sending chat message: " + message);
                class_310.method_1551().field_1724.field_3944.method_45729(message);
            }
            return true;
        }
        return false;
    }

    public boolean receiveChatMessage(String message) {
        if (class_310.method_1551().field_1724 != null) {
            LOGGER.info("Showing chat message: " + message);
            class_310.method_1551().field_1724.method_7353(class_2561.method_30163((String)message), false);
            return true;
        }
        return false;
    }

    public boolean showTitle(String title, String subtitle) {
        LOGGER.info("Showing Title: " + title + " Subtitle: " + subtitle);
        class_310.method_1551().field_1705.method_1742();
        class_310.method_1551().field_1705.method_34002(class_2561.method_30163((String)subtitle));
        class_310.method_1551().field_1705.method_34004(class_2561.method_30163((String)title));
        return true;
    }

    public boolean showActionMessage(String message) {
        LOGGER.info("Showing ActionBar message: " + message);
        class_310.method_1551().field_1705.method_1758(class_2561.method_30163((String)message), false);
        return true;
    }

    public void showTrustPrompt(Device device) {
        class_310.method_1551().method_63588(() -> {
            class_410 screen = new class_410((BooleanConsumer)new EffectMCCore.TrustBooleanConsumer(device, this.core), class_2561.method_30163((String)"EffectMC - Trust Prompt"), class_2561.method_30163((String)("Do you want to trust this device?\n(Type: " + String.valueOf(device.getType()) + (String)(device.getType() == DeviceType.OTHER ? " Device Id:" + device.getId() : "") + ")")));
            class_310.method_1551().method_1507((class_437)screen);
        });
    }

    public boolean triggerDisconnect(DisconnectEffect.NEXT_SCREEN nextScreenType, String title, String message) {
        class_310.method_1551().method_63588(() -> {
            this.leaveIfNeeded();
            class_419 screen = new class_419((class_437)(switch (nextScreenType) {
                default -> new class_442();
                case DisconnectEffect.NEXT_SCREEN.SERVER_SELECT -> new class_500((class_437)new class_442());
                case DisconnectEffect.NEXT_SCREEN.WORLD_SELECT -> new class_526((class_437)new class_442());
            }), class_2561.method_30163((String)title), class_2561.method_30163((String)message));
            class_310.method_1551().method_1507((class_437)screen);
        });
        return true;
    }

    public boolean playSound(String soundID, String categoryName, float volume, float pitch, boolean repeat, int repeatDelay, String attenuationType, double x, double y, double z, boolean relative, boolean global) {
        class_310.method_1551().method_63588(() -> {
            class_1113.class_1114 attenuation;
            class_3419 category;
            class_2960 sound = class_2960.method_12829((String)soundID);
            if (sound == null) {
                LOGGER.info("Invalid sound Identifier");
            }
            try {
                category = class_3419.valueOf((String)categoryName.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                category = class_3419.field_15250;
            }
            try {
                attenuation = class_1113.class_1114.valueOf((String)attenuationType.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                attenuation = class_1113.class_1114.field_5478;
            }
            double trueX = x;
            double trueY = y;
            double trueZ = z;
            if (relative && class_310.method_1551().field_1687 != null && class_310.method_1551().field_1724 != null) {
                trueX += class_310.method_1551().field_1724.method_23317();
                trueY += class_310.method_1551().field_1724.method_23318();
                trueZ += class_310.method_1551().field_1724.method_23321();
            }
            class_310.method_1551().method_1483().method_4873((class_1113)new class_1109(sound, category, volume, pitch, random, repeat, repeatDelay, attenuation, trueX, trueY, trueZ, global));
        });
        return true;
    }

    public void resetScreen() {
        class_310.method_1551().method_63588(() -> class_310.method_1551().method_1507(null));
    }

    public boolean stopSound(String sound, String categoryName) {
        class_310.method_1551().method_63588(() -> {
            class_2960 location = sound == null ? null : class_2960.method_12829((String)sound);
            class_3419 category = null;
            try {
                category = class_3419.valueOf((String)categoryName);
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {
                // empty catch block
            }
            class_310.method_1551().method_1483().method_4875(location, category);
        });
        return true;
    }

    public boolean showToast(String title, String subtitle) {
        class_310.method_1551().method_63588(() -> class_310.method_1551().method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47583, class_2561.method_30163((String)title), class_2561.method_30163((String)subtitle))));
        return true;
    }

    public boolean showItemToast(String itemData, String title, String subtitle) {
        class_310.method_1551().method_63588(() -> class_310.method_1551().method_1566().method_1999((class_368)new ItemToast(itemData, class_2561.method_30163((String)title), class_2561.method_30163((String)subtitle), this.core)));
        return true;
    }

    public boolean openBook(JsonObject bookJSON) {
        class_310.method_1551().method_63588(() -> {
            DataResult dataResult = class_9302.field_49381.decode((DynamicOps)JsonOps.INSTANCE, (Object)bookJSON);
            if (dataResult.isError()) {
                if (dataResult.error().isPresent()) {
                    LOGGER.error("Error decoding book JSON: " + ((DataResult.Error)dataResult.error().get()).message());
                } else {
                    LOGGER.error("Error decoding book JSON: Unknown error.");
                }
                return;
            }
            if (dataResult.result().isEmpty()) {
                LOGGER.error("No result from decoding book JSON.");
                return;
            }
            class_1799 bookStack = new class_1799((class_1935)class_1802.field_8360);
            bookStack.method_57379(class_9334.field_49606, (Object)((class_9302)((Pair)dataResult.result().get()).getFirst()));
            class_3872.class_3931 bookContents = class_3872.class_3931.method_17562((class_1799)bookStack);
            class_3872 screen = new class_3872(bookContents);
            class_310.method_1551().method_1507((class_437)screen);
        });
        return true;
    }

    public boolean narrate(String message, boolean interrupt) {
        if (narrator.active()) {
            class_310.method_1551().method_63588(() -> narrator.say(message, interrupt, 1.0f));
            return true;
        }
        LOGGER.error("Narrator is unavailable!");
        return false;
    }

    public boolean loadWorld(String worldName) {
        class_310.method_1551().method_63588(() -> {
            if (class_310.method_1551().method_1586().method_230(worldName)) {
                this.leaveIfNeeded();
                LOGGER.info("Loading world...");
                class_310.method_1551().method_41735().method_57784(worldName, () -> {
                    LOGGER.info("World load cancelled!");
                    class_310.method_1551().method_1507((class_437)new class_442());
                });
            } else {
                LOGGER.warn("World " + worldName + " does not exist!");
            }
        });
        return true;
    }

    public boolean setSkin(URL skinUrl, SetSkinEffect.SKIN_TYPE skinType) {
        if (skinUrl == null) {
            LOGGER.warn("Skin URL is null!");
            return false;
        }
        try {
            JsonObject payload = new JsonObject();
            payload.add("variant", (JsonElement)new JsonPrimitive(skinType.getValue()));
            payload.add("url", (JsonElement)new JsonPrimitive(skinUrl.toString()));
            HttpPost request = new HttpPost("https://api.minecraftservices.com/minecraft/profile/skins");
            request.setEntity((HttpEntity)new StringEntity(payload.toString(), ContentType.APPLICATION_JSON));
            HttpResponse response = this.authedClient.execute((HttpUriRequest)request);
            if (response.getEntity() != null && response.getEntity().getContentLength() > 0L) {
                JsonObject responseJSON = this.core.fromJson(IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8));
                if (responseJSON.has("errorMessage")) {
                    LOGGER.warn("Failed to update skin! " + String.valueOf(responseJSON));
                    return false;
                }
                LOGGER.debug("Skin Update Response: " + String.valueOf(responseJSON));
            }
            LOGGER.info("Skin updated!");
            return true;
        }
        catch (IOException e) {
            LOGGER.warn("Failed to update skin!", (Throwable)e);
            return false;
        }
    }

    public void leaveIfNeeded() {
        if (class_310.method_1551().field_1687 != null) {
            LOGGER.info("Disconnecting from world...");
            class_310.method_1551().field_1687.method_8525((class_2561)class_2561.method_43470((String)"Loading new world..."));
            class_310.method_1551().method_18096((class_437)new BlankScreen(), false);
        }
    }

    public boolean openScreen(OpenScreenEffect.SCREEN screen) {
        class_310.method_1551().execute(() -> {
            this.leaveIfNeeded();
            switch (screen) {
                case MAIN_MENU: {
                    class_310.method_1551().method_1507((class_437)new class_442());
                    break;
                }
                case SERVER_SELECT: {
                    class_310.method_1551().method_1507((class_437)new class_500((class_437)new class_442()));
                    break;
                }
                case SERVER_DIRECT_CONNECT: {
                    class_310.method_1551().method_1507((class_437)new class_420((class_437)new class_500((class_437)new class_442()), this::connectIfTrue, serverInfo));
                    break;
                }
                case WORLD_SELECT: {
                    class_310.method_1551().method_1507((class_437)new class_526((class_437)new class_442()));
                    break;
                }
                case WORLD_CREATE: {
                    class_525.method_31130((class_310)class_310.method_1551(), () -> class_310.method_1551().method_1507((class_437)new class_526((class_437)new class_442())));
                    break;
                }
                default: {
                    LOGGER.error("Unknown screen.");
                }
            }
        });
        return true;
    }

    public boolean setFOV(int fov) {
        class_310.method_1551().execute(() -> class_310.method_1551().field_1690.method_41808().method_41748((Object)fov));
        return true;
    }

    public boolean setPOV(SetPovEffect.POV pov) {
        class_310.method_1551().execute(() -> EffectMC.lambda$setPOV$21(switch (pov) {
            default -> class_5498.field_26664;
            case SetPovEffect.POV.THIRD_PERSON_BACK -> class_5498.field_26665;
            case SetPovEffect.POV.THIRD_PERSON_FRONT -> class_5498.field_26666;
        }));
        return true;
    }

    public boolean setGuiScale(int scale) {
        if (((Integer)class_310.method_1551().field_1690.method_42474().method_41753()).equals(scale)) {
            return true;
        }
        class_310.method_1551().execute(() -> {
            class_310.method_1551().field_1690.method_42474().method_41748((Object)scale);
            class_310.method_1551().field_1690.method_1640();
            class_310.method_1551().method_15993();
        });
        return true;
    }

    public boolean setGamma(double gamma) {
        class_310.method_1551().execute(() -> {
            class_310.method_1551().field_1690.method_42473().method_41748((Object)gamma);
            class_310.method_1551().field_1690.method_1640();
        });
        return true;
    }

    public boolean setChatVisibility(ChatVisibilityEffect.VISIBILITY visibility) {
        class_1659 result;
        switch (visibility) {
            case SHOW: {
                result = class_1659.field_7538;
                break;
            }
            case COMMANDS_ONLY: {
                result = class_1659.field_7539;
                break;
            }
            case HIDE: {
                result = class_1659.field_7536;
                break;
            }
            default: {
                return false;
            }
        }
        class_310.method_1551().execute(() -> {
            class_310.method_1551().field_1690.method_42539().method_41748((Object)result);
            class_310.method_1551().field_1690.method_1640();
        });
        return true;
    }

    public boolean setRenderDistance(int chunks) {
        class_310.method_1551().execute(() -> {
            class_310.method_1551().field_1690.method_42503().method_41748((Object)chunks);
            class_310.method_1551().field_1690.method_1640();
        });
        return true;
    }

    public WorldState getWorldState() {
        if (class_310.method_1551().field_1687 == null) {
            return WorldState.OTHER;
        }
        return class_310.method_1551().method_47392() ? WorldState.SINGLEPLAYER : WorldState.MULTIPLAYER;
    }

    public String getSPWorldName() {
        if (this.getWorldState() != WorldState.SINGLEPLAYER) {
            return null;
        }
        class_1132 server = class_310.method_1551().method_1576();
        if (server != null) {
            return server.method_27728().method_150();
        }
        LOGGER.info("Attempted to get SP World Name, but no integrated server was found!");
        return null;
    }

    public String getServerIP() {
        if (this.getWorldState() != WorldState.MULTIPLAYER) {
            return null;
        }
        if (class_310.method_1551().method_1558() != null) {
            return class_310.method_1551().method_1558().field_3761;
        }
        LOGGER.info("Failed to get Server IP!");
        return null;
    }

    public void setVolume(SetVolumeEffect.VOLUME_CATEGORIES category, int volume) {
        class_310.method_1551().execute(() -> {
            class_3419 mcCategory;
            switch (category) {
                case MASTER: {
                    mcCategory = class_3419.field_15250;
                    break;
                }
                case MUSIC: {
                    mcCategory = class_3419.field_15253;
                    break;
                }
                case RECORDS: {
                    mcCategory = class_3419.field_15247;
                    break;
                }
                case WEATHER: {
                    mcCategory = class_3419.field_15252;
                    break;
                }
                case BLOCKS: {
                    mcCategory = class_3419.field_15245;
                    break;
                }
                case HOSTILE: {
                    mcCategory = class_3419.field_15251;
                    break;
                }
                case NEUTRAL: {
                    mcCategory = class_3419.field_15254;
                    break;
                }
                case PLAYERS: {
                    mcCategory = class_3419.field_15248;
                    break;
                }
                case AMBIENT: {
                    mcCategory = class_3419.field_15256;
                    break;
                }
                case VOICE: {
                    mcCategory = class_3419.field_15246;
                    break;
                }
                default: {
                    LOGGER.error("Unknown volume category!");
                    return;
                }
            }
            class_310.method_1551().field_1690.method_45578(mcCategory).method_41748((Object)((double)volume / 100.0));
            class_310.method_1551().field_1690.method_1640();
        });
    }

    private void connectIfTrue(boolean connect) {
        if (connect) {
            this.joinServer(EffectMC.serverInfo.field_3761);
        } else {
            class_310.method_1551().method_1507((class_437)new class_500((class_437)new class_442()));
        }
    }

    private static /* synthetic */ void lambda$setPOV$21(class_5498 mcPov) {
        class_310.method_1551().field_1690.method_31043(mcPov);
    }

    @Environment(value=EnvType.CLIENT)
    public class GameMessageHandler
    implements ClientReceiveMessageEvents.AllowGame {
        public boolean allowReceiveGameMessage(class_2561 message, boolean overlay) {
            class_7417 class_74172 = message.method_10851();
            if (class_74172 instanceof class_2588) {
                class_2588 text = (class_2588)class_74172;
                if (!text.method_11022().equals("com.mosadie.effectmc.trigger")) {
                    return true;
                }
                if (text.method_11023().length == 0) {
                    LOGGER.error("Received trigger message with no arguments!");
                    return false;
                }
                EffectRequest request = EffectMC.this.core.requestFromJson(String.valueOf(text.method_11023()[0]));
                if (request == null) {
                    LOGGER.error("Failed to parse request!");
                    return false;
                }
                String worldId = EffectMC.this.getWorldState() == WorldState.SINGLEPLAYER ? EffectMC.this.getSPWorldName() : EffectMC.this.getServerIP();
                Device device = new Device(worldId, EffectMC.this.getWorldState() == WorldState.SINGLEPLAYER ? DeviceType.WORLD : DeviceType.SERVER);
                EffectMC.this.core.triggerEffect(device, request);
                return false;
            }
            return true;
        }
    }
}

