/*
 * Decompiled with CFR 0.152.
 */
package com.mosadie.effectmc;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.text2speech.Narrator;
import com.mosadie.effectmc.BlankScreen;
import com.mosadie.effectmc.ItemToast;
import com.mosadie.effectmc.core.EffectExecutor;
import com.mosadie.effectmc.core.EffectMCCore;
import com.mosadie.effectmc.core.WorldState;
import com.mosadie.effectmc.core.effect.ChatVisibilityEffect;
import com.mosadie.effectmc.core.effect.DisconnectEffect;
import com.mosadie.effectmc.core.effect.OpenScreenEffect;
import com.mosadie.effectmc.core.effect.SetPovEffect;
import com.mosadie.effectmc.core.effect.SetSkinEffect;
import com.mosadie.effectmc.core.effect.SetVolumeEffect;
import com.mosadie.effectmc.core.effect.SkinLayerEffect;
import com.mosadie.effectmc.core.effect.internal.Effect;
import com.mosadie.effectmc.core.effect.internal.EffectRequest;
import com.mosadie.effectmc.core.handler.Device;
import com.mosadie.effectmc.core.handler.DeviceType;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.DirectJoinServerScreen;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.commands.Commands;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.ChatVisiblity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientChatReceivedEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="effectmc")
public class EffectMC
implements EffectExecutor {
    public static final String MODID = "effectmc";
    private final EffectMCCore core;
    public static Logger LOGGER = LogManager.getLogger();
    private static Narrator narrator = Narrator.getNarrator();
    private static RandomSource randomSource = RandomSource.create();
    private static ServerData serverData = new ServerData("", "", ServerData.Type.OTHER);
    private HttpClient authedClient;

    public EffectMC(IEventBus modbus) throws IOException {
        boolean result;
        File configDir = ModList.get().getModFileById(MODID).getFile().getFilePath().resolve("../effectmc/").toFile();
        if (!configDir.exists() && !configDir.mkdirs()) {
            LOGGER.error("Something went wrong creating the config directory!");
            throw new IOException("Failed to create config directory!");
        }
        File trustFile = configDir.toPath().resolve("trust.json").toFile();
        File configFile = configDir.toPath().resolve("config.json").toFile();
        LOGGER.info("Starting Core");
        this.core = new EffectMCCore(configFile, trustFile, (EffectExecutor)this);
        LOGGER.info("Core Started");
        LOGGER.info("Starting Server");
        try {
            result = this.core.initServer();
        }
        catch (URISyntaxException e) {
            LOGGER.error("Failed to initialize server due to internal error, please report this!", (Throwable)e);
            result = false;
        }
        LOGGER.info("Server start result: " + result);
        NeoForge.EVENT_BUS.addListener(this::registerClientCommand);
        NeoForge.EVENT_BUS.addListener(this::listenForTranslation);
        modbus.addListener(this::clientSetupEvent);
    }

    public void clientSetupEvent(FMLClientSetupEvent event) {
        BasicHeader authHeader = new BasicHeader("Authorization", "Bearer " + Minecraft.getInstance().getUser().getAccessToken());
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        headers.add(authHeader);
        this.authedClient = HttpClientBuilder.create().setDefaultHeaders(headers).build();
    }

    public void registerClientCommand(RegisterClientCommandsEvent event) {
        LOGGER.info("Registering effectmc command.");
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)MODID).then(Commands.literal((String)"trust").executes(context -> {
            Minecraft.getInstance().execute(() -> ((EffectMCCore)this.core).setTrustFlag());
            this.receiveChatMessage("[EffectMC] Now prompting to trust the next request sent.");
            return 0;
        }))).then(Commands.literal((String)"exportbook").executes(context -> {
            if (Minecraft.getInstance().player == null) {
                return 0;
            }
            ItemStack mainHand = Minecraft.getInstance().player.getMainHandItem();
            ItemStack offHand = Minecraft.getInstance().player.getOffhandItem();
            ItemStack bookStack = null;
            if (mainHand.getItem().equals(Items.WRITTEN_BOOK)) {
                bookStack = mainHand;
            } else if (offHand.getItem().equals(Items.WRITTEN_BOOK)) {
                bookStack = offHand;
            }
            if (bookStack == null) {
                this.receiveChatMessage("[EffectMC] Failed to export book: Not holding a book!");
                return 0;
            }
            if (!bookStack.getComponents().has(DataComponents.WRITTEN_BOOK_CONTENT)) {
                this.receiveChatMessage("[EffectMC] Failed to export book: Missing component.");
                return 0;
            }
            DataResult dataResult = WrittenBookContent.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((WrittenBookContent)bookStack.get(DataComponents.WRITTEN_BOOK_CONTENT)));
            if (dataResult.isError()) {
                this.receiveChatMessage("[EffectMC] Failed to export book: Error encoding JSON.");
                if (dataResult.error().isPresent()) {
                    LOGGER.warn("Error encoding JSON: " + ((DataResult.Error)dataResult.error().get()).message());
                } else {
                    LOGGER.warn("Error encoding JSON: Unknown error.");
                }
                return 0;
            }
            if (dataResult.result().isEmpty()) {
                this.receiveChatMessage("[EffectMC] Failed to export book: No JSON result.");
                return 0;
            }
            String json = ((JsonElement)dataResult.result().get()).toString();
            LOGGER.info("Exported Book JSON: " + json);
            this.receiveChatMessage("[EffectMC] Exported the held book to the current log file.");
            return 0;
        }))).then(Commands.literal((String)"exportitem").executes(context -> {
            if (Minecraft.getInstance().player == null) {
                LOGGER.info("Null player running exportitem, this shouldn't happen!");
                return 0;
            }
            if (Minecraft.getInstance().level == null) {
                LOGGER.info("Null level running exportitem, this shouldn't happen!");
                return 0;
            }
            try {
                DataResult dataResult = ItemStack.CODEC.encodeStart((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()), (Object)Minecraft.getInstance().player.getMainHandItem());
                if (dataResult.isError()) {
                    this.receiveChatMessage("[EffectMC] Failed to export held item data: Error encoding JSON.");
                    if (dataResult.error().isPresent()) {
                        LOGGER.warn("Error encoding JSON: " + ((DataResult.Error)dataResult.error().get()).message());
                    } else {
                        LOGGER.warn("Error encoding JSON: Unknown error.");
                    }
                    return 0;
                }
                if (dataResult.result().isEmpty()) {
                    this.receiveChatMessage("[EffectMC] Failed to export held item data: No JSON result.");
                    return 0;
                }
                String json = ((JsonElement)dataResult.result().get()).toString();
                LOGGER.info("Held Item JSON: " + json);
                this.showItemToast(json, "Exported", Minecraft.getInstance().player.getMainHandItem().getDisplayName().getString());
                this.receiveChatMessage("[EffectMC] Exported held item data to log file!");
                return 0;
            }
            catch (Exception e) {
                LOGGER.error("Failed to export item data!", (Throwable)e);
                this.receiveChatMessage("[EffectMC] Failed to export held item data: Internal error.");
                return 0;
            }
        }))).then(Commands.literal((String)"exporteffect").executes(context -> {
            this.core.setExportFlag();
            this.receiveChatMessage("[EffectMC] Will export the next triggered effect as JSON to the current log file.");
            return 0;
        }))).then(Commands.literal((String)"trigger").then(Commands.argument((String)"json", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String json = StringArgumentType.getString((CommandContext)context, (String)"json");
            EffectRequest request = this.core.requestFromJson(json);
            if (request == null) {
                this.receiveChatMessage("[EffectMC] Invalid JSON for effect request!");
                return 0;
            }
            String worldId = this.getWorldState() == WorldState.SINGLEPLAYER ? this.getSPWorldName() : this.getServerIP();
            Device device = new Device(worldId, this.getWorldState() == WorldState.SINGLEPLAYER ? DeviceType.WORLD : DeviceType.SERVER);
            Effect.EffectResult result = this.core.triggerEffect(device, request);
            switch (result.result) {
                case SUCCESS: {
                    this.receiveChatMessage("[EffectMC] Effect \"" + request.getEffectId() + "\" triggered successfully: " + result.message);
                    break;
                }
                case ERROR: {
                    this.receiveChatMessage("[EffectMC] Error triggering effect: " + result.message);
                    break;
                }
                case UNAUTHORIZED: {
                    this.receiveChatMessage("[EffectMC] World/Server not trusted. Use /effectmc trust to trust the current world/server.");
                    break;
                }
                case UNKNOWN: {
                    this.receiveChatMessage("[EffectMC] Unknown effect.");
                    break;
                }
                case SKIPPED: {
                    this.receiveChatMessage("[EffectMC] Effect skipped: " + result.message);
                    break;
                }
                case UNSUPPORTED: {
                    this.receiveChatMessage("[EffectMC] Effect unsupported: " + result.message);
                }
            }
            return 0;
        })))).executes(context -> {
            this.receiveChatMessage("[EffectMC] Available subcommands: exportbook, exportitem, exporteffect, trigger, trust");
            return 0;
        }));
        LOGGER.info("Registered effectmc command.");
    }

    public void listenForTranslation(ClientChatReceivedEvent event) {
        TranslatableContents translationTextComponent;
        Component component = event.getMessage();
        ComponentContents componentContents = component.getContents();
        if (componentContents instanceof TranslatableContents && (translationTextComponent = (TranslatableContents)componentContents).getKey().equals("com.mosadie.effectmc.trigger")) {
            event.setCanceled(true);
            if (translationTextComponent.getArgs().length != 1) {
                this.log("Invalid length of args for translation trigger!");
                return;
            }
            String data = String.valueOf(translationTextComponent.getArgs()[0]);
            EffectRequest request = this.core.requestFromJson(data);
            if (request == null) {
                this.log("Invalid request json for translation trigger!");
                return;
            }
            String worldId = this.getWorldState() == WorldState.SINGLEPLAYER ? this.getSPWorldName() : this.getServerIP();
            Device device = new Device(worldId, this.getWorldState() == WorldState.SINGLEPLAYER ? DeviceType.WORLD : DeviceType.SERVER);
            this.core.triggerEffect(device, request);
        }
    }

    public void log(String message) {
        LOGGER.info(message);
    }

    public boolean joinServer(String serverIp) {
        Minecraft.getInstance().execute(() -> {
            this.leaveIfNeeded();
            if (!ServerAddress.isValidAddress((String)serverIp)) {
                LOGGER.error("Invalid server IP!");
                DisconnectedScreen errorScreen = new DisconnectedScreen((Screen)new JoinMultiplayerScreen((Screen)new TitleScreen()), (Component)Component.literal((String)"Failed to join server!"), (Component)Component.literal((String)"Invalid server IP!"));
                Minecraft.getInstance().setScreen((Screen)errorScreen);
                return;
            }
            ServerAddress serverAddress = ServerAddress.parseString((String)serverIp);
            ServerData serverData = new ServerData("EffectMC", serverIp, ServerData.Type.OTHER);
            LOGGER.info("Connecting to " + serverAddress.getHost());
            ConnectScreen.startConnecting((Screen)new TitleScreen(), (Minecraft)Minecraft.getInstance(), (ServerAddress)serverAddress, (ServerData)serverData, (boolean)false, null);
        });
        return true;
    }

    public boolean setSkinLayer(SkinLayerEffect.SKIN_SECTION section, boolean visibility) {
        Options options = Minecraft.getInstance().options;
        switch (section) {
            case ALL: {
                options.setModelPart(PlayerModelPart.CAPE, visibility);
            }
            case ALL_BODY: {
                options.setModelPart(PlayerModelPart.HAT, visibility);
                options.setModelPart(PlayerModelPart.JACKET, visibility);
                options.setModelPart(PlayerModelPart.LEFT_SLEEVE, visibility);
                options.setModelPart(PlayerModelPart.LEFT_PANTS_LEG, visibility);
                options.setModelPart(PlayerModelPart.RIGHT_SLEEVE, visibility);
                options.setModelPart(PlayerModelPart.RIGHT_PANTS_LEG, visibility);
                break;
            }
            case CAPE: {
                options.setModelPart(PlayerModelPart.CAPE, visibility);
                break;
            }
            case JACKET: {
                options.setModelPart(PlayerModelPart.JACKET, visibility);
                break;
            }
            case LEFT_SLEEVE: {
                options.setModelPart(PlayerModelPart.LEFT_SLEEVE, visibility);
                break;
            }
            case RIGHT_SLEEVE: {
                options.setModelPart(PlayerModelPart.RIGHT_SLEEVE, visibility);
                break;
            }
            case LEFT_PANTS_LEG: {
                options.setModelPart(PlayerModelPart.LEFT_PANTS_LEG, visibility);
                break;
            }
            case RIGHT_PANTS_LEG: {
                options.setModelPart(PlayerModelPart.RIGHT_PANTS_LEG, visibility);
                break;
            }
            case HAT: {
                options.setModelPart(PlayerModelPart.HAT, visibility);
            }
        }
        options.save();
        return true;
    }

    public boolean toggleSkinLayer(SkinLayerEffect.SKIN_SECTION section) {
        Options options = Minecraft.getInstance().options;
        switch (section) {
            case ALL: {
                options.setModelPart(PlayerModelPart.CAPE, !options.isModelPartEnabled(PlayerModelPart.CAPE));
            }
            case ALL_BODY: {
                options.setModelPart(PlayerModelPart.HAT, !options.isModelPartEnabled(PlayerModelPart.HAT));
                options.setModelPart(PlayerModelPart.JACKET, !options.isModelPartEnabled(PlayerModelPart.JACKET));
                options.setModelPart(PlayerModelPart.LEFT_SLEEVE, !options.isModelPartEnabled(PlayerModelPart.LEFT_SLEEVE));
                options.setModelPart(PlayerModelPart.LEFT_PANTS_LEG, !options.isModelPartEnabled(PlayerModelPart.LEFT_PANTS_LEG));
                options.setModelPart(PlayerModelPart.RIGHT_SLEEVE, !options.isModelPartEnabled(PlayerModelPart.RIGHT_SLEEVE));
                options.setModelPart(PlayerModelPart.RIGHT_PANTS_LEG, !options.isModelPartEnabled(PlayerModelPart.RIGHT_PANTS_LEG));
                break;
            }
            case CAPE: {
                options.setModelPart(PlayerModelPart.CAPE, !options.isModelPartEnabled(PlayerModelPart.CAPE));
                break;
            }
            case JACKET: {
                options.setModelPart(PlayerModelPart.JACKET, !options.isModelPartEnabled(PlayerModelPart.JACKET));
                break;
            }
            case LEFT_SLEEVE: {
                options.setModelPart(PlayerModelPart.LEFT_SLEEVE, !options.isModelPartEnabled(PlayerModelPart.LEFT_SLEEVE));
                break;
            }
            case RIGHT_SLEEVE: {
                options.setModelPart(PlayerModelPart.RIGHT_SLEEVE, !options.isModelPartEnabled(PlayerModelPart.RIGHT_SLEEVE));
                break;
            }
            case LEFT_PANTS_LEG: {
                options.setModelPart(PlayerModelPart.LEFT_PANTS_LEG, !options.isModelPartEnabled(PlayerModelPart.LEFT_PANTS_LEG));
                break;
            }
            case RIGHT_PANTS_LEG: {
                options.setModelPart(PlayerModelPart.RIGHT_PANTS_LEG, !options.isModelPartEnabled(PlayerModelPart.RIGHT_PANTS_LEG));
                break;
            }
            case HAT: {
                options.setModelPart(PlayerModelPart.HAT, !options.isModelPartEnabled(PlayerModelPart.HAT));
            }
        }
        options.save();
        return true;
    }

    public boolean sendChatMessage(String message) {
        if (Minecraft.getInstance().player != null) {
            if (message.startsWith("/")) {
                LOGGER.info("Sending command message: " + message);
                Minecraft.getInstance().player.connection.sendCommand(message.substring(1));
            } else {
                LOGGER.info("Sending chat message: " + message);
                Minecraft.getInstance().player.connection.sendChat(message);
            }
            return true;
        }
        return false;
    }

    public boolean receiveChatMessage(String message) {
        if (Minecraft.getInstance().player != null) {
            LOGGER.info("Showing chat message: " + message);
            Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)message), false);
            return true;
        }
        return false;
    }

    public boolean showTitle(String title, String subtitle) {
        LOGGER.info("Showing Title: " + title + " Subtitle: " + subtitle);
        Minecraft.getInstance().gui.resetTitleTimes();
        Minecraft.getInstance().gui.setSubtitle((Component)Component.literal((String)subtitle));
        Minecraft.getInstance().gui.setTitle((Component)Component.literal((String)title));
        return true;
    }

    public boolean showActionMessage(String message) {
        LOGGER.info("Showing ActionBar message: " + message);
        Minecraft.getInstance().gui.setOverlayMessage((Component)Component.literal((String)message), false);
        return true;
    }

    public boolean triggerDisconnect(DisconnectEffect.NEXT_SCREEN nextScreenType, String title, String message) {
        Minecraft.getInstance().execute(() -> {
            this.leaveIfNeeded();
            DisconnectedScreen screen = new DisconnectedScreen((Screen)(switch (nextScreenType) {
                default -> new TitleScreen();
                case DisconnectEffect.NEXT_SCREEN.SERVER_SELECT -> new JoinMultiplayerScreen((Screen)new TitleScreen());
                case DisconnectEffect.NEXT_SCREEN.WORLD_SELECT -> new SelectWorldScreen((Screen)new TitleScreen());
            }), (Component)Component.literal((String)title), (Component)Component.literal((String)message));
            Minecraft.getInstance().setScreen((Screen)screen);
        });
        return true;
    }

    public boolean playSound(String soundID, String categoryName, float volume, float pitch, boolean repeat, int repeatDelay, String attenuationType, double x, double y, double z, boolean relative, boolean global) {
        Minecraft.getInstance().execute(() -> {
            SoundInstance.Attenuation attenuation;
            SoundSource category;
            ResourceLocation sound = ResourceLocation.tryParse((String)soundID);
            if (sound == null) {
                LOGGER.info("Invalid sound ResourceLocation");
                return;
            }
            try {
                category = SoundSource.valueOf((String)categoryName.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                category = SoundSource.MASTER;
            }
            try {
                attenuation = SoundInstance.Attenuation.valueOf((String)attenuationType.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                attenuation = SoundInstance.Attenuation.NONE;
            }
            double trueX = x;
            double trueY = y;
            double trueZ = z;
            if (relative && Minecraft.getInstance().level != null && Minecraft.getInstance().player != null) {
                trueX += Minecraft.getInstance().player.getX();
                trueY += Minecraft.getInstance().player.getY();
                trueZ += Minecraft.getInstance().player.getZ();
            }
            Minecraft.getInstance().getSoundManager().play((SoundInstance)new SimpleSoundInstance(sound, category, volume, pitch, randomSource, repeat, repeatDelay, attenuation, trueX, trueY, trueZ, global));
        });
        return true;
    }

    public void showTrustPrompt(Device device) {
        Minecraft.getInstance().execute(() -> {
            ConfirmScreen screen = new ConfirmScreen((BooleanConsumer)new EffectMCCore.TrustBooleanConsumer(device, this.core), (Component)Component.literal((String)"EffectMC - Trust Prompt"), (Component)Component.literal((String)("Do you want to trust this device?\n(Type: " + String.valueOf(device.getType()) + (String)(device.getType() == DeviceType.OTHER ? " Device Id:" + device.getId() : "") + ")")));
            Minecraft.getInstance().setScreen((Screen)screen);
        });
    }

    public void resetScreen() {
        Minecraft.getInstance().execute(() -> Minecraft.getInstance().setScreen(null));
    }

    public boolean stopSound(String sound, String categoryName) {
        Minecraft.getInstance().execute(() -> {
            ResourceLocation location = sound == null ? null : ResourceLocation.tryParse((String)sound);
            SoundSource category = null;
            try {
                category = SoundSource.valueOf((String)categoryName);
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {
                // empty catch block
            }
            Minecraft.getInstance().getSoundManager().stop(location, category);
        });
        return true;
    }

    public boolean showToast(String title, String subtitle) {
        Minecraft.getInstance().execute(() -> Minecraft.getInstance().getToastManager().addToast((Toast)new SystemToast(SystemToast.SystemToastId.NARRATOR_TOGGLE, (Component)Component.literal((String)title), (Component)Component.literal((String)subtitle))));
        return true;
    }

    public boolean showItemToast(String itemData, String title, String subtitle) {
        Minecraft.getInstance().execute(() -> Minecraft.getInstance().getToastManager().addToast((Toast)new ItemToast(itemData, (Component)Component.literal((String)title), (Component)Component.literal((String)subtitle), this.core)));
        return true;
    }

    public boolean openBook(JsonObject bookJSON) {
        Minecraft.getInstance().execute(() -> {
            DataResult dataResult = WrittenBookContent.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)bookJSON);
            if (dataResult.isError()) {
                if (dataResult.error().isPresent()) {
                    LOGGER.error("Error decoding book JSON: " + ((DataResult.Error)dataResult.error().get()).message());
                } else {
                    LOGGER.error("Error decoding book JSON: Unknown error.");
                }
                return;
            }
            if (dataResult.result().isEmpty()) {
                LOGGER.error("No result from decoding book JSON.");
                return;
            }
            ItemStack bookStack = new ItemStack((ItemLike)Items.WRITTEN_BOOK);
            bookStack.set(DataComponents.WRITTEN_BOOK_CONTENT, (Object)((WrittenBookContent)((Pair)dataResult.result().get()).getFirst()));
            BookViewScreen.BookAccess bookInfo = BookViewScreen.BookAccess.fromItem((ItemStack)bookStack);
            BookViewScreen screen = new BookViewScreen(bookInfo);
            Minecraft.getInstance().setScreen((Screen)screen);
        });
        return true;
    }

    public boolean narrate(String message, boolean interrupt) {
        if (narrator.active()) {
            Minecraft.getInstance().execute(() -> narrator.say(message, interrupt, 1.0f));
            return true;
        }
        LOGGER.error("Narrator is unavailable!");
        return false;
    }

    public boolean loadWorld(String worldName) {
        Minecraft.getInstance().execute(() -> {
            if (Minecraft.getInstance().getLevelSource().levelExists(worldName)) {
                this.leaveIfNeeded();
                LOGGER.info("Loading world...");
                Minecraft.getInstance().createWorldOpenFlows().openWorld(worldName, () -> {
                    LOGGER.info("World load cancelled!");
                    Minecraft.getInstance().setScreen((Screen)new TitleScreen());
                });
            } else {
                LOGGER.warn("World " + worldName + " does not exist!");
            }
        });
        return true;
    }

    public boolean setSkin(URL skinUrl, SetSkinEffect.SKIN_TYPE skinType) {
        if (skinUrl == null) {
            LOGGER.warn("Skin URL is null!");
            return false;
        }
        try {
            JsonObject payload = new JsonObject();
            payload.add("variant", (JsonElement)new JsonPrimitive(skinType.getValue()));
            payload.add("url", (JsonElement)new JsonPrimitive(skinUrl.toString()));
            HttpPost request = new HttpPost("https://api.minecraftservices.com/minecraft/profile/skins");
            request.setEntity((HttpEntity)new StringEntity(payload.toString(), ContentType.APPLICATION_JSON));
            HttpResponse response = this.authedClient.execute((HttpUriRequest)request);
            if (response.getEntity() != null && response.getEntity().getContentLength() > 0L) {
                JsonObject responseJSON = this.core.fromJson(IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8));
                if (responseJSON.has("errorMessage")) {
                    LOGGER.warn("Failed to update skin! " + String.valueOf(responseJSON));
                    return false;
                }
                LOGGER.debug("Skin Update Response: " + String.valueOf(responseJSON));
            }
            LOGGER.info("Skin updated!");
            return true;
        }
        catch (IOException e) {
            LOGGER.warn("Failed to update skin!", (Throwable)e);
            return false;
        }
    }

    public void leaveIfNeeded() {
        if (Minecraft.getInstance().level != null) {
            LOGGER.info("Disconnecting from world...");
            Minecraft.getInstance().level.disconnect((Component)Component.literal((String)"Loading new world..."));
            Minecraft.getInstance().disconnect((Screen)new BlankScreen(), false);
        }
    }

    public boolean openScreen(OpenScreenEffect.SCREEN screen) {
        Minecraft.getInstance().execute(() -> {
            this.leaveIfNeeded();
            switch (screen) {
                case MAIN_MENU: {
                    Minecraft.getInstance().setScreen((Screen)new TitleScreen());
                    break;
                }
                case SERVER_SELECT: {
                    Minecraft.getInstance().setScreen((Screen)new JoinMultiplayerScreen((Screen)new TitleScreen()));
                    break;
                }
                case SERVER_DIRECT_CONNECT: {
                    Minecraft.getInstance().setScreen((Screen)new DirectJoinServerScreen((Screen)new JoinMultiplayerScreen((Screen)new TitleScreen()), this::connectIfTrue, serverData));
                    break;
                }
                case WORLD_SELECT: {
                    Minecraft.getInstance().setScreen((Screen)new SelectWorldScreen((Screen)new TitleScreen()));
                    break;
                }
                case WORLD_CREATE: {
                    CreateWorldScreen.openFresh((Minecraft)Minecraft.getInstance(), () -> Minecraft.getInstance().setScreen((Screen)new SelectWorldScreen((Screen)new TitleScreen())));
                    break;
                }
                default: {
                    LOGGER.error("Unknown screen.");
                }
            }
        });
        return true;
    }

    public boolean setFOV(int fov) {
        Minecraft.getInstance().execute(() -> Minecraft.getInstance().options.fov().set((Object)fov));
        return true;
    }

    public boolean setPOV(SetPovEffect.POV pov) {
        Minecraft.getInstance().execute(() -> EffectMC.lambda$setPOV$21(switch (pov) {
            default -> CameraType.FIRST_PERSON;
            case SetPovEffect.POV.THIRD_PERSON_BACK -> CameraType.THIRD_PERSON_BACK;
            case SetPovEffect.POV.THIRD_PERSON_FRONT -> CameraType.THIRD_PERSON_FRONT;
        }));
        return true;
    }

    public boolean setGuiScale(int scale) {
        if (((Integer)Minecraft.getInstance().options.guiScale().get()).equals(scale)) {
            return true;
        }
        Minecraft.getInstance().execute(() -> {
            Minecraft.getInstance().options.guiScale().set((Object)scale);
            Minecraft.getInstance().options.save();
            Minecraft.getInstance().resizeDisplay();
        });
        return true;
    }

    public boolean setGamma(double gamma) {
        Minecraft.getInstance().execute(() -> {
            Minecraft.getInstance().options.gamma().set((Object)gamma);
            Minecraft.getInstance().options.save();
        });
        return true;
    }

    public boolean setChatVisibility(ChatVisibilityEffect.VISIBILITY visibility) {
        ChatVisiblity result;
        switch (visibility) {
            case SHOW: {
                result = ChatVisiblity.FULL;
                break;
            }
            case COMMANDS_ONLY: {
                result = ChatVisiblity.SYSTEM;
                break;
            }
            case HIDE: {
                result = ChatVisiblity.HIDDEN;
                break;
            }
            default: {
                return false;
            }
        }
        Minecraft.getInstance().execute(() -> {
            Minecraft.getInstance().options.chatVisibility().set((Object)result);
            Minecraft.getInstance().options.save();
        });
        return true;
    }

    public boolean setRenderDistance(int chunks) {
        Minecraft.getInstance().execute(() -> {
            Minecraft.getInstance().options.renderDistance().set((Object)chunks);
            Minecraft.getInstance().options.save();
        });
        return true;
    }

    public WorldState getWorldState() {
        if (Minecraft.getInstance().level == null) {
            return WorldState.OTHER;
        }
        return Minecraft.getInstance().isLocalServer() ? WorldState.SINGLEPLAYER : WorldState.MULTIPLAYER;
    }

    public String getSPWorldName() {
        if (this.getWorldState() != WorldState.SINGLEPLAYER) {
            return null;
        }
        IntegratedServer server = Minecraft.getInstance().getSingleplayerServer();
        if (server != null) {
            return server.getWorldData().getLevelName();
        }
        LOGGER.info("Attempted to get SP World Name, but no integrated server was found!");
        return null;
    }

    public String getServerIP() {
        if (this.getWorldState() != WorldState.MULTIPLAYER) {
            return null;
        }
        if (Minecraft.getInstance().getCurrentServer() != null) {
            return Minecraft.getInstance().getCurrentServer().ip;
        }
        LOGGER.info("Failed to get Server IP!");
        return null;
    }

    public void setVolume(SetVolumeEffect.VOLUME_CATEGORIES category, int volume) {
        Minecraft.getInstance().execute(() -> {
            SoundSource mcSoundSource;
            switch (category) {
                case MASTER: {
                    mcSoundSource = SoundSource.MASTER;
                    break;
                }
                case MUSIC: {
                    mcSoundSource = SoundSource.MUSIC;
                    break;
                }
                case RECORDS: {
                    mcSoundSource = SoundSource.RECORDS;
                    break;
                }
                case WEATHER: {
                    mcSoundSource = SoundSource.WEATHER;
                    break;
                }
                case BLOCKS: {
                    mcSoundSource = SoundSource.BLOCKS;
                    break;
                }
                case HOSTILE: {
                    mcSoundSource = SoundSource.HOSTILE;
                    break;
                }
                case NEUTRAL: {
                    mcSoundSource = SoundSource.NEUTRAL;
                    break;
                }
                case PLAYERS: {
                    mcSoundSource = SoundSource.PLAYERS;
                    break;
                }
                case AMBIENT: {
                    mcSoundSource = SoundSource.AMBIENT;
                    break;
                }
                case VOICE: {
                    mcSoundSource = SoundSource.VOICE;
                    break;
                }
                default: {
                    LOGGER.error("Unknown volume category!");
                    return;
                }
            }
            Minecraft.getInstance().options.getSoundSourceOptionInstance(mcSoundSource).set((Object)((double)volume / 100.0));
            Minecraft.getInstance().options.save();
        });
    }

    private void connectIfTrue(boolean connect) {
        if (connect) {
            this.joinServer(EffectMC.serverData.ip);
        } else {
            Minecraft.getInstance().setScreen((Screen)new JoinMultiplayerScreen((Screen)new TitleScreen()));
        }
    }

    private static /* synthetic */ void lambda$setPOV$21(CameraType mcPov) {
        Minecraft.getInstance().options.setCameraType(mcPov);
    }
}

