/*
 * Decompiled with CFR 0.152.
 */
package com.mosadie.effectmc;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mosadie.effectmc.EffectMC;
import com.mosadie.effectmc.core.EffectMCCore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ItemToast
implements Toast {
    private static final ResourceLocation TEXTURE = ResourceLocation.withDefaultNamespace((String)"toast/recipe");
    private ItemStack item;
    private Component title;
    private Component body;
    private long lastChanged;
    private boolean changed = true;
    private Toast.Visibility visibility = Toast.Visibility.HIDE;

    public ItemToast(String itemData, Component title, Component body, EffectMCCore core) {
        if (Minecraft.getInstance().level == null) {
            EffectMC.LOGGER.warn("Error decoding item data: No level");
            this.item = new ItemStack((ItemLike)Items.AIR);
            this.title = title;
            this.body = body;
            return;
        }
        DataResult dataResult = ItemStack.CODEC.decode((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()), (Object)core.fromJson(itemData));
        if (dataResult.error().isPresent()) {
            EffectMC.LOGGER.warn("Error decoding item data: " + String.valueOf(dataResult.error().get()));
            this.item = new ItemStack((ItemLike)Items.AIR);
        } else if (dataResult.result().isPresent()) {
            this.item = (ItemStack)((Pair)dataResult.result().get()).getFirst();
        } else {
            EffectMC.LOGGER.warn("Error decoding item data: No item data");
            this.item = new ItemStack((ItemLike)Items.AIR);
        }
        this.title = title;
        this.body = body;
    }

    public Toast.Visibility getWantedVisibility() {
        return this.visibility;
    }

    public void update(ToastManager toastManager, long time) {
        if (this.changed) {
            this.lastChanged = time;
            this.changed = false;
        }
        this.visibility = (double)(time - this.lastChanged) >= 5000.0 * toastManager.getNotificationDisplayTimeMultiplier() ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }

    public void render(GuiGraphics guiGraphics, Font font, long time) {
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, TEXTURE, 0, 0, this.width(), this.height());
        guiGraphics.drawString(font, this.title, 30, 7, -16777216, false);
        guiGraphics.drawString(font, this.body, 30, 18, -16777216, false);
        guiGraphics.renderFakeItem(this.item, 8, 8);
    }
}

