/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.frozenhappyghast.mixin;

import com.blackgear.vanillabackport.common.level.entities.happyghast.HappyGhast;
import com.cerbon.frozenhappyghast.particle.FHGParticles;
import com.cerbon.frozenhappyghast.util.mixin.IHappyGhastMixin;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HappyGhast.class})
public abstract class HappyGhastMixin
extends Animal
implements IHappyGhastMixin {
    @Unique
    private boolean fhg$isFrozen = false;
    @Unique
    private float fhg$xRotFrozen = 0.0f;
    @Unique
    private float fhg$yRotFrozen = 0.0f;
    @Unique
    private String fhg$isFrozenTag = "fhg_isFrozen";
    @Unique
    private String fhg$xRotFrozenTag = "fhg_xRotFrozen";
    @Unique
    private String fhg$yRotFrozenTag = "fhg_yRotFrozen";
    @Unique
    private static final EntityDataAccessor<Boolean> FHG_IS_FROZEN = SynchedEntityData.m_135353_(HappyGhast.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    protected HappyGhastMixin(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void fhg$defineSynchedData(CallbackInfo ci) {
        this.f_19804_.m_135372_(FHG_IS_FROZEN, (Object)false);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void fhg$saveAdditional(CompoundTag tag, CallbackInfo ci) {
        tag.m_128379_(this.fhg$isFrozenTag, this.fhg$isFrozen);
        tag.m_128350_(this.fhg$xRotFrozenTag, this.fhg$xRotFrozen);
        tag.m_128350_(this.fhg$yRotFrozenTag, this.fhg$yRotFrozen);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void fhg$readAdditional(CompoundTag tag, CallbackInfo ci) {
        if (tag.m_128441_(this.fhg$isFrozenTag)) {
            this.fhg$isFrozen = tag.m_128471_(this.fhg$isFrozenTag);
        }
        if (tag.m_128441_(this.fhg$xRotFrozenTag)) {
            this.fhg$xRotFrozen = tag.m_128457_(this.fhg$xRotFrozenTag);
        }
        if (tag.m_128441_(this.fhg$yRotFrozenTag)) {
            this.fhg$yRotFrozen = tag.m_128457_(this.fhg$yRotFrozenTag);
        }
        ((HappyGhast)this).m_20088_().m_135381_(FHG_IS_FROZEN, (Object)this.fhg$isFrozen);
    }

    @WrapOperation(method={"isOnStillTimeout"}, at={@At(value="INVOKE", target="Lcom/blackgear/vanillabackport/common/level/entities/happyghast/HappyGhast;staysStill()Z")})
    private boolean fhg$isOnStillTimeout(HappyGhast instance, Operation<Boolean> original) {
        if (this.fhg$isFrozen()) {
            return true;
        }
        return (Boolean)original.call(new Object[]{instance});
    }

    @Inject(method={"travel"}, at={@At(value="HEAD")}, cancellable=true)
    private void fhg$travel(Vec3 travelVector, CallbackInfo ci) {
        if (this.fhg$isFrozen()) {
            this.m_20256_(Vec3.f_82478_);
            ci.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void fhg$tick(CallbackInfo ci) {
        if (this.fhg$isFrozen()) {
            Level level;
            if (this.m_6162_()) {
                this.m_146922_(this.fhg$yRotFrozen);
                this.m_5616_(this.fhg$yRotFrozen);
                this.m_146926_(this.fhg$xRotFrozen);
                this.f_19859_ = this.m_146908_();
                this.f_19860_ = this.m_146909_();
            }
            if (this.m_9236_().m_46467_() % 80L == 0L && (level = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.fhg$spawnFrozenParticles(serverLevel);
            }
        }
    }

    @Unique
    private void fhg$spawnFrozenParticles(ServerLevel level) {
        double entityWidth = this.m_20205_();
        double entityHeight = this.m_20206_();
        int particleCount = !this.m_6162_() ? 8 + this.f_19796_.m_188503_(5) : 2 + this.f_19796_.m_188503_(2);
        for (int i = 0; i < particleCount; ++i) {
            double offsetY;
            double offsetZ;
            double offsetX;
            if (this.f_19796_.m_188501_() < 0.7f) {
                int side = this.f_19796_.m_188503_(4);
                switch (side) {
                    case 0: {
                        offsetX = -(entityWidth / 2.0) - 0.1;
                        offsetZ = (double)(this.f_19796_.m_188501_() - 0.5f) * entityWidth;
                        break;
                    }
                    case 1: {
                        offsetX = entityWidth / 2.0 + 0.1;
                        offsetZ = (double)(this.f_19796_.m_188501_() - 0.5f) * entityWidth;
                        break;
                    }
                    case 2: {
                        offsetZ = -(entityWidth / 2.0) - 0.1;
                        offsetX = (double)(this.f_19796_.m_188501_() - 0.5f) * entityWidth;
                        break;
                    }
                    default: {
                        offsetZ = entityWidth / 2.0 + 0.1;
                        offsetX = (double)(this.f_19796_.m_188501_() - 0.5f) * entityWidth;
                    }
                }
                offsetY = (double)this.f_19796_.m_188501_() * (entityHeight * 0.3);
            } else {
                offsetX = (double)(this.f_19796_.m_188501_() - 0.5f) * entityWidth * 0.8;
                offsetY = -0.1;
                offsetZ = (double)(this.f_19796_.m_188501_() - 0.5f) * entityWidth * 0.8;
            }
            double particleX = this.m_20185_() + offsetX;
            double particleY = this.m_20186_() + offsetY;
            double particleZ = this.m_20189_() + offsetZ;
            level.m_8767_((ParticleOptions)FHGParticles.FROZEN_PARTICLE.get(), particleX, particleY, particleZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public boolean fhg$isFrozen() {
        return (Boolean)((HappyGhast)this).m_20088_().m_135370_(FHG_IS_FROZEN);
    }

    @Override
    public void fhg$setFrozen(boolean value) {
        this.fhg$isFrozen = value;
        this.fhg$xRotFrozen = this.m_146909_();
        this.fhg$yRotFrozen = this.m_146908_();
        ((HappyGhast)this).m_20088_().m_135381_(FHG_IS_FROZEN, (Object)value);
    }
}

