/*
 * Decompiled with CFR 0.152.
 */
package fuzs.vehicleupgrade.client.gui.components.debug;

import fuzs.vehicleupgrade.init.ModRegistry;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.debug.DebugScreenDisplayer;
import net.minecraft.client.gui.components.debug.DebugScreenEntry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;

public final class DebugEntryLookingAtAttributes
implements DebugScreenEntry {
    private static final ResourceLocation GROUP = ResourceLocation.withDefaultNamespace((String)"looking_at_entity");

    public void display(DebugScreenDisplayer displayer, @Nullable Level level, @Nullable LevelChunk clientChunk, @Nullable LevelChunk serverChunk) {
        Minecraft minecraft = Minecraft.getInstance();
        Entity entity = minecraft.crosshairPickEntity;
        ArrayList attributeLines = new ArrayList();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            BuiltInRegistries.ATTRIBUTE.listElements().forEach(holder -> {
                double attributeValue;
                if (holder.is(ModRegistry.DEBUG_ATTRIBUTES_ATTRIBUTE_TAG) && livingEntity.getAttributes().hasAttribute((Holder)holder) && (attributeValue = livingEntity.getAttributeValue((Holder)holder)) != ((Attribute)holder.value()).getDefaultValue()) {
                    double baseValue = livingEntity.getAttributeBaseValue((Holder)holder);
                    ChatFormatting chatFormatting = this.getValueFormatting(attributeValue, baseValue);
                    attributeLines.add(holder.getRegisteredName() + "=" + String.valueOf(chatFormatting) + "%.3f".formatted(attributeValue));
                }
            });
        }
        displayer.addToGroup(GROUP, attributeLines);
    }

    private ChatFormatting getValueFormatting(double attributeValue, double baseValue) {
        if (attributeValue > baseValue) {
            return ChatFormatting.GREEN;
        }
        if (attributeValue < baseValue) {
            return ChatFormatting.RED;
        }
        return ChatFormatting.RESET;
    }
}

