/*
 * Decompiled with CFR 0.152.
 */
package fuzs.vehicleupgrade.client.handler;

import fuzs.puzzleslib.api.client.key.v1.KeyMappingHelper;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.vehicleupgrade.VehicleUpgrade;
import fuzs.vehicleupgrade.config.ClientConfig;
import fuzs.vehicleupgrade.config.VehicleInventory;
import fuzs.vehicleupgrade.init.ModRegistry;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class OpenMountInventoryHandler {
    private static boolean skipCharacterType;
    private static CharacterEvent consumedCharacterEvent;

    public static void onStartClientTick(Minecraft minecraft) {
        ((ClientConfig)VehicleUpgrade.CONFIG.get(ClientConfig.class)).switchVehicleInventory.tick();
        if (OpenMountInventoryHandler.isServerControlledInventory((Player)minecraft.player)) {
            while (minecraft.options.keyInventory.consumeClick()) {
                VehicleInventory vehicleInventory = VehicleInventory.getInventory(minecraft.gameMode);
                VehicleInventory.trigger(vehicleInventory, minecraft, null, true);
            }
        }
    }

    public static EventResult onBeforeKeyPress(Screen screen, KeyEvent keyEvent) {
        if (OpenMountInventoryHandler.isServerControlledInventory((Player)screen.minecraft.player) && screen.minecraft.options.keyInventory.matches(keyEvent)) {
            VehicleInventory vehicleInventory;
            if (consumedCharacterEvent != null) {
                consumedCharacterEvent = null;
                ((ClientConfig)VehicleUpgrade.CONFIG.get(ClientConfig.class)).switchVehicleInventory.stop();
            }
            if (VehicleInventory.trigger(vehicleInventory = VehicleInventory.getInventory(screen), screen.minecraft, screen, false)) {
                skipCharacterType = true;
                return EventResult.INTERRUPT;
            }
        }
        return EventResult.PASS;
    }

    public static EventResult onBeforeCharacterType(Screen screen, CharacterEvent characterEvent) {
        if (KeyMappingHelper.matchesCodePoint((KeyMapping)screen.minecraft.options.keyInventory, (int)characterEvent.codepoint())) {
            consumedCharacterEvent = characterEvent;
            if (skipCharacterType) {
                skipCharacterType = false;
                return EventResult.INTERRUPT;
            }
        }
        return EventResult.PASS;
    }

    public static void onAfterCharacterType(Screen screen, CharacterEvent characterEvent) {
        consumedCharacterEvent = null;
    }

    public static void onRemove(Screen screen) {
        consumedCharacterEvent = null;
    }

    public static boolean isServerControlledInventory(@Nullable Player player) {
        if (player != null && player.isPassenger()) {
            Entity playerVehicle = player.getVehicle();
            return playerVehicle != null && (playerVehicle instanceof HasCustomInventoryScreen || playerVehicle.getType().is(ModRegistry.CUSTOM_EQUIPMENT_USER_ENTITY_TYPE_TAG));
        }
        return false;
    }
}

