/*
 * Decompiled with CFR 0.152.
 */
package fuzs.vehicleupgrade.config;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import fuzs.puzzleslib.api.network.v4.MessageSender;
import fuzs.puzzleslib.api.network.v4.message.Message;
import fuzs.vehicleupgrade.VehicleUpgrade;
import fuzs.vehicleupgrade.config.ClientConfig;
import fuzs.vehicleupgrade.config.InventorySwitch;
import fuzs.vehicleupgrade.init.ModRegistry;
import fuzs.vehicleupgrade.network.client.ServerboundOpenEquipmentInventoryMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public enum VehicleInventory {
    PLAYER{

        @Override
        public void openInventory(Minecraft minecraft, @Nullable Screen screen) {
            double xpos = minecraft.mouseHandler.xpos();
            double ypos = minecraft.mouseHandler.ypos();
            if (screen != null) {
                screen.onClose();
            }
            minecraft.setScreen((Screen)new InventoryScreen((Player)minecraft.player));
            if (screen != null && minecraft.screen != null) {
                minecraft.mouseHandler.xpos = xpos;
                minecraft.mouseHandler.ypos = ypos;
                InputConstants.grabOrReleaseMouse((Window)minecraft.getWindow(), (int)212993, (double)xpos, (double)ypos);
            }
        }

        @Override
        public VehicleInventory getOpposite() {
            return VEHICLE;
        }
    }
    ,
    VEHICLE{

        @Override
        public void openInventory(Minecraft minecraft, @Nullable Screen screen) {
            if (minecraft.player != null && minecraft.player.isPassenger()) {
                Entity playerVehicle = minecraft.player.getVehicle();
                if (playerVehicle instanceof HasCustomInventoryScreen) {
                    minecraft.player.sendOpenInventory();
                } else if (playerVehicle.getType().is(ModRegistry.CUSTOM_EQUIPMENT_USER_ENTITY_TYPE_TAG)) {
                    MessageSender.broadcast((Message)new ServerboundOpenEquipmentInventoryMessage(playerVehicle.getId()));
                }
            }
        }

        @Override
        public VehicleInventory getOpposite() {
            return PLAYER;
        }
    };


    public abstract void openInventory(Minecraft var1, @Nullable Screen var2);

    public abstract VehicleInventory getOpposite();

    public static boolean isPlayerInventory(Screen screen) {
        return screen instanceof InventoryScreen || screen instanceof CreativeModeInventoryScreen;
    }

    public static VehicleInventory getInventory(@Nullable MultiPlayerGameMode gameMode) {
        if (gameMode != null && gameMode.isServerControlledInventory()) {
            return ((ClientConfig)VehicleUpgrade.CONFIG.get(ClientConfig.class)).defaultVehicleInventory;
        }
        return PLAYER;
    }

    public static VehicleInventory getInventory(@Nullable Screen screen) {
        return VehicleInventory.isPlayerInventory(screen) ? PLAYER : VEHICLE;
    }

    public static boolean trigger(VehicleInventory vehicleInventory, Minecraft minecraft, @Nullable Screen screen, boolean openAlways) {
        InventorySwitch inventorySwitch = ((ClientConfig)VehicleUpgrade.CONFIG.get(ClientConfig.class)).switchVehicleInventory;
        boolean isActive = inventorySwitch.isActive();
        if (inventorySwitch.isActive()) {
            vehicleInventory = vehicleInventory.getOpposite();
        } else {
            inventorySwitch.reset();
        }
        if (openAlways || isActive) {
            vehicleInventory.openInventory(minecraft, screen);
            return true;
        }
        return false;
    }
}

