/*
 * Decompiled with CFR 0.152.
 */
package fuzs.vehicleupgrade.handler;

import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.vehicleupgrade.VehicleUpgrade;
import fuzs.vehicleupgrade.config.ServerConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class SwimmingMountHandler {
    public static EventResult onStartEntityTick(Entity entity) {
        if (!((ServerConfig)VehicleUpgrade.CONFIG.get(ServerConfig.class)).mountsSwimInWater) {
            return EventResult.PASS;
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (entity.dismountsUnderwater() && entity.isVehicle() && mob.isSaddled() && (entity.isInWater() && entity.getFluidHeight(FluidTags.WATER) > entity.getFluidJumpThreshold() || entity.isInLava()) && entity.getRandom().nextFloat() < 0.8f) {
                entity.setDeltaMovement(entity.getDeltaMovement().add(0.0, (double)0.04f, 0.0));
                if (entity instanceof AbstractHorse) {
                    AbstractHorse abstractHorse = (AbstractHorse)entity;
                    abstractHorse.playerJumpPendingScale = 0.0f;
                }
            }
        }
        return EventResult.PASS;
    }

    public static EventResult onStopRiding(Level level, Entity passengerEntity, Entity vehicleEntity) {
        if (!((ServerConfig)VehicleUpgrade.CONFIG.get(ServerConfig.class)).mountsSwimInWater) {
            return EventResult.PASS;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (vehicleEntity.dismountsUnderwater() && passengerEntity.isEyeInFluid(FluidTags.WATER) && !serverLevel.getBlockState(BlockPos.containing((double)passengerEntity.getX(), (double)passengerEntity.getEyeY(), (double)passengerEntity.getZ())).is(Blocks.BUBBLE_COLUMN)) {
                return EventResult.INTERRUPT;
            }
        }
        return EventResult.PASS;
    }
}

