/*
 * Decompiled with CFR 0.152.
 */
package fuzs.vehicleupgrade.world.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.level.block.Blocks;

public class HorseEatingGoal
extends Goal {
    private final AbstractHorse horse;
    private int eatingCounter;

    public HorseEatingGoal(AbstractHorse abstractHorse) {
        this.horse = abstractHorse;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void tick() {
        ++this.eatingCounter;
    }

    public void stop() {
        this.eatingCounter = 0;
        this.horse.setEating(false);
    }

    public void start() {
        this.horse.setEating(true);
    }

    public boolean canContinueToUse() {
        return this.horse.isEating() && this.eatingCounter <= this.adjustedTickDelay(50);
    }

    public boolean canUse() {
        if (this.horse.isEating()) {
            return true;
        }
        if (this.horse.canEatGrass()) {
            return !this.horse.isVehicle() && this.horse.getRandom().nextInt(90) == 0 && this.horse.level().getBlockState(this.horse.blockPosition().below()).is(Blocks.GRASS_BLOCK);
        }
        return false;
    }
}

