/*
 * Decompiled with CFR 0.152.
 */
package fuzs.vehicleupgrade.client.gui.screens.inventory;

import fuzs.vehicleupgrade.client.handler.EntityAttributesHandler;
import fuzs.vehicleupgrade.world.inventory.EquipmentInventoryMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class EquipmentInventoryScreen
extends AbstractContainerScreen<EquipmentInventoryMenu> {
    private static final ResourceLocation SLOT_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/slot");
    private static final ResourceLocation HORSE_INVENTORY_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/horse.png");
    private float xMouse;
    private float yMouse;

    public EquipmentInventoryScreen(EquipmentInventoryMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, HORSE_INVENTORY_LOCATION, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        for (Slot slot : ((EquipmentInventoryMenu)this.getMenu()).slots) {
            if (!slot.isActive() || slot.container instanceof Inventory) continue;
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, SLOT_SPRITE, this.leftPos + slot.x - 1, this.topPos + slot.y - 1, 18, 18);
        }
        Mob mob = ((EquipmentInventoryMenu)this.menu).getMob();
        EntityAttributesHandler.renderMobAttributes(this, guiGraphics, mob);
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)(this.leftPos + 26), (int)(this.topPos + 18), (int)(this.leftPos + 78), (int)(this.topPos + 70), (int)EquipmentInventoryScreen.getMobScale(mob.getBbWidth(), mob.getBbHeight()), (float)0.0625f, (float)this.xMouse, (float)this.yMouse, (LivingEntity)mob);
    }

    private static int getMobScale(float width, float height) {
        return Math.round(80.0f / (height + 1.5f * width));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.xMouse = mouseX;
        this.yMouse = mouseY;
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }
}

