/*
 * Decompiled with CFR 0.152.
 */
package fuzs.vehicleupgrade.client.handler;

import fuzs.puzzleslib.api.client.gui.v2.tooltip.TooltipBuilder;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.vehicleupgrade.VehicleUpgrade;
import fuzs.vehicleupgrade.client.handler.OpenMountInventoryHandler;
import fuzs.vehicleupgrade.config.ClientConfig;
import fuzs.vehicleupgrade.config.VehicleInventory;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class MountInventoryButtonHandler {
    public static final WidgetSprites CROSS_SPRITES = new WidgetSprites(VehicleUpgrade.id("container/inventory/cross"), VehicleUpgrade.id("container/inventory/cross_highlighted"));
    static final Component INVENTORY_COMPONENT = Component.translatable((String)"container.inventory");
    @Nullable
    private static Button playerInventoryButton;

    public static void onAfterInit(Minecraft minecraft, AbstractContainerScreen<?> screen, int screenWidth, int screenHeight, List<AbstractWidget> widgets, UnaryOperator<AbstractWidget> addWidget, Consumer<AbstractWidget> removeWidget) {
        if (minecraft.screen == screen && OpenMountInventoryHandler.isServerControlledInventory((Player)minecraft.player)) {
            Button vehicleInventoryButton;
            playerInventoryButton = MountInventoryButtonHandler.createPlayerInventoryButton(screen);
            MountInventoryButtonHandler.updatePlayerInventoryButtons(screen, playerInventoryButton);
            if (playerInventoryButton != null) {
                addWidget.apply((AbstractWidget)playerInventoryButton);
            }
            if ((vehicleInventoryButton = MountInventoryButtonHandler.createVehicleInventoryButton(screen)) != null) {
                addWidget.apply((AbstractWidget)vehicleInventoryButton);
            }
        }
    }

    @Nullable
    private static Button createPlayerInventoryButton(AbstractContainerScreen<?> screen) {
        Vector2i vector2i = MountInventoryButtonHandler.getButtonPositions(screen);
        Entity playerVehicle = screen.minecraft.player.getVehicle();
        if (vector2i != null && playerVehicle != null) {
            ImageButton button = new ImageButton(vector2i.x(), vector2i.y(), 13, 13, CROSS_SPRITES, buttonX -> VehicleInventory.VEHICLE.openInventory(screen.minecraft, (Screen)screen));
            TooltipBuilder.create((FormattedText[])new FormattedText[]{playerVehicle.getDisplayName()}).build((AbstractWidget)button);
            return button;
        }
        return null;
    }

    @Nullable
    public static Vector2i getButtonPositions(AbstractContainerScreen<?> screen) {
        if (screen instanceof CreativeModeInventoryScreen) {
            return new Vector2i(screen.leftPos + screen.imageWidth - 13 - 7, screen.topPos + 3 + (MountInventoryButtonHandler.hasAdditionalPages(screen.minecraft) ? 14 : 0));
        }
        if (screen instanceof InventoryScreen) {
            return new Vector2i(screen.leftPos + screen.imageWidth - 13 - 7, screen.topPos + 3);
        }
        return null;
    }

    private static boolean hasAdditionalPages(Minecraft minecraft) {
        if (ModLoaderEnvironment.INSTANCE.getModLoader().isFabricLike()) {
            int tabs = minecraft.player.canUseGameMasterBlocks() && (Boolean)minecraft.options.operatorItemsTab().get() != false ? 14 : 13;
            return CreativeModeTabs.tabs().size() > tabs;
        }
        return false;
    }

    @Nullable
    private static Button createVehicleInventoryButton(AbstractContainerScreen<?> screen) {
        if (!((ClientConfig)VehicleUpgrade.CONFIG.get(ClientConfig.class)).vehicleInventoryButton) {
            return null;
        }
        if (!VehicleInventory.isPlayerInventory(screen)) {
            ImageButton button = new ImageButton(screen.leftPos + screen.imageWidth - 13 - 7, screen.topPos + 3, 13, 13, CROSS_SPRITES, buttonX -> VehicleInventory.PLAYER.openInventory(screen.minecraft, (Screen)screen));
            TooltipBuilder.create((FormattedText[])new FormattedText[]{INVENTORY_COMPONENT}).build((AbstractWidget)button);
            return button;
        }
        return null;
    }

    public static void onAfterMouseClick(AbstractContainerScreen<?> screen, double mouseX, double mouseY, int mouseButton) {
        MountInventoryButtonHandler.updatePlayerInventoryButtons(screen, playerInventoryButton);
    }

    public static void onAfterKeyPress(AbstractContainerScreen<?> screen, int keyCode, int scanCode, int modifiers) {
        MountInventoryButtonHandler.updatePlayerInventoryButtons(screen, playerInventoryButton);
    }

    public static void onAfterMouseRelease(AbstractContainerScreen<?> screen, double mouseX, double mouseY, int mouseButton) {
        MountInventoryButtonHandler.updatePlayerInventoryButtons(screen, playerInventoryButton);
    }

    private static void updatePlayerInventoryButtons(AbstractContainerScreen<?> screen, @Nullable Button button) {
        if (button != null) {
            if (screen instanceof InventoryScreen) {
                Vector2i vector2i = MountInventoryButtonHandler.getButtonPositions(screen);
                Objects.requireNonNull(vector2i, "button positions is null");
                button.setX(vector2i.x());
            }
            if (screen instanceof CreativeModeInventoryScreen) {
                CreativeModeInventoryScreen inventoryScreen = (CreativeModeInventoryScreen)screen;
                if (MountInventoryButtonHandler.hasAdditionalPages(screen.minecraft)) {
                    button.visible = inventoryScreen.isInventoryOpen();
                }
            }
        }
    }

    public static void onRemove(AbstractContainerScreen<?> screen) {
        if (VehicleInventory.isPlayerInventory(screen)) {
            playerInventoryButton = null;
        }
    }
}

