/*
 * Decompiled with CFR 0.152.
 */
package fuzs.vehicleupgrade.handler;

import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.vehicleupgrade.VehicleUpgrade;
import fuzs.vehicleupgrade.config.ServerConfig;
import fuzs.vehicleupgrade.init.ModRegistry;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DismountingRestrictionHandler {
    public static EventResult onEntityLoad(Entity entity, ServerLevel serverLevel, boolean isNewlySpawned) {
        if (!((ServerConfig)VehicleUpgrade.CONFIG.get(ServerConfig.class)).saddledMountsDoNotWander) {
            return EventResult.PASS;
        }
        if (entity instanceof PathfinderMob) {
            PathfinderMob mob = (PathfinderMob)entity;
            if (entity.getType().is(ModRegistry.RESTRICTED_MOUNTS_ENTITY_TYPE_TAG)) {
                for (WrappedGoal wrappedGoal : mob.goalSelector.getAvailableGoals()) {
                    Goal goal = wrappedGoal.getGoal();
                    if (!(goal instanceof RandomStrollGoal)) continue;
                    RandomStrollGoal goal2 = (RandomStrollGoal)goal;
                    mob.goalSelector.addGoal(wrappedGoal.getPriority() - 1, (Goal)new MoveTowardsRestrictionGoal(mob, goal2.speedModifier));
                    return EventResult.PASS;
                }
                mob.goalSelector.addGoal(5, (Goal)new MoveTowardsRestrictionGoal(mob, 1.0));
            }
        }
        return EventResult.PASS;
    }

    public static EventResult onStopRiding(Level level, Entity passengerEntity, Entity vehicleEntity) {
        PathfinderMob mob;
        if (!((ServerConfig)VehicleUpgrade.CONFIG.get(ServerConfig.class)).saddledMountsDoNotWander) {
            return EventResult.PASS;
        }
        if (passengerEntity instanceof Player && vehicleEntity instanceof PathfinderMob && (mob = (PathfinderMob)vehicleEntity).getType().is(ModRegistry.RESTRICTED_MOUNTS_ENTITY_TYPE_TAG)) {
            DismountingRestrictionHandler.setHomePosition((Mob)mob);
        }
        return EventResult.PASS;
    }

    public static void onLivingEquipmentChange(LivingEntity livingEntity, EquipmentSlot equipmentSlot, ItemStack oldItemStack, ItemStack newItemStack) {
        if (!((ServerConfig)VehicleUpgrade.CONFIG.get(ServerConfig.class)).saddledMountsDoNotWander) {
            return;
        }
        if (equipmentSlot == EquipmentSlot.SADDLE && livingEntity instanceof PathfinderMob) {
            PathfinderMob mob = (PathfinderMob)livingEntity;
            if (livingEntity.getType().is(ModRegistry.RESTRICTED_MOUNTS_ENTITY_TYPE_TAG)) {
                DismountingRestrictionHandler.setHomePosition((Mob)mob);
            }
        }
    }

    private static void setHomePosition(Mob mob) {
        if (mob.isSaddled()) {
            mob.setHomeTo(mob.blockPosition(), (int)(mob.leashElasticDistance() - 1.0));
            mob.getNavigation().stop();
        } else {
            mob.clearHome();
        }
    }
}

