/*
 * Decompiled with CFR 0.152.
 */
package fuzs.vehicleupgrade.handler;

import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.vehicleupgrade.VehicleUpgrade;
import fuzs.vehicleupgrade.config.ServerConfig;
import fuzs.vehicleupgrade.init.ModRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.level.Level;

public class OverSizedBoatPassengersHandler {
    public static EventResultHolder<EntityDimensions> onChangeEntitySize(Entity entity, Pose pose, EntityDimensions entityDimensions) {
        if (!((ServerConfig)VehicleUpgrade.CONFIG.get(ServerConfig.class)).shrinkOverSizedBoatPassengers) {
            return EventResultHolder.pass();
        }
        if (entity.getVehicle() instanceof AbstractBoat && entity.getType().is(ModRegistry.OVER_SIZED_BOAT_PASSENGERS_ENTITY_TYPE_TAG)) {
            return EventResultHolder.interrupt((Object)entityDimensions.scale(Math.min(0.875f / entityDimensions.width(), 1.0f), 1.0f));
        }
        return EventResultHolder.pass();
    }

    public static EventResult onStartRiding(Level level, Entity passengerEntity, Entity vehicleEntity) {
        return OverSizedBoatPassengersHandler.onRiding(level, passengerEntity, vehicleEntity);
    }

    public static EventResult onStopRiding(Level level, Entity passengerEntity, Entity vehicleEntity) {
        return OverSizedBoatPassengersHandler.onRiding(level, passengerEntity, vehicleEntity);
    }

    private static EventResult onRiding(Level level, Entity passengerEntity, Entity vehicleEntity) {
        if (!((ServerConfig)VehicleUpgrade.CONFIG.get(ServerConfig.class)).shrinkOverSizedBoatPassengers) {
            return EventResult.PASS;
        }
        if (vehicleEntity instanceof AbstractBoat && passengerEntity.getType().is(ModRegistry.OVER_SIZED_BOAT_PASSENGERS_ENTITY_TYPE_TAG)) {
            BlockableEventLoop<? super TickTask> blockableEventLoop = OverSizedBoatPassengersHandler.getBlockableEventLoop(level);
            blockableEventLoop.schedule((Runnable)new TickTask(0, () -> ((Entity)passengerEntity).refreshDimensions()));
        }
        return EventResult.PASS;
    }

    @Deprecated
    private static BlockableEventLoop<? super TickTask> getBlockableEventLoop(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.getServer();
        }
        return Minecraft.getInstance();
    }
}

