/*
 * Decompiled with CFR 0.152.
 */
package fuzs.vehicleupgrade.mixin;

import fuzs.vehicleupgrade.VehicleUpgrade;
import fuzs.vehicleupgrade.config.BoatJumping;
import fuzs.vehicleupgrade.config.ServerConfig;
import fuzs.vehicleupgrade.init.ModRegistry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractBoat.class})
abstract class AbstractBoatMixin
extends VehicleEntity
implements PlayerRideableJumping {
    @Shadow
    private AbstractBoat.Status status;

    public AbstractBoatMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public void onPlayerJump(int jumpPower) {
        if (this.onGround() || ((ServerConfig)VehicleUpgrade.CONFIG.get(ServerConfig.class)).jumpInBoats == BoatJumping.ALWAYS) {
            float playerJumpScale = jumpPower >= 90 ? 1.0f : 0.4f + 0.4f * Math.max((float)jumpPower, 0.0f) / 90.0f;
            this.hasImpulse = true;
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)playerJumpScale * 0.325, 0.0));
        }
    }

    public boolean canJump() {
        return ((ServerConfig)VehicleUpgrade.CONFIG.get(ServerConfig.class)).jumpInBoats.canJump(this.status);
    }

    public void handleStartJump(int jumpPower) {
    }

    public void handleStopJump() {
    }

    public float maxUpStep() {
        if (!((ServerConfig)VehicleUpgrade.CONFIG.get(ServerConfig.class)).increaseBoatStepHeight) {
            return super.maxUpStep();
        }
        return BoatJumping.ON_LAND.canJump(this.status) ? 0.15f : super.maxUpStep();
    }

    @Inject(method={"hasEnoughSpaceFor"}, at={@At(value="HEAD")}, cancellable=true)
    public void hasEnoughSpaceFor(Entity entity, CallbackInfoReturnable<Boolean> callback) {
        if (!((ServerConfig)VehicleUpgrade.CONFIG.get(ServerConfig.class)).shrinkOverSizedBoatPassengers) {
            return;
        }
        if (entity.getType().is(ModRegistry.OVER_SIZED_BOAT_PASSENGERS_ENTITY_TYPE_TAG)) {
            callback.setReturnValue((Object)true);
        }
    }
}

