/*
 * Decompiled with CFR 0.152.
 */
package fuzs.vehicleupgrade.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import fuzs.vehicleupgrade.VehicleUpgrade;
import fuzs.vehicleupgrade.config.ServerConfig;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={Entity.class})
abstract class EntityMixin
implements EntityAccess {
    EntityMixin() {
    }

    @ModifyReturnValue(method={"collide"}, at={@At(value="RETURN", ordinal=0)})
    private Vec3 collide$0(Vec3 stepUpVector, @Local(ordinal=1) Vec3 collideVector) {
        if (!((ServerConfig)VehicleUpgrade.CONFIG.get(ServerConfig.class)).correctPassengerCollisions) {
            return stepUpVector;
        }
        if (this.isVehicle()) {
            double minY = this.getBoundingBox().minY;
            for (Entity entity : this.getPassengers()) {
                Vec3 vec3;
                AABB aABB = entity.getBoundingBox().setMinY(minY);
                List list = entity.level().getEntityCollisions(entity, aABB.expandTowards(stepUpVector));
                Vec3 vec32 = vec3 = stepUpVector.lengthSqr() == 0.0 ? stepUpVector : Entity.collideBoundingBox((Entity)entity, (Vec3)stepUpVector, (AABB)aABB, (Level)entity.level(), (List)list);
                if (vec3.y() != stepUpVector.y()) {
                    return collideVector;
                }
                if (vec3.x() != stepUpVector.x()) {
                    vec3 = new Vec3(collideVector.x(), vec3.y(), vec3.z());
                }
                if (vec3.z() != stepUpVector.z()) {
                    vec3 = new Vec3(vec3.x(), vec3.y(), collideVector.z());
                }
                stepUpVector = vec3;
            }
        }
        return stepUpVector;
    }

    @ModifyReturnValue(method={"collide"}, at={@At(value="RETURN")})
    private Vec3 collide$1(Vec3 vec3) {
        if (!((ServerConfig)VehicleUpgrade.CONFIG.get(ServerConfig.class)).correctPassengerCollisions) {
            return vec3;
        }
        if (this.isVehicle()) {
            double minY = this.getBoundingBox().minY;
            for (Entity entity : this.getPassengers()) {
                AABB aABB = entity.getBoundingBox().setMinY(minY);
                List list = entity.level().getEntityCollisions(entity, aABB.expandTowards(vec3));
                vec3 = vec3.lengthSqr() == 0.0 ? vec3 : Entity.collideBoundingBox((Entity)entity, (Vec3)vec3, (AABB)aABB, (Level)entity.level(), (List)list);
            }
        }
        return vec3;
    }

    @Shadow
    public abstract boolean isVehicle();

    @Shadow
    public final List<Entity> getPassengers() {
        throw new RuntimeException();
    }
}

