/*
 * Decompiled with CFR 0.152.
 */
package fuzs.vehicleupgrade.handler;

import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.util.v1.CommonHelper;
import fuzs.vehicleupgrade.VehicleUpgrade;
import fuzs.vehicleupgrade.config.LeavesMountCollisions;
import fuzs.vehicleupgrade.config.ServerConfig;
import fuzs.vehicleupgrade.init.ModRegistry;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_8836;
import org.jetbrains.annotations.Nullable;

public class VehicleUpgradeHandler {
    public static EventResultHolder<class_1269> onUseEntity(class_1657 player, class_1937 level, class_1268 interactionHand, class_1297 entity) {
        if (!((ServerConfig)VehicleUpgrade.CONFIG.get(ServerConfig.class)).manuallyDismountPassengers) {
            return EventResultHolder.pass();
        }
        if (player.method_21823() && player.method_5998(interactionHand).method_7960() && entity.method_5765() && !(entity instanceof class_1657) && entity.method_5854() instanceof class_8836) {
            entity.method_5848();
            if (entity instanceof class_1308) {
                class_1308 mob = (class_1308)entity;
                mob.method_5942().method_6340();
            }
            return EventResultHolder.interrupt((Object)class_1269.field_5812);
        }
        return EventResultHolder.pass();
    }

    public static EventResult onStartRiding(class_1937 level, class_1297 passengerEntity, class_1297 vehicleEntity) {
        if (!((ServerConfig)VehicleUpgrade.CONFIG.get(ServerConfig.class)).rotateVehicleWithPlayer) {
            return EventResult.PASS;
        }
        if (!vehicleEntity.method_42148() && passengerEntity instanceof class_1657) {
            class_1657 player = (class_1657)passengerEntity;
            vehicleEntity.method_36456(player.method_36454());
            vehicleEntity.field_5982 = player.method_36454();
            if (vehicleEntity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)vehicleEntity;
                livingEntity.field_6283 = livingEntity.field_6220 = player.field_6283;
                livingEntity.field_6241 = livingEntity.field_6259 = player.field_6241;
            }
        }
        return EventResult.PASS;
    }

    public static Optional<class_265> getRidingTraversableShape(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
        class_3727 context;
        if (collisionContext instanceof class_3727 && VehicleUpgradeHandler.isRidingTraversable(blockState, (context = (class_3727)collisionContext).method_32480()) && (((ServerConfig)VehicleUpgrade.CONFIG.get(ServerConfig.class)).mountsPassThroughLeaves == LeavesMountCollisions.ALWAYS || VehicleUpgradeHandler.isTraversableAtHeight(blockGetter, blockPos, context))) {
            return Optional.of(class_259.method_1073());
        }
        return Optional.empty();
    }

    public static boolean isRidingTraversable(class_2680 blockState, @Nullable class_1297 entity) {
        if (CommonHelper.getMinecraftServer() == null || ((ServerConfig)VehicleUpgrade.CONFIG.get(ServerConfig.class)).mountsPassThroughLeaves == LeavesMountCollisions.VANILLA) {
            return false;
        }
        if (blockState.method_26164(ModRegistry.RIDING_TRAVERSABLE_BLOCK_TAG)) {
            return VehicleUpgradeHandler.getTraversableEntity(entity) != null;
        }
        return false;
    }

    private static boolean isTraversableAtHeight(class_1922 blockGetter, class_2338 blockPos, class_3727 context) {
        class_1297 vehicleEntity = VehicleUpgradeHandler.getTraversableEntity(context.method_32480());
        if (vehicleEntity == null) {
            return false;
        }
        if (blockPos.method_10264() <= vehicleEntity.method_31478()) {
            return false;
        }
        if (blockPos.method_10264() > vehicleEntity.method_31478() + 1) {
            return true;
        }
        class_2338 bottomPosition = blockPos.method_33096(vehicleEntity.method_31478());
        if (Objects.equals(blockPos, bottomPosition)) {
            return false;
        }
        return blockGetter.method_8320(bottomPosition).method_26194(blockGetter, bottomPosition, (class_3726)context).method_1110();
    }

    @Nullable
    private static class_1297 getTraversableEntity(@Nullable class_1297 entity) {
        if (entity != null) {
            if (entity.method_42148() && entity.method_5864().method_20210(ModRegistry.TRAVERSABLE_MOUNTS_ENTITY_TYPE_TAG)) {
                return entity;
            }
            if (entity.method_5765() && entity.method_5854().method_5864().method_20210(ModRegistry.TRAVERSABLE_MOUNTS_ENTITY_TYPE_TAG)) {
                return entity.method_5854();
            }
        }
        return null;
    }
}

