/*
 * Decompiled with CFR 0.152.
 */
package fuzs.vehicleupgrade.client.handler;

import fuzs.vehicleupgrade.VehicleUpgrade;
import fuzs.vehicleupgrade.client.gui.components.RenderableComponent;
import fuzs.vehicleupgrade.config.ClientConfig;
import fuzs.vehicleupgrade.init.ModRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_465;
import net.minecraft.class_491;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class EntityAttributesHandler {
    static final String TARGETED_ENTITY_LINE = String.valueOf(class_124.field_1073) + "Targeted Entity";
    private static final class_2960 ARMOR_FULL_SPRITE = class_2960.method_60656((String)"hud/armor_full");
    private static final class_2960 HEART_VEHICLE_CONTAINER_SPRITE = class_2960.method_60656((String)"hud/heart/vehicle_container");
    private static final class_2960 HEART_VEHICLE_FULL_SPRITE = class_2960.method_60656((String)"hud/heart/vehicle_full");

    public static void onGatherSystemInformation(List<String> lines) {
        if (!((ClientConfig)VehicleUpgrade.CONFIG.get(ClientConfig.class)).debugEntityAttributes) {
            return;
        }
        class_1297 pickedEntity = class_310.method_1551().field_1692;
        if (pickedEntity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)pickedEntity;
            for (int i = lines.size() - 1; i >= 0; --i) {
                if (!lines.get(i).equals(TARGETED_ENTITY_LINE)) continue;
                if ((i += 2) > lines.size()) break;
                ArrayList attributeLines = new ArrayList();
                class_7923.field_41190.method_42017().forEach(holder -> {
                    double attributeValue;
                    if (holder.method_40220(ModRegistry.DEBUG_ATTRIBUTES_ATTRIBUTE_TAG) && livingEntity.method_6127().method_45331((class_6880)holder) && (attributeValue = livingEntity.method_45325((class_6880)holder)) != ((class_1320)holder.comp_349()).method_6169()) {
                        double baseValue = livingEntity.method_45326((class_6880)holder);
                        class_124 chatFormatting = EntityAttributesHandler.getValueFormatting(attributeValue, baseValue);
                        attributeLines.add(holder.method_55840() + "=" + String.valueOf(chatFormatting) + "%.3f".formatted(attributeValue));
                    }
                });
                lines.addAll(i, attributeLines);
                break;
            }
        }
    }

    private static class_124 getValueFormatting(double attributeValue, double baseValue) {
        if (attributeValue > baseValue) {
            return class_124.field_1060;
        }
        if (attributeValue < baseValue) {
            return class_124.field_1061;
        }
        return class_124.field_1070;
    }

    public static void onDrawBackground(class_465<?> screen, class_332 guiGraphics, int mouseX, int mouseY) {
        if (screen instanceof class_491) {
            class_491 horseInventoryScreen = (class_491)screen;
            if (horseInventoryScreen.field_2941.method_6702() == 0) {
                EntityAttributesHandler.renderMobAttributes(screen, guiGraphics, (class_1308)horseInventoryScreen.field_2941);
            }
        }
    }

    public static void renderMobAttributes(class_465<?> screen, class_332 guiGraphics, class_1308 mob) {
        if (!((ClientConfig)VehicleUpgrade.CONFIG.get(ClientConfig.class)).mobAttributesInInventory) {
            return;
        }
        EntityAttributesHandler.renderMobAttribute(guiGraphics, screen.method_64506(), class_3532.method_15386((float)mob.method_6032()), class_3532.method_15386((float)mob.method_6063()), screen.field_2776 + 124, screen.field_2800 + 32, HEART_VEHICLE_FULL_SPRITE, HEART_VEHICLE_CONTAINER_SPRITE);
        EntityAttributesHandler.renderMobAttribute(guiGraphics, screen.method_64506(), mob.method_6096(), -1, screen.field_2776 + 124, screen.field_2800 + 48, ARMOR_FULL_SPRITE, null);
    }

    private static void renderMobAttribute(class_332 guiGraphics, class_327 font, int value, int maxValue, int posX, int posY, class_2960 fullSprite, @Nullable class_2960 emptySprite) {
        if (value > 0) {
            ArrayList<RenderableComponent> list = new ArrayList<RenderableComponent>();
            list.add(RenderableComponent.ofText((class_2561)class_2561.method_43470((String)(value + "x"))));
            list.add(RenderableComponent.ofSprite(fullSprite, emptySprite, 9, 12));
            if (maxValue != -1) {
                list.add(RenderableComponent.ofText((class_2561)class_2561.method_43470((String)"/")));
                list.add(RenderableComponent.ofText((class_2561)class_2561.method_43470((String)(maxValue + "x"))));
                list.add(RenderableComponent.ofSprite(fullSprite, emptySprite, 9, 12));
            }
            RenderableComponent.renderComponents(guiGraphics, font, posX, posY, list);
        }
    }
}

