/*
 * Decompiled with CFR 0.152.
 */
package fuzs.vehicleupgrade.client.handler;

import fuzs.puzzleslib.api.client.renderer.v1.RenderStateExtraData;
import fuzs.vehicleupgrade.VehicleUpgrade;
import fuzs.vehicleupgrade.config.ClientConfig;
import fuzs.vehicleupgrade.init.ModRegistry;
import java.util.OptionalInt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;

public class TranslucentMountHandler {
    public static final ContextKey<OptionalInt> VEHICLE_ALPHA_KEY = new ContextKey(VehicleUpgrade.id("vehicle_alpha"));

    public static void onExtractRenderState(Entity entity, EntityRenderState renderState, float partialTick) {
        if (!((ClientConfig)VehicleUpgrade.CONFIG.get(ClientConfig.class)).translucentMount) {
            return;
        }
        if (Minecraft.getInstance().screen != null || !entity.getType().is(ModRegistry.TRANSLUCENT_MOUNTS_ENTITY_TYPE_TAG)) {
            return;
        }
        Entity cameraEntity = Minecraft.getInstance().getCameraEntity();
        if (cameraEntity != null && entity.isVehicle() && entity.hasPassenger(cameraEntity)) {
            float alpha = Mth.clamp((float)((cameraEntity.getXRot(partialTick) - 15.0f) / 45.0f), (float)0.0f, (float)1.0f);
            RenderStateExtraData.set((EntityRenderState)renderState, VEHICLE_ALPHA_KEY, (Object)OptionalInt.of(ARGB.as8BitChannel((float)(1.0f - 0.9f * alpha))));
        }
    }
}

