/*
 * Decompiled with CFR 0.152.
 */
package fuzs.vehicleupgrade.handler;

import fuzs.puzzleslib.api.container.v1.ContainerMenuHelper;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.util.v1.InteractionResultHelper;
import fuzs.vehicleupgrade.VehicleUpgrade;
import fuzs.vehicleupgrade.config.ServerConfig;
import fuzs.vehicleupgrade.init.ModRegistry;
import fuzs.vehicleupgrade.world.inventory.EquipmentInventoryMenu;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class MountInventoryHandler {
    public static EventResultHolder<InteractionResult> onUseEntity(Player player, Level level, InteractionHand interactionHand, Entity entity) {
        if (player.isSecondaryUseActive() && MountInventoryHandler.openInventoryScreen(level, entity, player)) {
            return EventResultHolder.interrupt((Object)InteractionResultHelper.SUCCESS);
        }
        return EventResultHolder.pass();
    }

    public static boolean openInventoryScreen(Level level, Entity entity, Player player) {
        if (!((ServerConfig)VehicleUpgrade.CONFIG.get(ServerConfig.class)).openMobInventoryByInteracting) {
            return false;
        }
        if (MountInventoryHandler.hasInventoryScreen(entity, player)) {
            if (level instanceof ServerLevel) {
                MountInventoryHandler.openInventoryScreen(entity, (ServerPlayer)player);
            }
            return true;
        }
        return false;
    }

    public static boolean hasInventoryScreen(Entity vehicleEntity, Player player) {
        TamableAnimal tamableAnimal;
        AbstractHorse abstractHorse;
        if (vehicleEntity instanceof AbstractHorse && !(abstractHorse = (AbstractHorse)vehicleEntity).isTamed()) {
            return false;
        }
        if (vehicleEntity instanceof TamableAnimal && !(tamableAnimal = (TamableAnimal)vehicleEntity).isTame()) {
            return false;
        }
        if (!MountInventoryHandler.canShearEquipment((Entity)player, player) && !vehicleEntity.hasPassenger((Entity)player)) {
            return false;
        }
        if (vehicleEntity instanceof HasCustomInventoryScreen) {
            return true;
        }
        return MountInventoryHandler.hasEquipmentScreen(vehicleEntity);
    }

    private static boolean canShearEquipment(Entity entity, Player player) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            return mob.canShearEquipment(player);
        }
        return !entity.isVehicle();
    }

    private static boolean hasEquipmentScreen(Entity vehicleEntity) {
        Mob mob;
        return vehicleEntity instanceof Mob && (mob = (Mob)vehicleEntity).getType().is(ModRegistry.CUSTOM_EQUIPMENT_USER_ENTITY_TYPE_TAG) && (mob.isSaddled() || mob.isWearingBodyArmor());
    }

    public static void openInventoryScreen(Entity vehicleEntity, ServerPlayer serverPlayer) {
        if (vehicleEntity instanceof HasCustomInventoryScreen) {
            HasCustomInventoryScreen hasCustomInventoryScreen = (HasCustomInventoryScreen)vehicleEntity;
            hasCustomInventoryScreen.openCustomInventoryScreen((Player)serverPlayer);
        } else if (vehicleEntity instanceof Mob) {
            Mob mob = (Mob)vehicleEntity;
            if (vehicleEntity.getType().is(ModRegistry.CUSTOM_EQUIPMENT_USER_ENTITY_TYPE_TAG)) {
                ContainerMenuHelper.openMenu((Player)serverPlayer, (MenuProvider)new SimpleMenuProvider((containerId, inventory, player) -> new EquipmentInventoryMenu(containerId, inventory, mob), mob.getDisplayName()), (Object)mob.getId());
            }
        }
    }
}

